/*
 * Decompiled with CFR 0.152.
 */
package org.logdoc.fairhttp.service.api.helpers.endpoint.invokers;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.logdoc.fairhttp.service.http.Request;
import org.logdoc.fairhttp.service.http.Response;

public abstract class ARequestInvoker
implements BiFunction<Request, Map<String, String>, Response> {
    protected final Method method;
    protected final Function<Throwable, Response> errorHandler;
    protected final int execTimeout;

    protected ARequestInvoker(Method method, Function<Throwable, Response> errorHandler, int execTimeout) {
        this.method = method;
        this.errorHandler = errorHandler;
        this.execTimeout = execTimeout;
    }

    @Override
    public final Response apply(Request request, Map<String, String> pathMap) {
        try {
            return (Response)((CompletableFuture)CompletableFuture.supplyAsync(this.supplyAction(request, pathMap)).exceptionally(e -> {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException((Throwable)e);
            })).get(this.execTimeout, TimeUnit.SECONDS);
        }
        catch (Exception e2) {
            return this.errorHandler.apply(e2);
        }
    }

    protected abstract Supplier<Response> supplyAction(Request var1, Map<String, String> var2);
}

