/*
 * Decompiled with CFR 0.152.
 */
package org.logdoc.fairhttp.service.http;

import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.logdoc.fairhttp.errors.BodyReadError;
import org.logdoc.fairhttp.service.http.Request;
import org.logdoc.fairhttp.service.http.Response;
import org.logdoc.fairhttp.service.tools.Json;
import org.logdoc.helpers.Digits;
import org.logdoc.helpers.Reflects;
import org.logdoc.helpers.Texts;
import org.logdoc.helpers.gears.Pair;

class EndpointResolver {
    EndpointResolver() {
    }

    static Collection<Argued> resolve(byte[] data) {
        return EndpointResolver.readPreforms(data).stream().map(p -> {
            Pair<Method, String> sign = EndpointResolver.invokerSignature(p.invoker);
            if (sign != null && sign.first != null) {
                return new Exposed(p.method, p.path, (Method)sign.first, Texts.notNull((Object)sign.second, (String)"()"));
            }
            return null;
        }).filter(Objects::nonNull).map(e -> {
            Argued a = new Argued((Exposed)e);
            EndpointResolver.fillArgs(a, e.args);
            return a.invMethod == null ? null : a;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static void fillArgs(Argued a, String args0) {
        String args = Texts.notNull((Object)args0.replaceAll("\\s", "").replace("()", ""));
        int count = Texts.isEmpty((Object)args) || args.equals("()") ? 0 : (args.contains(",") ? args.split(",").length : 1);
        boolean hasRq = args.toLowerCase(Locale.ROOT).contains("[request]");
        String mn = a.invMethod.getName();
        List possible = Reflects.findMethods(a.invMethod.getDeclaringClass()).stream().filter(m -> m.getName().equals(mn) && (m.getParameterCount() == count || m.getParameterCount() == count + (hasRq ? 0 : 1))).collect(Collectors.toList());
        if (possible.isEmpty()) {
            a.invMethod = null;
            return;
        }
        ArrayList<String> defs = count == 0 ? new ArrayList<String>(0) : new ArrayList<String>(Arrays.asList(args.split(",")));
        ArrayList solved = new ArrayList(0);
        Method matched = null;
        for (Method cm : possible) {
            int i;
            List<Class<?>> given = Arrays.asList(cm.getParameterTypes());
            if (!hasRq) {
                for (i = 0; i < given.size(); ++i) {
                    if (!Request.class.isAssignableFrom(given.get(i))) continue;
                    defs.add(i, "[Request]");
                    break;
                }
            }
            if (defs.size() != given.size()) continue;
            matched = cm;
            for (i = 0; i < defs.size(); ++i) {
                String d = Texts.notNull(defs.get(i));
                Class<?> g = given.get(i);
                if (d.toLowerCase(Locale.ROOT).contains("[request]") && Request.class.isAssignableFrom(g)) {
                    solved.add(new Argued.Arg<Request>(Request.class, (req, pathMap) -> req, null, i));
                    continue;
                }
                if (d.toLowerCase(Locale.ROOT).contains("[body]")) {
                    solved.add(new Argued.Arg(g, (req, pathMap) -> {
                        try {
                            return req.jsonmap(g);
                        }
                        catch (BodyReadError e) {
                            throw new RuntimeException(e);
                        }
                    }, null, i));
                    continue;
                }
                try {
                    BiFunction<Request, Map, String> getString;
                    String name;
                    if (d.contains("[")) {
                        Argued.Arg.Cnt c = Argued.Arg.Cnt.valueOf(Texts.capitalize((String)d.substring(d.indexOf(91) + 1, d.indexOf(93))));
                        name = Texts.notNull((Object)d.substring(0, d.indexOf(91)));
                        if (Texts.isEmpty((Object)name)) {
                            throw new Exception();
                        }
                        switch (c) {
                            case Cookie: {
                                getString = (req, pathMap) -> req.cookie(name);
                                break;
                            }
                            case Path: {
                                getString = (req, pathMap) -> (String)pathMap.get(name);
                                break;
                            }
                            case Query: {
                                getString = (req, pathMap) -> req.queryParam(name);
                                break;
                            }
                            case Form: {
                                getString = (req, pathMap) -> {
                                    try {
                                        return req.bodyForm().field(name);
                                    }
                                    catch (BodyReadError e) {
                                        throw new RuntimeException(e);
                                    }
                                };
                                break;
                            }
                            default: {
                                throw new Exception();
                            }
                        }
                    } else {
                        name = Texts.notNull((Object)d);
                        getString = (req, pathMap) -> {
                            String s = (String)pathMap.get(name);
                            if (s != null) {
                                return s;
                            }
                            try {
                                s = req.bodyForm().field(name);
                                if (s != null) {
                                    return s;
                                }
                            }
                            catch (BodyReadError e) {
                                throw new RuntimeException(e);
                            }
                            s = req.queryParam(name);
                            if (s != null) {
                                return s;
                            }
                            return req.cookie(name);
                        };
                    }
                    BiFunction<String, Function, Object> isNil = (s, pass) -> s == null ? null : pass.apply(s);
                    BiFunction<Request, Map, Object> magic = String.class.isAssignableFrom(g) ? getString : (g.equals(Short.TYPE) ? (req, pathMap) -> Digits.getShort(getString.apply((Request)req, (Map)pathMap)) : (g.equals(Integer.TYPE) ? (req, pathMap) -> Digits.getInt(getString.apply((Request)req, (Map)pathMap)) : (g.equals(Long.TYPE) ? (req, pathMap) -> Digits.getLong(getString.apply((Request)req, (Map)pathMap)) : (g.equals(Double.TYPE) ? (req, pathMap) -> Digits.getDouble(getString.apply((Request)req, (Map)pathMap)) : (g.equals(Float.TYPE) ? (req, pathMap) -> Float.valueOf(Digits.getFloat(getString.apply((Request)req, (Map)pathMap))) : (g.equals(Boolean.TYPE) ? (req, pathMap) -> Texts.getBoolean(getString.apply((Request)req, (Map)pathMap)) : (g.equals(Character.TYPE) ? (req, pathMap) -> {
                        String s = (String)getString.apply((Request)req, (Map)pathMap);
                        return Character.valueOf(s.isEmpty() ? (char)'\u0000' : s.charAt(0));
                    } : (g.equals(Byte.TYPE) ? (req, pathMap) -> {
                        String s = (String)getString.apply((Request)req, (Map)pathMap);
                        return s.isEmpty() ? 0 : s.getBytes(StandardCharsets.UTF_8)[0];
                    } : (Long.class.isAssignableFrom(g) ? (req, pathMap) -> isNil.apply((String)getString.apply((Request)req, (Map)pathMap), Digits::getLong) : (Integer.class.isAssignableFrom(g) ? (req, pathMap) -> isNil.apply((String)getString.apply((Request)req, (Map)pathMap), Digits::getInt) : (Short.class.isAssignableFrom(g) ? (req, pathMap) -> isNil.apply((String)getString.apply((Request)req, (Map)pathMap), Digits::getShort) : (Float.class.isAssignableFrom(g) ? (req, pathMap) -> isNil.apply((String)getString.apply((Request)req, (Map)pathMap), Digits::getFloat) : (Double.class.isAssignableFrom(g) ? (req, pathMap) -> isNil.apply((String)getString.apply((Request)req, (Map)pathMap), Digits::getDouble) : (Boolean.class.isAssignableFrom(g) ? (req, pathMap) -> isNil.apply((String)getString.apply((Request)req, (Map)pathMap), Texts::getBoolean) : (Character.class.isAssignableFrom(g) ? (req, pathMap) -> isNil.apply((String)getString.apply((Request)req, (Map)pathMap), s -> s.isEmpty() ? null : Character.valueOf(s.charAt(0))) : (Byte.class.isAssignableFrom(g) ? (req, pathMap) -> isNil.apply((String)getString.apply((Request)req, (Map)pathMap), s -> s.isEmpty() ? null : Byte.valueOf(s.getBytes(StandardCharsets.UTF_8)[0])) : (req, pathMap) -> {
                        try {
                            return Json.fromJson(Json.parse((String)getString.apply((Request)req, (Map)pathMap)), g);
                        }
                        catch (RuntimeException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }))))))))))))))));
                    solved.add(new Argued.Arg(g, magic, name, i));
                    continue;
                }
                catch (Exception ignore) {
                    matched = null;
                    break;
                }
            }
            if (matched == null) continue;
            break;
        }
        if (matched == null) {
            a.invMethod = null;
            return;
        }
        a.args.addAll(solved);
    }

    private static Pair<Method, String> invokerSignature(String inv) {
        Method method;
        String sign;
        int idx = inv.indexOf(40);
        String args = idx != -1 ? Texts.notNull((Object)inv.substring(idx).replace("(", "").replace(")", "")) : null;
        String string = sign = idx != -1 ? Texts.notNull((Object)inv.substring(0, idx)) : Texts.notNull((Object)inv);
        if (Texts.isEmpty((Object)inv) || (idx = inv.lastIndexOf(46)) == -1) {
            return null;
        }
        String cls = sign.substring(0, idx);
        String mth = sign.substring(idx + 1);
        try {
            Class<?> c = Class.forName(cls);
            method = Reflects.findMethods(c).stream().filter(m -> m.getName().equals(mth) && m.trySetAccessible() && (Response.class.isAssignableFrom(m.getReturnType()) || CompletionStage.class.isAssignableFrom(m.getReturnType()))).findAny().orElse(null);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return Pair.create((Object)method, (Object)args);
    }

    private static List<Preform> readPreforms(byte[] content) {
        CharBuf cb = new CharBuf(content, '#');
        ArrayList<Preform> out = new ArrayList<Preform>(16);
        while (cb.markNonEmpty()) {
            cb.pos2mark().markEmpty();
            Preform p = new Preform();
            if (!p.method(cb.marked())) {
                p.crook();
            }
            if (cb.markNonEmpty()) {
                cb.pos2mark().markEmpty();
                if (!p.path(cb.marked())) {
                    p.crook();
                }
                if (cb.markNonEmpty()) {
                    cb.pos2mark();
                    if (cb.hasFurther('(', true)) {
                        cb.mark(')', true);
                    } else {
                        cb.markEmpty();
                    }
                    if (!p.invoker(cb.marked())) {
                        p.crook();
                    }
                } else {
                    p.crook();
                }
            } else {
                p.crook();
            }
            if (p.isCrooked()) continue;
            out.add(p);
        }
        return out;
    }

    private static class CharBuf {
        private final char[] data;
        private int pos;
        private int mark;

        CharBuf(byte[] content, char commentChar) {
            Object s = new String(content, StandardCharsets.UTF_8);
            if (commentChar != '\u0000') {
                int idx;
                while ((idx = ((String)s).indexOf(commentChar)) != -1) {
                    int idx2 = ((String)s).indexOf(10, idx + 1);
                    s = ((String)s).substring(0, idx) + (idx2 != -1 ? ((String)s).substring(idx2) : "");
                }
            }
            this.data = ((String)s).toCharArray();
            this.mark = -1;
        }

        boolean markNonEmpty() {
            for (int i = this.pos; i < this.data.length; ++i) {
                if (Character.isWhitespace(this.data[i])) continue;
                this.mark = i;
                return true;
            }
            return false;
        }

        void markEmpty() {
            for (int i = this.pos; i < this.data.length; ++i) {
                if (!Character.isWhitespace(this.data[i])) continue;
                this.mark = i;
                return;
            }
            this.mark = this.data.length;
        }

        CharBuf pos2mark() {
            this.pos = Math.max(this.mark, this.pos);
            this.mark = -1;
            return this;
        }

        String marked() {
            try {
                String string = this.mark > this.pos ? new String(Arrays.copyOfRange(this.data, this.pos, this.mark)) : null;
                return string;
            }
            finally {
                this.pos = this.mark;
            }
        }

        public boolean hasFurther(char ch, boolean breakOnWhitespace) {
            for (int i = this.pos; i < this.data.length; ++i) {
                if (this.data[i] == ch) {
                    return true;
                }
                if (!breakOnWhitespace || !Character.isWhitespace(this.data[i])) continue;
                return false;
            }
            return false;
        }

        public void mark(char c, boolean shiftAfter) {
            for (int i = this.pos + 1; i < this.data.length; ++i) {
                if (this.data[i] != c) continue;
                this.mark = i;
                if (shiftAfter) {
                    ++this.mark;
                }
                return;
            }
            this.mark = this.data.length;
        }
    }

    private static class Preform {
        private String method;
        private String path;
        private String invoker;
        private boolean crooked;

        private Preform() {
        }

        void crook() {
            this.crooked = true;
        }

        boolean isCrooked() {
            return this.crooked;
        }

        boolean method(String s) {
            this.method = this.clean(s);
            return this.method != null && this.method.matches("^[A-Z]+$");
        }

        boolean path(String s) {
            this.path = this.clean(s);
            return this.path != null;
        }

        boolean invoker(String s) {
            this.invoker = this.clean(s);
            return this.invoker != null;
        }

        private String clean(String s) {
            if (Texts.isEmpty((Object)s)) {
                return null;
            }
            return s.replaceAll("\\s", "");
        }

        public String toString() {
            return "Preform{method='" + this.method + "', path='" + this.path + "', invoker='" + this.invoker + "'}";
        }
    }

    private static class Exposed {
        private final String method;
        private final String path;
        private final Method invMethod;
        private final String args;

        public Exposed(String method, String path, Method invMethod, String args) {
            this.method = method;
            this.path = path;
            this.invMethod = invMethod;
            this.args = args;
        }

        public String toString() {
            return "Exposed{method='" + this.method + "', path='" + this.path + "', invMethod=" + this.invMethod + ", args='" + this.args + "'}";
        }
    }

    static class Argued {
        String method;
        String path;
        Method invMethod;
        SortedSet<Arg<?>> args;

        private Argued(Exposed e) {
            this.method = e.method;
            this.path = e.path;
            this.invMethod = e.invMethod;
            this.args = new TreeSet();
        }

        public String toString() {
            return "Argued{method='" + this.method + "', path='" + this.path + "', invMethod=" + this.invMethod.getName() + ", args=" + this.args + "}";
        }

        static class Arg<T>
        implements Comparable<Arg<T>> {
            public Class<T> cls;
            public String refName;
            public int order;
            public BiFunction<Request, Map<String, String>, T> magic;

            public Arg(Class<T> cls, BiFunction<Request, Map<String, String>, ?> magic, String refName, int order) {
                this.cls = cls;
                this.magic = magic;
                this.refName = refName;
                this.order = order;
            }

            public String toString() {
                return "Arg{cls=" + this.cls.getSimpleName() + (String)(this.refName != null ? ", refName='" + this.refName + "'" : "") + "}";
            }

            @Override
            public int compareTo(Arg<T> o) {
                return Integer.compare(this.order, o.order);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof Arg)) {
                    return false;
                }
                Arg arg = (Arg)o;
                return this.order == arg.order;
            }

            public int hashCode() {
                return Objects.hash(this.order);
            }

            public static enum Cnt {
                Form,
                Body,
                Query,
                Cookie,
                Path,
                Unknown,
                Request;

            }
        }
    }
}

