/*
 * Decompiled with CFR 0.152.
 */
package org.logdoc.fairhttp.service.http;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.logdoc.fairhttp.service.http.RCBackup;
import org.logdoc.fairhttp.service.http.RequestId;
import org.logdoc.fairhttp.service.http.Response;
import org.logdoc.fairhttp.service.http.WebSocket;
import org.logdoc.fairhttp.service.http.tasks.RCHeaders;
import org.logdoc.fairhttp.service.http.tasks.RCSignature;
import org.logdoc.fairhttp.service.tools.ResourceConnect;
import org.logdoc.helpers.Digits;
import org.logdoc.helpers.Sporadics;
import org.logdoc.helpers.Texts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RCWrap
implements ResourceConnect {
    private static final Logger logger = LoggerFactory.getLogger(RCWrap.class);
    private final UUID uuid = Sporadics.generateUuid();
    private final Socket socket;
    private final int maxRequestSize;
    private final int readTimeout;
    private final RCBackup backup;
    private RequestId requestId;

    RCWrap(Socket socket, int maxRequestSize, int readTimeout, RCBackup backup) throws IOException {
        socket.setSoTimeout(readTimeout);
        this.socket = socket;
        this.backup = backup;
        this.maxRequestSize = maxRequestSize;
        this.readTimeout = readTimeout;
        CompletableFuture<RequestId> getIdStage = new CompletableFuture<RequestId>();
        getIdStage.thenAccept(this::gotId);
        getIdStage.exceptionally(this.failed());
        backup.submit(new RCSignature(socket, getIdStage));
    }

    @Override
    public Socket getInput() {
        return this.socket;
    }

    private <K> Function<Throwable, K> failed() {
        return e -> {
            this.write(Response.ServerError(e.getMessage()));
            this.seppukku();
            return null;
        };
    }

    private void seppukku() {
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.backup.meDead(this);
    }

    private void gotId(RequestId requestId) {
        if (!this.backup.canProcess(requestId)) {
            this.write(Response.NotFound());
            this.seppukku();
            return;
        }
        this.requestId = requestId;
        CompletableFuture<Map<String, String>> getHeaders = new CompletableFuture<Map<String, String>>();
        getHeaders.thenAccept(this::gotHeaders);
        getHeaders.exceptionally(this.failed());
        this.backup.submit(new RCHeaders(this.socket, getHeaders));
    }

    private void gotHeaders(Map<String, String> headers) {
        if (headers == null || headers.isEmpty()) {
            this.write(Response.ClientError("Insufficient headers block"));
            this.seppukku();
            return;
        }
        if (Digits.getInt((Object)headers.get("Content-Length")) > this.maxRequestSize) {
            this.write(Response.ClientError("Max request size limit is exceeded: " + headers.get("Content-Length") + " / " + this.maxRequestSize));
            this.seppukku();
            return;
        }
        try {
            this.socket.setSoTimeout(this.readTimeout);
        }
        catch (SocketException e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.write(Response.ServerError("Internal error"));
            this.seppukku();
        }
        this.backup.handleRequest(this.requestId, headers, this);
    }

    @Override
    public void write(Response response) {
        if (response == null) {
            return;
        }
        if (response instanceof WebSocket) {
            ((WebSocket)response).spinOff(this.socket);
            this.backup.meDead(this);
            return;
        }
        try {
            this.socket.getOutputStream().write(response.asBytes());
            this.socket.getOutputStream().flush();
        }
        catch (IOException e) {
            logger.error("Cant write response: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.seppukku();
        }
    }

    @Override
    public void write(byte[] data) {
        if (Texts.isEmpty((Object)data)) {
            return;
        }
        try {
            this.socket.getOutputStream().write(data);
            this.socket.getOutputStream().flush();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.seppukku();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RCWrap)) {
            return false;
        }
        RCWrap rcWrap = (RCWrap)o;
        return Objects.equals(this.uuid, rcWrap.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }
}

