/*
 * Decompiled with CFR 0.152.
 */
package org.logdoc.fairhttp.service.http;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.logdoc.fairhttp.errors.BodyReadError;
import org.logdoc.fairhttp.service.http.RequestId;
import org.logdoc.fairhttp.service.tools.Form;
import org.logdoc.fairhttp.service.tools.Json;
import org.logdoc.fairhttp.service.tools.MapAttributed;
import org.logdoc.fairhttp.service.tools.MultiForm;
import org.logdoc.fairhttp.service.tools.ParameterParser;
import org.logdoc.fairhttp.service.tools.websocket.extension.IExtension;
import org.logdoc.fairhttp.service.tools.websocket.protocol.IProtocol;
import org.logdoc.helpers.Digits;
import org.logdoc.helpers.Texts;
import org.logdoc.helpers.std.MimeType;
import org.logdoc.helpers.std.MimeTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Request
extends MapAttributed {
    private static final Logger logger = LoggerFactory.getLogger(Request.class);
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static final byte DASH = 45;
    public static final byte[] streamEnd = new byte[]{45, 45};
    public static final byte[] headerSeparator = new byte[]{13, 10, 13, 10};
    public static final byte[] fieldSeparator = new byte[]{13, 10};
    public static final byte[] boundaryPrefix = new byte[]{13, 10, 45, 45};
    private final RequestId id;
    private final Map<String, String> headers;
    private final Socket socket;
    private final int maxRequestSize;
    private Map<String, String> c;
    private int contentLength;
    private boolean chunked;
    private boolean gzip;
    private boolean deflate;
    private byte[] body;
    private String bs;
    private JsonNode bj;
    private Form bf;
    private MultiForm bm;

    Request(RequestId id, Map<String, String> headers, Socket socket, int maxRequestSize) {
        this.id = id;
        this.headers = headers;
        this.socket = socket;
        this.maxRequestSize = maxRequestSize;
    }

    public Socket getSocket() {
        return this.socket;
    }

    private String stringQuotes(String value) {
        if (value == null) {
            return null;
        }
        if (!(value = Texts.notNull((Object)value)).startsWith("\"")) {
            return value;
        }
        return value.substring(1, value.length() - 1);
    }

    public boolean isWebsocketUpgradable() {
        return this.isWebsocketUpgradable(null, null);
    }

    public boolean isWebsocketUpgradable(IExtension extension) {
        return this.isWebsocketUpgradable(extension, null);
    }

    public boolean isWebsocketUpgradable(IExtension extension, IProtocol protocol) {
        try {
            MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException ignore) {
            return false;
        }
        return !(!"13".equals(this.header("Sec-WebSocket-Version")) || extension != null && !extension.acceptProvidedExtensionAsServer(this.header("Sec-WebSocket-Extensions")) || protocol != null && !protocol.acceptProtocol(this.header("Sec-WebSocket-Protocol")));
    }

    public SocketAddress getRemote() {
        return this.socket.getRemoteSocketAddress();
    }

    public String method() {
        return this.id.method;
    }

    public String path() {
        return this.id.path;
    }

    public String uri() {
        return this.id.uri;
    }

    public String queryParam(String name) {
        return this.id.query(name);
    }

    public String header(String name) {
        return this.headers.get(name);
    }

    private void calcBody() {
        this.contentLength = Digits.getInt((Object)this.headers.get("Content-Length"));
        String te = Texts.notNull((Object)this.headers.get("Transfer-Encoding"));
        this.chunked = te.contains("chunked");
        this.gzip = te.contains("gzip");
        this.deflate = te.contains("deflate");
    }

    private InputStream getIs() throws IOException {
        InputStream is = this.socket.getInputStream();
        if (this.gzip) {
            return new GZIPInputStream(is);
        }
        if (this.deflate) {
            return new InflaterInputStream(is);
        }
        return is;
    }

    public byte[] bodyBytes() throws BodyReadError {
        if (this.body != null) {
            return this.body;
        }
        this.calcBody();
        if (this.chunked) {
            this.body = this.readChunks();
            return this.body;
        }
        if (this.contentLength <= 0) {
            this.body = new byte[0];
            return this.body;
        }
        this.body = new byte[this.contentLength];
        try {
            int read;
            InputStream is = this.getIs();
            for (int total = 0; total != this.contentLength; total += read) {
                read = is.read(this.body, total, this.contentLength - total);
                if (read != -1) continue;
                throw new BodyReadError("Cant read " + this.contentLength + " bytes of body, got only " + total);
            }
            return this.body;
        }
        catch (BodyReadError be) {
            throw be;
        }
        catch (Exception e) {
            throw new BodyReadError(e);
        }
    }

    public String bodyString() throws BodyReadError {
        if (this.bs != null) {
            return this.bs;
        }
        this.bs = new String(this.bodyBytes(), StandardCharsets.UTF_8);
        return this.bs;
    }

    public JsonNode bodyJson() throws BodyReadError {
        if (this.bj != null) {
            return this.bj;
        }
        this.bj = Json.parse(this.bodyBytes());
        return this.bj;
    }

    public Form bodyForm() throws BodyReadError {
        if (this.bf != null) {
            return this.bf;
        }
        this.bf = new Form();
        String bs = this.bodyString();
        Arrays.stream(bs.split(Pattern.quote("&"))).map(pair -> pair.split(Pattern.quote("="))).forEach(kv -> {
            String v = URLDecoder.decode(kv[1], StandardCharsets.UTF_8);
            if (Texts.isEmpty((Object)v)) {
                if (!this.bf.containsKey(kv[0])) {
                    this.bf.put(kv[0], new ArrayList(2));
                }
                ((List)this.bf.get(kv[0])).add(v);
            }
        });
        return this.bf;
    }

    public MultiForm bodyMultiForm() throws BodyReadError {
        if (this.bm != null) {
            return this.bm;
        }
        try {
            byte[] body = this.bodyBytes();
            this.bm = new MultiForm();
            byte[] bnd = new MimeType(this.header("Content-Type")).getParameter("boundary").getBytes(StandardCharsets.ISO_8859_1);
            boolean done = false;
            int i = 0;
            while (!done) {
                int hdr;
                HashMap<String, String> partHeaders = new HashMap<String, String>(8){

                    @Override
                    public String put(String key, String value) {
                        return super.put(key.toUpperCase(), value);
                    }

                    @Override
                    public String get(Object key) {
                        return (String)super.get(String.valueOf(key).toUpperCase());
                    }
                };
                if ((i = this.indexOf(body, bnd, i)) == -1) break;
                int hdrs = this.indexOf(body, headerSeparator, (i += bnd.length) + 1);
                if (hdrs <= i) continue;
                while ((hdr = this.indexOf(body, fieldSeparator, i)) <= hdrs) {
                    String hs = Texts.notNull((Object)new String(Arrays.copyOfRange(body, i, hdr), StandardCharsets.UTF_8));
                    int sep = hs.indexOf(58);
                    if (sep != -1) {
                        partHeaders.put(Texts.notNull((Object)hs.substring(0, sep)), Texts.notNull((Object)hs.substring(sep + 1)));
                    }
                    i = hdr + fieldSeparator.length;
                }
                int till = this.indexOf(body, boundaryPrefix, i += 2);
                if (till == -1) {
                    done = true;
                    till = this.indexOf(body, streamEnd, i);
                }
                byte[] pb = Arrays.copyOfRange(body, i, till);
                i = till;
                String cd = (String)partHeaders.get("Content-disposition");
                if (cd == null) continue;
                MimeType cType = MimeTypes.TEXTPLAIN;
                try {
                    cType = new MimeType((String)partHeaders.get("Content-Type"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String fileName = null;
                String fieldName = null;
                String cdl = cd.trim().toLowerCase();
                if (cdl.startsWith("form-data") || cdl.startsWith("attachment")) {
                    try {
                        ParameterParser parser = new ParameterParser();
                        parser.setLowerCaseNames();
                        Map<String, String> parameters = parser.parse(cd, ';');
                        fileName = parameters.get("filename");
                        fieldName = parameters.get("name");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (Texts.isEmpty(fieldName)) continue;
                if (!Texts.isEmpty(fileName)) {
                    this.bm.fileData(fieldName, fileName, pb, cType);
                    continue;
                }
                if (cType.getBaseType().startsWith("text/")) {
                    this.bm.textData(fieldName, new String(pb, StandardCharsets.UTF_8));
                    continue;
                }
                this.bm.binData(fieldName, pb, (Map<String, String>)partHeaders);
            }
            return this.bm;
        }
        catch (BodyReadError e) {
            throw e;
        }
        catch (Exception e) {
            throw new BodyReadError(e);
        }
    }

    private int indexOf(byte[] data, byte[] match, int from) {
        block0: for (int i = from; i < data.length - match.length; ++i) {
            for (int j = 0; j < match.length; ++j) {
                if (data[i + j] != match[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    private byte[] readChunks() throws BodyReadError {
        byte[] byArray;
        InputStream is = this.getIs();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(16384);
        try {
            int chunkSize;
            int sum = 0;
            do {
                if ((chunkSize = this.getChunkSize(is)) <= 0) continue;
                if (this.maxRequestSize > 0 && (sum += chunkSize) > this.maxRequestSize) {
                    throw new IllegalStateException("Max request size is exceeded: " + this.maxRequestSize);
                }
                for (int i = 0; i < chunkSize; ++i) {
                    bos.write(is.read());
                }
            } while (chunkSize > 0);
            bos.flush();
            byArray = bos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    bos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new BodyReadError(e);
            }
        }
        bos.close();
        return byArray;
    }

    private int getChunkSize(InputStream is) throws IOException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream(8);){
            int b;
            do {
                if (Character.digit(b = is.read(), 16) == -1) continue;
                os.write(b);
            } while (b != 10);
            int n = Integer.parseInt(os.toString(StandardCharsets.US_ASCII), 16);
            return n;
        }
    }

    public boolean hasHeader(String name) {
        return this.header(name) != null;
    }

    public String cookie(String name) {
        return this.cookies().get(name);
    }

    public Map<String, String> cookies() {
        if (this.c == null) {
            HashMap m = new HashMap();
            String v = this.header("Cookie");
            if (!Texts.isEmpty((Object)v)) {
                Arrays.stream(v.split(";")).filter(s -> s.contains("=")).forEach(c -> {
                    String[] parts = c.split(Pattern.quote("="), 2);
                    if (parts.length != 2) {
                        return;
                    }
                    m.put(Texts.notNull((Object)parts[0]), this.stringQuotes(parts[1]));
                });
            }
            this.c = Collections.unmodifiableMap(m);
        }
        return this.c;
    }

    public <T> T jsonmap(Class<? extends T> klass) throws BodyReadError {
        return Json.fromJson(this.bodyJson(), klass);
    }
}

