/*
 * Decompiled with CFR 0.152.
 */
package org.logdoc.fairhttp.service.http;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class RequestId {
    public final String method;
    public final String uri;
    public final String path;
    private final Map<String, String> q;

    public RequestId(String method, String resource) {
        this.method = method;
        this.uri = resource;
        if (this.uri.indexOf(63) == -1) {
            this.path = this.uri;
            this.q = Collections.emptyMap();
        } else {
            this.path = this.uri.substring(0, this.uri.indexOf(63));
            HashMap qm = new HashMap(4);
            Arrays.stream(this.uri.substring(this.uri.indexOf(63) + 1).split(Pattern.quote("&"))).map(pair -> pair.split(Pattern.quote("="))).filter(pair -> ((String[])pair).length > 1).forEach(kv -> {
                String v = null;
                try {
                    v = URLDecoder.decode(kv[1], StandardCharsets.UTF_8);
                }
                catch (IllegalArgumentException ignore) {
                    v = URLDecoder.decode(kv[1], StandardCharsets.US_ASCII);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (v != null) {
                    qm.put(kv[0], v);
                }
            });
            this.q = Collections.unmodifiableMap(qm);
        }
    }

    public String query(String name) {
        return this.q.get(name);
    }
}

