/*
 * Decompiled with CFR 0.152.
 */
package org.logdoc.fairhttp.service.http;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.logdoc.fairhttp.service.api.Controller;
import org.logdoc.fairhttp.service.http.Cookie;
import org.logdoc.fairhttp.service.http.WebSocket;
import org.logdoc.fairhttp.service.tools.Json;
import org.logdoc.fairhttp.service.tools.MapAttributed;
import org.logdoc.fairhttp.service.tools.PhasedConsumer;
import org.logdoc.helpers.Texts;
import org.logdoc.helpers.std.MimeType;

public class Response
extends MapAttributed {
    public static final byte[] FEED = new byte[]{13, 10};
    private static final byte[] PROTO = "HTTP/1.1".getBytes(StandardCharsets.US_ASCII);
    protected final Map<String, String> headers = new HashMap<String, String>(2);
    private final Set<Cookie> cookies;
    int code;
    private String message;
    private byte[] payload;
    private Consumer<OutputStream> promise;

    private Response() {
        this.headers.put("Server", "FairHttpServer/2.0.0");
        this.headers.put("Connection", "keep-alive");
        this.cookies = new HashSet<Cookie>(2);
    }

    public Response(int code, String message) {
        this.headers.put("Server", "FairHttpServer/2.0.0");
        this.headers.put("Connection", "keep-alive");
        this.cookies = new HashSet<Cookie>(2);
        this.code = code;
        this.message = message;
    }

    public static Response jsonSuccess() {
        return Controller.ok((JsonNode)Json.newObject().put("success", true));
    }

    public static Response Ok() {
        return new Response(200, "OK");
    }

    public static Response Created() {
        return new Response(201, "Created");
    }

    public static Response NoContent() {
        return new Response(204, "No content");
    }

    public static Response NotFound() {
        return new Response(404, "Not found");
    }

    public static Response NotFound(String message) {
        return new Response(404, message);
    }

    public static Response Forbidden() {
        return new Response(403, "Access forbidden");
    }

    public static Response ServerError() {
        return new Response(500, "Internal error");
    }

    public static Response ServerError(String reason) {
        return new Response(500, reason);
    }

    public static Response ClientError(String reason) {
        return new Response(400, reason);
    }

    public void setPromise(Consumer<OutputStream> promise) {
        if (promise == null) {
            return;
        }
        this.promise = promise;
        this.payload = null;
    }

    public void setPayload(byte[] payload, MimeType contentType) {
        if (Texts.isEmpty((Object)payload)) {
            return;
        }
        if (contentType == null) {
            throw new NullPointerException("Content-Type");
        }
        this.payload = payload;
        this.header("Content-Type", contentType.toString());
        this.header("Content-Length", String.valueOf(payload.length));
        this.promise = null;
    }

    public void header(String name, Object value) {
        if (Texts.isEmpty((Object)name) || Texts.isEmpty((Object)value)) {
            return;
        }
        this.headers.put(name.trim(), Texts.notNull((Object)value));
    }

    byte[] asBytes() throws IOException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream(65536);){
            os.write(PROTO);
            os.write((" " + this.code + (String)(Texts.isEmpty((Object)this.message) ? "" : " " + this.message)).getBytes(StandardCharsets.US_ASCII));
            os.write(FEED);
            if (this.promise != null && PhasedConsumer.class.isAssignableFrom(this.promise.getClass())) {
                ((PhasedConsumer)this.promise).warmUp(os);
            }
            if (Texts.isEmpty((Object)this.payload) && this.promise == null && !(this instanceof WebSocket)) {
                this.header("Content-Length", 0);
            }
            this.header("Date", LocalDateTime.now().atOffset(ZoneOffset.UTC).format(DateTimeFormatter.RFC_1123_DATE_TIME));
            for (Map.Entry<String, String> e : this.headers.entrySet()) {
                if (Texts.isEmpty((Object)e.getValue()) || Texts.isEmpty((Object)e.getKey())) continue;
                os.write((e.getKey() + ": " + e.getValue()).getBytes(StandardCharsets.UTF_8));
                os.write(FEED);
            }
            for (Cookie c : this.cookies) {
                os.write(("Set-Cookie: " + c).getBytes(StandardCharsets.UTF_8));
                os.write(FEED);
            }
            os.write(FEED);
            if (!Texts.isEmpty((Object)this.payload) && !(this instanceof WebSocket)) {
                os.write(this.payload);
            } else if (this.promise != null) {
                this.promise.accept(os);
            }
            os.flush();
            Object object = os.toByteArray();
            return object;
        }
    }

    public String toString() {
        return this.code + (String)(Texts.isEmpty((Object)this.message) ? "" : " " + this.message) + (String)(this.payload == null ? "" : " :: " + this.payload.length + " bytes");
    }

    public Response withCookie(Cookie ... cookies) {
        if (!Texts.isEmpty((Object)cookies)) {
            for (Cookie c : cookies) {
                if (c == null) continue;
                this.cookies.add(c);
            }
        }
        return this;
    }

    public Response withHeader(String name, String value) {
        if (!Texts.isEmpty((Object)value) && !Texts.isEmpty((Object)name)) {
            this.header(name.trim(), value.trim());
        }
        return this;
    }

    public int size() {
        return this.payload == null ? -1 : this.payload.length;
    }

    public Response as(MimeType mime) {
        if (mime != null) {
            this.header("Content-Type", mime);
        }
        return this;
    }

    public boolean is200() {
        return this.code == 200;
    }
}

