/*
 * Decompiled with CFR 0.152.
 */
package org.logdoc.fairhttp.service.http;

import com.typesafe.config.Config;
import java.net.Inet4Address;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.logdoc.fairhttp.service.api.helpers.Route;
import org.logdoc.fairhttp.service.api.helpers.endpoint.Endpoint;
import org.logdoc.fairhttp.service.api.helpers.endpoint.Signature;
import org.logdoc.fairhttp.service.api.helpers.endpoint.invokers.ARequestInvoker;
import org.logdoc.fairhttp.service.api.helpers.endpoint.invokers.DirectInvoker;
import org.logdoc.fairhttp.service.api.helpers.endpoint.invokers.DirectUnresolvingInvoker;
import org.logdoc.fairhttp.service.api.helpers.endpoint.invokers.IndirectInvoker;
import org.logdoc.fairhttp.service.api.helpers.endpoint.invokers.IndirectUnresolvingInvoker;
import org.logdoc.fairhttp.service.http.CORS;
import org.logdoc.fairhttp.service.http.EndpointResolver;
import org.logdoc.fairhttp.service.http.RCBackup;
import org.logdoc.fairhttp.service.http.RCWrap;
import org.logdoc.fairhttp.service.http.Request;
import org.logdoc.fairhttp.service.http.RequestId;
import org.logdoc.fairhttp.service.http.Response;
import org.logdoc.fairhttp.service.http.statics.AssetsRead;
import org.logdoc.fairhttp.service.http.statics.BundledRead;
import org.logdoc.fairhttp.service.http.statics.DirectRead;
import org.logdoc.fairhttp.service.http.statics.NoStatics;
import org.logdoc.fairhttp.service.tools.ConfigTools;
import org.logdoc.fairhttp.service.tools.ResourceConnect;
import org.logdoc.helpers.Digits;
import org.logdoc.helpers.Texts;
import org.logdoc.helpers.gears.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server
implements RCBackup {
    private static final Logger logger = LoggerFactory.getLogger(Server.class);
    private static Server backRef = null;
    private final SortedSet<Endpoint> endpoints;
    private final int port;
    private final int maxRequestBytes;
    private final int readTimeout;
    private final int execTimeout;
    private final AssetsRead assets;
    private final CORS cors;
    private final Map<Integer, String> maps;
    private final ExecutorService executorService;
    private Function<Throwable, Response> errorHandler;
    private List<ResourceConnect> rcs = new ArrayList<ResourceConnect>();

    public Server(int port, int maxRequestBytes) {
        this.port = port;
        this.maxRequestBytes = maxRequestBytes;
        this.readTimeout = 15000;
        this.execTimeout = 180;
        this.endpoints = new TreeSet<Endpoint>();
        this.maps = new HashMap<Integer, String>(0);
        this.assets = new NoStatics();
        this.cors = new CORS(null);
        this.errorHandler = throwable -> {
            if (throwable != null) {
                logger.error(throwable.getMessage(), throwable);
            }
            return throwable == null ? Response.ServerError() : Response.ServerError(throwable.getMessage());
        };
        this.executorService = Executors.newCachedThreadPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Server(Config config) {
        Class<Server> clazz = Server.class;
        synchronized (Server.class) {
            if (backRef != null) {
                throw new IllegalStateException("Only one instance can be started");
            }
            backRef = this;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.port = config.getInt("fair.http.port");
            this.maxRequestBytes = config.getBytes("fair.http.max_request_body").intValue();
            this.readTimeout = config.getInt("fair.http.request_read_timeout_ms");
            this.execTimeout = config.getInt("fair.http.handler_exec_timeout_sec");
            this.maps = new HashMap<Integer, String>(0);
            this.endpoints = new TreeSet<Endpoint>();
            Config staticsCfg = ConfigTools.sureConf(config, "fair.http.statics");
            String dir = staticsCfg != null && staticsCfg.hasPath("root") && !staticsCfg.getIsNull("root") ? Texts.notNull((Object)staticsCfg.getString("root")) : null;
            AssetsRead assets0 = new NoStatics();
            try {
                if (!Texts.isEmpty(dir)) {
                    if (dir.startsWith(":classpath:/")) {
                        assets0 = new BundledRead(staticsCfg, dir);
                    } else {
                        Path p = Paths.get(dir, new String[0]);
                        if (Files.exists(p, new LinkOption[0]) && Files.isDirectory(p, new LinkOption[0])) {
                            assets0 = new DirectRead(staticsCfg, dir);
                        }
                    }
                } else {
                    logger.debug("No statics: dir is empty `" + dir + "`");
                }
            }
            catch (IllegalStateException ise) {
                logger.error("Cant setup static assets: " + ise.getMessage() + ", noop.");
                assets0 = new NoStatics();
            }
            if (config.hasPath("fair.http")) {
                try {
                    config.getConfig("fair.http").root().unwrapped().forEach((s, o) -> {
                        if (s.startsWith("map") && s.endsWith("_to") && !Texts.isEmpty((Object)o)) {
                            this.maps.put(Digits.getInt((Object)s), Texts.notNull((Object)o));
                        }
                    });
                    this.maps.remove(0);
                    if (!this.maps.isEmpty()) {
                        Set<Integer> codes = this.maps.keySet();
                        for (int code : codes) {
                            int l = String.valueOf(code).length();
                            if (l > 3) {
                                this.maps.remove(code);
                                continue;
                            }
                            if (l >= 3) continue;
                            String mapping = this.maps.remove(code);
                            int from = Digits.getInt((Object)(code + "0".repeat(l == 2 ? 1 : 2)));
                            int untill = l == 1 ? 100 : 10;
                            for (int i = from; i < untill; ++i) {
                                this.maps.put(i, mapping);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("Cant setup code mappings: " + e.getMessage(), (Throwable)e);
                }
            }
            this.assets = assets0;
            this.cors = new CORS(config);
            this.executorService = Executors.newCachedThreadPool();
            return;
        }
    }

    public void start() {
        new Thread(() -> {
            try (ServerSocket socket = new ServerSocket(this.port);){
                Socket child;
                while ((child = socket.accept()) != null) {
                    this.rcs.add(new RCWrap(child, this.maxRequestBytes, this.readTimeout, this));
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                System.exit(-1);
            }
        }){

            @Override
            public synchronized void start() {
                this.setPriority(7);
                this.setName("FairHttpServer");
                super.start();
            }
        }.start();
        try {
            logger.info("Listen at:\thttp://" + Inet4Address.getLocalHost().getHostAddress() + ":" + this.port);
        }
        catch (Exception e) {
            logger.error("Cant get local host: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean canProcess(RequestId id) {
        Iterator i = this.endpoints.iterator();
        while (i.hasNext()) {
            Pair<Boolean, Boolean> reply = ((Endpoint)i.next()).match(id.method, id.path);
            if (((Boolean)reply.first).booleanValue() && ((Boolean)reply.second).booleanValue()) {
                return true;
            }
            if (!((Boolean)reply.second).booleanValue() || !id.method.equals("OPTIONS")) continue;
            return true;
        }
        return id.method.equals("GET") && (this.maps.containsKey(404) || this.assets.canProcess(id.path));
    }

    @Override
    public void handleRequest(RequestId id, Map<String, String> headers, ResourceConnect rc) {
        this.handleRequest0(id, headers, rc, !this.maps.isEmpty());
    }

    @Override
    public void meDead(ResourceConnect rc) {
        try {
            this.rcs.remove(rc);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void submit(Runnable task) {
        this.executorService.submit(task);
    }

    public void handleRequest0(RequestId id, Map<String, String> headers, ResourceConnect rc, boolean mayBeMapped) {
        Iterator i = this.endpoints.iterator();
        Response mappableResponse = null;
        while (i.hasNext()) {
            Endpoint e = (Endpoint)i.next();
            Pair<Boolean, Boolean> match = e.match(id.method, id.path);
            if (((Boolean)match.first).booleanValue() && ((Boolean)match.second).booleanValue()) {
                mappableResponse = e.call(new Request(id, headers, rc.getInput(), this.maxRequestBytes));
                break;
            }
            if (!((Boolean)match.second).booleanValue() || !id.method.equals("OPTIONS")) continue;
            mappableResponse = this.cors.wrap(headers, Response.NoContent());
            break;
        }
        if (mappableResponse == null) {
            if (id.method.equals("GET")) {
                mappableResponse = (Response)this.assets.apply(id.path);
            }
            if (mappableResponse == null) {
                mappableResponse = Response.NotFound();
            }
        }
        if (mayBeMapped && this.maps.containsKey(mappableResponse.code)) {
            this.handleRequest0(new RequestId(id.method, this.maps.get(mappableResponse.code)), headers, rc, false);
            return;
        }
        this.writeResponse(mappableResponse, rc);
    }

    private void writeResponse(Response response, ResourceConnect rc) {
        CompletableFuture.runAsync(() -> rc.write(response));
    }

    public void addEndpoints(Collection<Route> endpoints) {
        for (Route pretend : endpoints) {
            this.addEndpoint(pretend);
        }
    }

    public synchronized void setupConfigEndpoints(byte[] raw) {
        if (raw == null || raw.length == 0) {
            return;
        }
        EndpointResolver.resolve(raw).forEach(argued -> {
            boolean unresolving = Texts.isEmpty(argued.args);
            boolean direct = Response.class.isAssignableFrom(argued.invMethod.getReturnType());
            ARequestInvoker invoker = unresolving ? (direct ? new DirectUnresolvingInvoker(argued.invMethod, this.errorHandler, this.execTimeout) : new IndirectUnresolvingInvoker(argued.invMethod, this.errorHandler, this.execTimeout)) : (direct ? new DirectInvoker(argued.invMethod, Collections.unmodifiableList(argued.args.stream().map(arg -> arg.magic).collect(Collectors.toList())), this.errorHandler, this.execTimeout) : new IndirectInvoker(argued.invMethod, Collections.unmodifiableList(argued.args.stream().map(arg -> arg.magic).collect(Collectors.toList())), this.errorHandler, this.execTimeout));
            Endpoint ep = new Endpoint(argued.method, new Signature(argued.path), invoker);
            if (this.endpoints.add(ep)) {
                logger.info("Added endpoint: " + ep);
            }
        });
    }

    public synchronized boolean removeEndpoint(String method, String signature) {
        return this.endpoints.removeIf(e -> e.equals(method, signature));
    }

    public synchronized void addEndpoint(Route route) {
        if (this.endpoints.add(new Endpoint(route.method, new Signature(route.endpoint), route.indirect ? (req, pathMap) -> {
            try {
                return (Response)((CompletableFuture)CompletableFuture.supplyAsync(() -> {
                    try {
                        return (Response)((CompletionStage)route.callback.apply((Request)req, (Map<String, String>)pathMap)).toCompletableFuture().get(this.execTimeout, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException | ExecutionException | TimeoutException e) {
                        throw new RuntimeException(e);
                    }
                }).exceptionally(e -> {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException((Throwable)e);
                })).get(this.execTimeout, TimeUnit.SECONDS);
            }
            catch (Exception ex) {
                return this.errorHandler.apply(ex);
            }
        } : (req, pathMap) -> {
            try {
                return (Response)((CompletableFuture)CompletableFuture.supplyAsync(() -> (Response)route.callback.apply((Request)req, (Map<String, String>)pathMap)).exceptionally(e -> {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException((Throwable)e);
                })).get(this.execTimeout, TimeUnit.SECONDS);
            }
            catch (Exception ex) {
                return this.errorHandler.apply(ex);
            }
        }))) {
            logger.info("Added endpoint: " + route.method + "\t" + route.endpoint);
        }
    }

    public synchronized void setupErrorHandler(Function<Throwable, Response> errorHandler) {
        if (errorHandler != null) {
            this.errorHandler = errorHandler;
        }
    }

    public Response errorAsResponse(String error) {
        return this.errorHandler.apply(new Throwable(error));
    }

    public Response errorAsResponse(Throwable t) {
        if (t == null) {
            return Response.ServerError();
        }
        return this.errorHandler.apply(t);
    }
}

