/*
 * Decompiled with CFR 0.152.
 */
package org.logdoc.fairhttp.service.http;

import java.security.MessageDigest;
import java.util.Base64;
import java.util.function.Consumer;
import java.util.function.Function;
import org.logdoc.fairhttp.service.http.Request;
import org.logdoc.fairhttp.service.http.WebSocket;
import org.logdoc.fairhttp.service.tools.websocket.extension.DefaultExtension;
import org.logdoc.fairhttp.service.tools.websocket.extension.IExtension;
import org.logdoc.fairhttp.service.tools.websocket.protocol.IProtocol;

public class WSBuilder {
    private final Request request;
    private IExtension extension;
    private IProtocol protocol;
    private Consumer<WebSocket.ErrorRef> readErrorHandler;
    private Consumer<WebSocket.ErrorRef> writeErrorHandler;
    private Consumer<String> textHandler;
    private Consumer<byte[]> binaryHandler;
    private Consumer<WebSocket> pingHandler;
    private Consumer<WebSocket> pongHandler;
    private Consumer<WebSocket.CloseReason> closeHandler;
    private boolean readEnabled;
    private boolean writeEnabled;
    private long readTimeoutMs;

    private WSBuilder(Request request) {
        this.request = request;
        this.writeEnabled = true;
        this.readEnabled = true;
        this.readTimeoutMs = 300000L;
    }

    public static WSBuilder from(Request request) {
        return new WSBuilder(request);
    }

    public WSBuilder withCloseHandler(Consumer<WebSocket.CloseReason> closeHandler) {
        this.closeHandler = closeHandler;
        return this;
    }

    public WSBuilder withExtension(IExtension extension) {
        this.extension = extension;
        return this;
    }

    public WSBuilder withProtocol(IProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public WSBuilder withPingHandler(Consumer<WebSocket> pingHandler) {
        this.pingHandler = pingHandler;
        return this;
    }

    public WSBuilder withPongHandler(Consumer<WebSocket> pongHandler) {
        this.pongHandler = pongHandler;
        return this;
    }

    public WSBuilder withReadErrorHandler(Consumer<WebSocket.ErrorRef> readErrorHandler) {
        this.readErrorHandler = readErrorHandler;
        return this;
    }

    public WSBuilder withWriteErrorHandler(Consumer<WebSocket.ErrorRef> writeErrorHandler) {
        this.writeErrorHandler = writeErrorHandler;
        return this;
    }

    public WSBuilder withTextHandler(Consumer<String> textHandler) {
        this.textHandler = textHandler;
        return this;
    }

    public WSBuilder withBinaryHandler(Consumer<byte[]> binaryHandler) {
        this.binaryHandler = binaryHandler;
        return this;
    }

    public <T> WSBuilder withTextAutoMapping(Consumer<T> handler, Function<String, T> mappingFunction) {
        if (handler != null && mappingFunction != null) {
            this.textHandler = s -> handler.accept(mappingFunction.apply((String)s));
        }
        return this;
    }

    public <T> WSBuilder withBinaryAutoMapping(Consumer<T> handler, Function<byte[], T> mappingFunction) {
        if (handler != null && mappingFunction != null) {
            this.binaryHandler = bytes -> handler.accept(mappingFunction.apply((byte[])bytes));
        }
        return this;
    }

    public <T> WSBuilder withReadEnabled(boolean readEnabled) {
        this.readEnabled = readEnabled;
        return this;
    }

    public <T> WSBuilder withReadTimeoutMs(long readTimeoutMs) {
        this.readTimeoutMs = readTimeoutMs;
        return this;
    }

    public <T> WSBuilder withWriteEnabled(boolean writeEnabled) {
        this.writeEnabled = writeEnabled;
        return this;
    }

    public WebSocket build() {
        if (!this.request.isWebsocketUpgradable(this.extension, this.protocol)) {
            return null;
        }
        if (!this.readEnabled && !this.writeEnabled) {
            return null;
        }
        WebSocket socket = this.getWebSocket();
        try {
            socket.header("Sec-WebSocket-Accept", Base64.getEncoder().encodeToString(MessageDigest.getInstance("SHA-1").digest((this.request.header("Sec-WebSocket-Key") + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11").getBytes())));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.extension != null) {
            socket.header("Sec-WebSocket-Extensions", this.extension.getProvidedExtensionAsServer());
        }
        if (this.protocol != null) {
            socket.header("Sec-WebSocket-Protocol", this.protocol.getProvidedProtocol());
        }
        socket.header("Upgrade", "websocket");
        socket.header("Connection", "Upgrade");
        return socket;
    }

    private WebSocket getWebSocket() {
        Consumer<String> txter = this.textHandler == null ? s -> {} : this.textHandler;
        Consumer<byte[]> biner = this.binaryHandler == null ? bytes -> {} : this.binaryHandler;
        Consumer<WebSocket> pinger = this.pingHandler == null ? unused -> {} : this.pingHandler;
        Consumer<WebSocket> ponger = this.pongHandler == null ? unused -> {} : this.pongHandler;
        Consumer<WebSocket.CloseReason> closer = this.closeHandler == null ? closeReason -> {} : this.closeHandler;
        Consumer<WebSocket.ErrorRef> reader = this.readErrorHandler == null ? eh -> {} : this.readErrorHandler;
        Consumer<WebSocket.ErrorRef> writer = this.writeErrorHandler == null ? eh -> {} : this.writeErrorHandler;
        return new WebSocket(this.extension == null ? new DefaultExtension() : this.extension, txter, biner, pinger, ponger, closer, reader, writer, this.readEnabled, this.writeEnabled, this.readTimeoutMs);
    }
}

