/*
 * Decompiled with CFR 0.152.
 */
package org.logdoc.fairhttp.service.http.statics;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.StringConcatFactory;
import java.net.URL;
import java.time.LocalDateTime;
import org.logdoc.fairhttp.service.http.Response;
import org.logdoc.fairhttp.service.http.statics.DirectRead;
import org.logdoc.fairhttp.service.http.statics.StaticRead;
import org.logdoc.helpers.Texts;
import org.logdoc.helpers.std.MimeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundledRead
extends StaticRead {
    public static final String PlaceHolder = ":classpath:/";
    private static final Logger logger = LoggerFactory.getLogger(DirectRead.class);
    private final ClassLoader cl = BundledRead.class.getClassLoader();
    private final String prefix;

    public BundledRead(Config staticsCfg, String prefix) {
        super(staticsCfg);
        try {
            prefix = ((String)prefix).replace(PlaceHolder, "").trim();
            if (Texts.isEmpty((Object)prefix)) {
                prefix = "/";
            } else if (!((String)prefix).endsWith("/")) {
                prefix = (String)prefix + "/";
            }
            this.prefix = prefix;
        }
        catch (ConfigException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new IllegalStateException(e);
        }
        if (!this.prefix.equals("/") && this.cl.getResource(this.prefix) == null) {
            throw new IllegalStateException("Unknown static root resource: " + this.prefix);
        }
        logger.info("Static bundled content root: " + this.prefix);
        if (this.autoDirList) {
            logger.warn("WARNING: Auto directory listing is disabled in bundled content.");
        }
    }

    private StaticRead.FRes resolve(String path) {
        String p = (this.prefix + path).replaceAll("/{2,}", "/");
        URL fileRes = this.cl.getResource(p);
        StaticRead.FRes f = new StaticRead.FRes();
        f.name = p;
        f.exists = fileRes != null;
        f.time = LocalDateTime.now();
        try {
            f.size = fileRes != null ? (long)fileRes.openConnection().getContentLength() : 0L;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f;
    }

    @Override
    public boolean canProcess(String path) {
        return this.resolve((String)path).exists;
    }

    @Override
    public Response apply(String webpath) {
        StaticRead.FRes p = this.resolve(webpath);
        if (!p.exists) {
            return Response.NotFound();
        }
        Response response = this.pickCached(p.name);
        try {
            if (response != null) {
                return response;
            }
            if (webpath.endsWith("/")) {
                if (this.gotIndex) {
                    for (String idx : this.indexFile) {
                        if (!this.resolve((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001/\u0001"}, (String)webpath, (String)idx))).exists) continue;
                        return this.apply(webpath + "/" + idx);
                    }
                }
                response = Response.Forbidden();
            } else {
                int dot = p.name.lastIndexOf(46);
                String mime = null;
                if (dot > 0) {
                    mime = this.getMime(p.name.substring(dot));
                }
                if (mime == null && (mime = this.refreshMime(webpath)) == null) {
                    int[] head = new int[16];
                    try (InputStream is = this.cl.getResourceAsStream(p.name);){
                        if (is != null) {
                            int b = 0;
                            for (int i = 0; i < head.length && b != -1; ++i) {
                                head[i] = b = is.read();
                            }
                        }
                    }
                    mime = MimeType.guessMime((int[])head).toString();
                    this.rememberMime(webpath, mime);
                }
                response = Response.Ok();
                response.header("Content-Type", mime);
                response.header("Content-Length", p.size);
                response.setPromise(os -> {
                    byte[] buf = new byte[655360];
                    try (InputStream is = this.cl.getResourceAsStream(p.name);){
                        if (is != null) {
                            int read;
                            while ((read = is.read(buf)) != -1) {
                                os.write(buf, 0, read);
                            }
                        }
                        os.flush();
                    }
                    catch (Exception e) {
                        logger.error(p + " :: " + e.getMessage(), (Throwable)e);
                    }
                });
            }
            if (response.is200()) {
                this.cacheMe(webpath, response);
            }
            return response;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return Response.ServerError();
        }
    }
}

