/*
 * Decompiled with CFR 0.152.
 */
package org.logdoc.fairhttp.service.http.statics;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.logdoc.fairhttp.service.http.Response;
import org.logdoc.fairhttp.service.http.statics.StaticRead;
import org.logdoc.fairhttp.service.tools.PhasedConsumer;
import org.logdoc.helpers.std.MimeType;
import org.logdoc.helpers.std.MimeTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectRead
extends StaticRead {
    private static final Logger logger = LoggerFactory.getLogger(DirectRead.class);
    private final Path root;

    public DirectRead(Config staticsCfg, String root) {
        super(staticsCfg);
        try {
            this.root = Paths.get(root, new String[0]);
        }
        catch (ConfigException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new IllegalStateException(e);
        }
        if (!Files.exists(this.root, new LinkOption[0])) {
            throw new IllegalStateException("root dir doesnt exists");
        }
        logger.info("Static content root dir: " + this.root);
    }

    public static Response fileResponse(Path p, String mimeType, long size) {
        Response response = Response.Ok();
        response.header("Content-Type", mimeType);
        response.header("Content-Length", size);
        response.setPromise(os -> {
            byte[] buf = new byte[655360];
            try (InputStream is = Files.newInputStream(p, new OpenOption[0]);){
                int read;
                while ((read = is.read(buf)) != -1) {
                    os.write(buf, 0, read);
                }
                os.flush();
            }
            catch (Exception e) {
                logger.error(p + " :: " + e.getMessage(), (Throwable)e);
            }
        });
        return response;
    }

    @Override
    public boolean canProcess(String webpath) {
        if ((webpath = webpath.replaceAll("/{2,}", "/")).startsWith("/")) {
            webpath = webpath.substring(1);
        }
        webpath = webpath.replace('/', File.separatorChar);
        return Files.exists(this.root.resolve(webpath), new LinkOption[0]);
    }

    @Override
    public Response apply(String webpath) {
        Path p;
        if ((webpath = webpath.replaceAll("/{2,}", "/")).startsWith("/")) {
            webpath = webpath.substring(1);
        }
        if (!Files.exists(p = this.root.resolve(webpath = webpath.replace('/', File.separatorChar)), new LinkOption[0])) {
            return Response.NotFound();
        }
        Response response = this.pickCached(webpath);
        try {
            if (response != null) {
                return response;
            }
            if (Files.isDirectory(p, new LinkOption[0])) {
                if (this.gotIndex) {
                    for (String idx : this.indexFile) {
                        Path subid = p.resolve(idx);
                        if (!Files.exists(subid, new LinkOption[0]) || Files.isDirectory(subid, new LinkOption[0])) continue;
                        return this.apply(webpath + "/" + subid.getFileName());
                    }
                }
                if (this.autoDirList) {
                    final String wp = webpath;
                    response = Response.Ok();
                    response.header("Content-Type", MimeTypes.TEXTHTML);
                    response.setPromise((Consumer<OutputStream>)new PhasedConsumer<OutputStream>(){
                        private byte[] data;

                        @Override
                        public void warmUp(OutputStream os) {
                            try (Stream<Path> fs = Files.list(p);){
                                this.data = DirectRead.this.dirList(p.getFileName().toString(), fs.map(f -> {
                                    try {
                                        StaticRead.FRes fr = new StaticRead.FRes();
                                        fr.isFile = !Files.isDirectory(f, new LinkOption[0]);
                                        fr.time = LocalDateTime.from(Files.getLastModifiedTime(f, new LinkOption[0]).toInstant().atZone(ZoneId.systemDefault()));
                                        fr.name = f.getFileName().toString();
                                        fr.size = fr.isFile ? Files.size(f) : 0L;
                                        return fr;
                                    }
                                    catch (Exception e) {
                                        logger.error(e.getMessage(), (Throwable)e);
                                        return null;
                                    }
                                }).filter(Objects::nonNull).collect(Collectors.toList()));
                                os.write(("Content-Length: " + this.data.length).getBytes(StandardCharsets.UTF_8));
                                os.write(Response.FEED);
                            }
                            catch (Exception e) {
                                logger.error(wp + " :: " + e.getMessage(), (Throwable)e);
                            }
                        }

                        @Override
                        public void accept(OutputStream os) {
                            try {
                                os.write(this.data);
                            }
                            catch (IOException e) {
                                logger.error(wp + " :: " + e.getMessage(), (Throwable)e);
                            }
                        }
                    });
                } else {
                    response = Response.Forbidden();
                }
            } else {
                int dot = p.getFileName().toString().lastIndexOf(46);
                String mime = null;
                if (dot > 0) {
                    mime = this.getMime(p.getFileName().toString().substring(dot));
                }
                if (mime == null && (mime = this.refreshMime(webpath)) == null) {
                    int[] head = new int[16];
                    try (InputStream is = Files.newInputStream(p, new OpenOption[0]);){
                        int b = 0;
                        for (int i = 0; i < head.length && b != -1; ++i) {
                            head[i] = b = is.read();
                        }
                    }
                    mime = MimeType.guessMime((int[])head).toString();
                    this.rememberMime(webpath, mime);
                }
                long size = Files.size(p);
                response = Response.Ok();
                response.header("Content-Type", mime);
                response.header("Content-Length", size);
                response.setPromise(os -> {
                    byte[] buf = new byte[655360];
                    try (InputStream is = Files.newInputStream(p, new OpenOption[0]);){
                        int read;
                        while ((read = is.read(buf)) != -1) {
                            os.write(buf, 0, read);
                        }
                        os.flush();
                    }
                    catch (Exception e) {
                        logger.error(p + " :: " + e.getMessage(), (Throwable)e);
                    }
                });
            }
            if (response.is200()) {
                this.cacheMe(webpath, response);
            }
            return response;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return Response.ServerError();
        }
    }
}

