/*
 * Decompiled with CFR 0.152.
 */
package org.logdoc.fairhttp.service.http.tasks;

import java.io.InputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.logdoc.helpers.Texts;

public class RCHeaders
implements Runnable {
    private final Socket socket;
    private final CompletableFuture<Map<String, String>> stage;

    public RCHeaders(Socket socket, CompletableFuture<Map<String, String>> stage) {
        this.socket = socket;
        this.stage = stage;
    }

    @Override
    public void run() {
        try {
            HashMap<String, String> map = new HashMap<String, String>(0){

                @Override
                public String get(Object key) {
                    return (String)super.get(Texts.notNull((Object)key).toUpperCase(Locale.ROOT));
                }

                @Override
                public boolean containsKey(Object key) {
                    return super.containsKey(Texts.notNull((Object)key).toUpperCase(Locale.ROOT));
                }

                @Override
                public String getOrDefault(Object key, String defaultValue) {
                    return super.getOrDefault(Texts.notNull((Object)key).toUpperCase(Locale.ROOT), defaultValue);
                }
            };
            byte[] buf = new byte[8192];
            this.socket.setSoTimeout(5000);
            InputStream is = this.socket.getInputStream();
            int i = 0;
            do {
                try {
                    buf[i++] = (byte)is.read();
                }
                catch (SocketTimeoutException e) {
                    break;
                }
            } while (i < 4 || buf[i - 4] != 13 || buf[i - 3] != 10 || buf[i - 2] != 13 || buf[i - 1] != 10);
            String data = new String(Arrays.copyOfRange(buf, 0, i - 3), StandardCharsets.UTF_8);
            String[] heads = data.split("\n");
            for (i = 0; i < heads.length; ++i) {
                String name;
                int idx = heads[i].indexOf(58);
                if (idx == -1 || (name = Texts.notNull((Object)heads[i].substring(0, idx))).isEmpty()) continue;
                map.put(name.toUpperCase(Locale.ROOT), Texts.notNull((Object)heads[i].substring(idx + 1)));
            }
            this.stage.complete(Collections.unmodifiableMap(map));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.stage.completeExceptionally(new IllegalStateException("Request headers block exceeds 8192 bytes limit"));
        }
        catch (Exception e) {
            this.stage.completeExceptionally(e);
        }
    }
}

