/*
 * Decompiled with CFR 0.152.
 */
package org.logdoc.fairhttp.service.http.tasks;

import java.io.EOFException;
import java.io.InputStream;
import java.net.Socket;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import org.logdoc.fairhttp.service.http.RequestId;
import org.logdoc.helpers.Texts;

public class RCSignature
implements Runnable {
    private final Socket socket;
    private final CompletableFuture<RequestId> stage;

    public RCSignature(Socket socket, CompletableFuture<RequestId> stage) {
        this.socket = socket;
        this.stage = stage;
    }

    @Override
    public void run() {
        try {
            this.socket.setSoTimeout(5000);
            InputStream is = this.socket.getInputStream();
            byte[] buf = new byte[4096];
            String s = "";
            for (int i = 0; i < 4096; ++i) {
                buf[i] = (byte)is.read();
                if (buf[i] == -1) {
                    throw new EOFException();
                }
                if (buf[i] != 13 || is.read() != 10) continue;
                s = new String(Arrays.copyOfRange(buf, 0, i));
                break;
            }
            if (s.isBlank()) {
                throw new IllegalStateException("Didnt read first line");
            }
            String[] parts = s.trim().split("\\s", 3);
            this.stage.complete(new RequestId(Texts.notNull((Object)parts[0]).toUpperCase(), Texts.notNull((Object)parts[1])));
        }
        catch (Exception e) {
            this.stage.completeExceptionally(e);
        }
    }
}

