/*
 * Decompiled with CFR 0.152.
 */
package org.logdoc.fairhttp.service.tools;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ConfigTools {
    public static List<String> sureStrings(Config c, String name) {
        ArrayList<String> list = new ArrayList<String>(0);
        if (!c.hasPath(name) || c.getIsNull(name)) {
            return list;
        }
        ConfigValue cv = c.getValue(name);
        if (cv.valueType() == ConfigValueType.STRING) {
            list.add(String.valueOf(cv.unwrapped()));
        } else if (cv.valueType() == ConfigValueType.LIST) {
            list.addAll((Collection)cv.unwrapped());
        }
        return list;
    }

    public static Config sureConf(Config c, String name) {
        if (c.hasPath(name) && !c.getIsNull(name) && c.getValue(name).valueType() == ConfigValueType.OBJECT) {
            return c.getConfig(name);
        }
        return null;
    }

    public static boolean sureBool(Config c, String name) {
        if (c.hasPath(name) && !c.getIsNull(name) && c.getValue(name).valueType() == ConfigValueType.BOOLEAN) {
            return c.getBoolean(name);
        }
        return false;
    }

    public static boolean sureNN(Config c, String name) {
        return c.hasPath(name) && !c.getIsNull(name);
    }
}

