/*
 * Decompiled with CFR 0.152.
 */
package org.logdoc.fairhttp.service.tools;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.logdoc.helpers.Bytes;
import org.logdoc.helpers.Texts;

public class ParameterParser {
    private static final int MimeShift = 4;
    private static final String MimeASCII = "US-ASCII";
    private static final String MimeBase64 = "B";
    private static final String MimeQuotedPrintable = "Q";
    private static final String MimeEncodedMarker = "=?";
    private static final String MimeEncodedEnd = "?=";
    private static final String MimeWhitespace = " \t\r\n";
    private char[] chars = null;
    private int pos = 0;
    private int len = 0;
    private int i1 = 0;
    private int i2 = 0;
    private boolean lowerCaseNames = false;

    private boolean hasChar() {
        return this.pos < this.len;
    }

    private String getToken(boolean quoted) {
        while (this.i1 < this.i2 && Character.isWhitespace(this.chars[this.i1])) {
            ++this.i1;
        }
        while (this.i2 > this.i1 && Character.isWhitespace(this.chars[this.i2 - 1])) {
            --this.i2;
        }
        if (quoted && this.i2 - this.i1 >= 2 && this.chars[this.i1] == '\"' && this.chars[this.i2 - 1] == '\"') {
            ++this.i1;
            --this.i2;
        }
        return this.i2 > this.i1 ? new String(this.chars, this.i1, this.i2 - this.i1) : null;
    }

    private boolean isOneOf(char ch, char[] charray) {
        for (char aCharray : charray) {
            if (ch != aCharray) continue;
            return true;
        }
        return false;
    }

    private String parseToken(char[] terminators) {
        char ch;
        this.i1 = this.i2 = this.pos;
        while (this.hasChar() && !this.isOneOf(ch = this.chars[this.pos], terminators)) {
            ++this.i2;
            ++this.pos;
        }
        return this.getToken(false);
    }

    private String parseQuotedToken(char[] terminators) {
        this.i1 = this.i2 = this.pos;
        boolean quoted = false;
        boolean charEscaped = false;
        while (this.hasChar()) {
            char ch = this.chars[this.pos];
            if (!quoted && this.isOneOf(ch, terminators)) break;
            if (!charEscaped && ch == '\"') {
                quoted = !quoted;
            }
            charEscaped = !charEscaped && ch == '\\';
            ++this.i2;
            ++this.pos;
        }
        return this.getToken(true);
    }

    public void setLowerCaseNames() {
        this.lowerCaseNames = true;
    }

    public Map<String, String> parse(String str, char separator) {
        if (str == null) {
            return new HashMap<String, String>();
        }
        return this.parse(str.toCharArray(), separator);
    }

    private Map<String, String> parse(char[] chars, char separator) {
        if (chars == null) {
            return new HashMap<String, String>();
        }
        return this.parse(chars, chars.length, separator);
    }

    private Map<String, String> parse(char[] chars, int length, char separator) {
        if (chars == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        this.chars = chars;
        this.pos = 0;
        this.len = length;
        while (this.hasChar()) {
            String paramName = this.parseToken(new char[]{'=', separator});
            String paramValue = null;
            if (this.hasChar() && chars[this.pos] == '=') {
                ++this.pos;
                paramValue = this.parseQuotedToken(new char[]{separator});
                if (paramValue != null) {
                    paramValue = this.mimeDecodeText(paramValue);
                }
            }
            if (this.hasChar() && chars[this.pos] == separator) {
                ++this.pos;
            }
            if (paramName == null || paramName.isEmpty()) continue;
            if (this.lowerCaseNames) {
                paramName = paramName.toLowerCase(Locale.ENGLISH);
            }
            params.put(paramName, paramValue);
        }
        return params;
    }

    private String mimeDecodeText(String text) {
        if (!text.contains(MimeEncodedMarker)) {
            return text;
        }
        int offset = 0;
        int endOffset = text.length();
        int startWhiteSpace = -1;
        int endWhiteSpace = -1;
        StringBuilder decodedText = new StringBuilder(text.length());
        boolean previousTokenEncoded = false;
        block2: while (offset < endOffset) {
            char ch = text.charAt(offset);
            if (MimeWhitespace.indexOf(ch) != -1) {
                startWhiteSpace = offset;
                while (offset < endOffset) {
                    ch = text.charAt(offset);
                    if (MimeWhitespace.indexOf(ch) != -1) {
                        ++offset;
                        continue;
                    }
                    endWhiteSpace = offset;
                    continue block2;
                }
                continue;
            }
            int wordStart = offset;
            while (offset < endOffset && MimeWhitespace.indexOf(ch = text.charAt(offset)) == -1) {
                ++offset;
            }
            String word = text.substring(wordStart, offset);
            if (word.startsWith(MimeEncodedMarker)) {
                try {
                    String decodedWord = this.mimeDecodeWord(word);
                    if (!previousTokenEncoded && startWhiteSpace != -1) {
                        decodedText.append(text, startWhiteSpace, endWhiteSpace);
                        startWhiteSpace = -1;
                    }
                    previousTokenEncoded = true;
                    decodedText.append(decodedWord);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (startWhiteSpace != -1) {
                decodedText.append(text, startWhiteSpace, endWhiteSpace);
                startWhiteSpace = -1;
            }
            previousTokenEncoded = false;
            decodedText.append(word);
        }
        return decodedText.toString();
    }

    private String mimeDecodeWord(String word) throws Exception {
        if (!word.startsWith(MimeEncodedMarker)) {
            throw new Exception("Invalid RFC 2047 encoded-word: " + word);
        }
        int charsetPos = word.indexOf(63, 2);
        if (charsetPos == -1) {
            throw new Exception("Missing charset in RFC 2047 encoded-word: " + word);
        }
        String charset = word.substring(2, charsetPos).toLowerCase();
        int encodingPos = word.indexOf(63, charsetPos + 1);
        if (encodingPos == -1) {
            throw new Exception("Missing encoding in RFC 2047 encoded-word: " + word);
        }
        String encoding = word.substring(charsetPos + 1, encodingPos);
        int encodedTextPos = word.indexOf(MimeEncodedEnd, encodingPos + 1);
        if (encodedTextPos == -1) {
            throw new Exception("Missing encoded text in RFC 2047 encoded-word: " + word);
        }
        String encodedText = word.substring(encodingPos + 1, encodedTextPos);
        if (encodedText.isEmpty()) {
            return "";
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(encodedText.length());
            byte[] encodedData = encodedText.getBytes(MimeASCII);
            switch (encoding) {
                case "B": {
                    Bytes.copy((InputStream)Base64.getDecoder().wrap(new ByteArrayInputStream(encodedData)), (OutputStream)out);
                    break;
                }
                case "Q": {
                    this.mimeDecodeQP(encodedData, out);
                    break;
                }
                default: {
                    throw new UnsupportedEncodingException("Unknown RFC 2047 encoding: " + encoding);
                }
            }
            return out.toString(Texts.mimeCharset((String)charset));
        }
        catch (IOException e) {
            throw new UnsupportedEncodingException("Invalid RFC 2047 encoding");
        }
    }

    private void mimeDecodeQP(byte[] data, OutputStream out) throws IOException {
        int off = 0;
        int length = data.length;
        int endOffset = off + length;
        while (off < endOffset) {
            byte ch;
            if ((ch = data[off++]) == 95) {
                out.write(32);
                continue;
            }
            if (ch == 61) {
                if (off + 1 >= endOffset) {
                    throw new IOException("Invalid quoted printable encoding; truncated escape sequence");
                }
                byte b1 = data[off++];
                byte b2 = data[off++];
                if (b1 == 13 && b2 != 10) {
                    throw new IOException("Invalid quoted printable encoding; CR must be followed by LF");
                }
                int c1 = Texts.hexToBinary((byte)b1);
                int c2 = Texts.hexToBinary((byte)b2);
                out.write(c1 << 4 | c2);
                continue;
            }
            out.write(ch);
        }
    }
}

