/*
 * Decompiled with CFR 0.152.
 */
package org.logdoc.fairhttp.service.tools;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class ScanBuf {
    private byte[] buf;

    public ScanBuf() {
        this.buf = new byte[0];
    }

    public ScanBuf(byte[] buf) {
        this.buf = buf == null ? new byte[]{} : buf;
    }

    public byte[] asData() {
        return this.buf;
    }

    public void append(byte[] a) {
        if (a == null || a.length == 0) {
            return;
        }
        if (this.buf.length == 0) {
            this.buf = a;
        } else {
            byte[] tmp = new byte[this.buf.length + a.length];
            System.arraycopy(this.buf, 0, tmp, 0, this.buf.length);
            System.arraycopy(a, 0, tmp, this.buf.length, a.length);
            this.buf = tmp;
        }
    }

    public boolean missed(byte mark) {
        return !this.has(mark);
    }

    public boolean missed(byte[] mark) {
        return !this.has(mark);
    }

    public boolean has(byte mark) {
        for (byte b : this.buf) {
            if (b != mark) continue;
            return true;
        }
        return false;
    }

    public ScanBuf scanAndCut(byte mark) {
        return this.scanAndCut(mark, true);
    }

    public ScanBuf scanAndCut(byte mark, boolean skipMark) {
        for (int i = 0; i < this.buf.length; ++i) {
            if (this.buf[i] != mark) continue;
            if (0 == i) {
                return new ScanBuf();
            }
            this.skip(i + (skipMark ? 1 : 0));
            return new ScanBuf(Arrays.copyOfRange(this.buf, 0, i));
        }
        return null;
    }

    public boolean has(byte[] mark) {
        block0: for (int i = 0; i < this.buf.length - mark.length; ++i) {
            if (this.buf[i] != mark[0]) continue;
            for (int j = 1; j < mark.length; ++j) {
                if (this.buf[i + j] != mark[j]) continue block0;
            }
            return true;
        }
        return false;
    }

    public ScanBuf scanAndCut(byte[] mark) {
        return this.scanAndCut(mark, true);
    }

    public ScanBuf scanAndCut(byte[] mark, boolean skipMark) {
        block0: for (int i = 0; i < this.buf.length; ++i) {
            if (this.buf[i] != mark[0]) continue;
            for (int j = 1; j < mark.length; ++j) {
                if (this.buf[i + j] != mark[j]) continue block0;
            }
            if (0 == i) {
                return new ScanBuf();
            }
            this.skip(i + (skipMark ? mark.length : 0));
            return new ScanBuf(Arrays.copyOfRange(this.buf, 0, i));
        }
        return null;
    }

    public String toString() {
        return new String(this.buf, StandardCharsets.UTF_8);
    }

    public boolean startsWith(byte[] mark) {
        if (this.buf.length < mark.length || this.buf[0] != mark.length) {
            return false;
        }
        for (int j = 1; j < mark.length; ++j) {
            if (this.buf[j] == mark[j]) continue;
            return false;
        }
        return true;
    }

    public void skip(int length) {
        this.buf = Arrays.copyOfRange(this.buf, length, this.buf.length);
    }
}

