/*
 * Decompiled with CFR 0.152.
 */
package org.logdoc.fairhttp.service.tools.websocket.extension;

import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.logdoc.fairhttp.service.tools.websocket.Opcode;
import org.logdoc.fairhttp.service.tools.websocket.extension.CompressionExtension;
import org.logdoc.fairhttp.service.tools.websocket.extension.ExtensionError;
import org.logdoc.fairhttp.service.tools.websocket.extension.ExtensionRequestData;
import org.logdoc.fairhttp.service.tools.websocket.extension.IExtension;
import org.logdoc.fairhttp.service.tools.websocket.frames.AFrame;
import org.logdoc.fairhttp.service.tools.websocket.frames.ContinuousFrame;
import org.logdoc.fairhttp.service.tools.websocket.frames.DataFrame;
import org.logdoc.fairhttp.service.tools.websocket.frames.Frame;

public class PMDeflateExtension
extends CompressionExtension {
    private static final String EXTENSION_REGISTERED_NAME = "permessage-deflate";
    private static final String SERVER_NO_CONTEXT_TAKEOVER = "server_no_context_takeover";
    private static final String CLIENT_NO_CONTEXT_TAKEOVER = "client_no_context_takeover";
    private static final String SERVER_MAX_WINDOW_BITS = "server_max_window_bits";
    private static final String CLIENT_MAX_WINDOW_BITS = "client_max_window_bits";
    private static final int serverMaxWindowBits = 32768;
    private static final int clientMaxWindowBits = 32768;
    private static final byte[] TAIL_BYTES = new byte[]{0, 0, -1, -1};
    private static final int BUFFER_SIZE = 1024;
    private int threshold = 1024;
    private boolean serverNoContextTakeover = true;
    private boolean clientNoContextTakeover = false;
    private final Map<String, String> requestedParameters = new LinkedHashMap<String, String>();
    private Inflater inflater = new Inflater(true);
    private Deflater deflater = new Deflater(-1, true);

    public Inflater getInflater() {
        return this.inflater;
    }

    public void setInflater(Inflater inflater) {
        this.inflater = inflater;
    }

    public Deflater getDeflater() {
        return this.deflater;
    }

    public void setDeflater(Deflater deflater) {
        this.deflater = deflater;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public boolean isServerNoContextTakeover() {
        return this.serverNoContextTakeover;
    }

    public void setServerNoContextTakeover(boolean serverNoContextTakeover) {
        this.serverNoContextTakeover = serverNoContextTakeover;
    }

    public boolean isClientNoContextTakeover() {
        return this.clientNoContextTakeover;
    }

    public void setClientNoContextTakeover(boolean clientNoContextTakeover) {
        this.clientNoContextTakeover = clientNoContextTakeover;
    }

    @Override
    public void decodeFrame(Frame inputFrame) throws ExtensionError {
        if (!(inputFrame instanceof DataFrame)) {
            return;
        }
        if (!inputFrame.isRSV1() && inputFrame.getOpcode() != Opcode.CONTINUOUS) {
            return;
        }
        if (inputFrame.getOpcode() == Opcode.CONTINUOUS && inputFrame.isRSV1()) {
            throw new ExtensionError(1008, "RSV1 bit can only be set for the first frame.");
        }
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            this.decompress(inputFrame.getPayloadData(), output);
            if (this.inflater.getRemaining() > 0) {
                this.inflater = new Inflater(true);
                this.decompress(inputFrame.getPayloadData(), output);
            }
            if (inputFrame.isFin()) {
                this.decompress(TAIL_BYTES, output);
                if (this.clientNoContextTakeover) {
                    this.inflater = new Inflater(true);
                }
            }
            ((AFrame)inputFrame).setPayload(output.toByteArray());
        }
        catch (Exception e) {
            throw new ExtensionError(1008, e.getMessage());
        }
    }

    private void decompress(byte[] data, ByteArrayOutputStream outputBuffer) throws DataFormatException {
        int bytesInflated;
        this.inflater.setInput(data);
        byte[] buffer = new byte[1024];
        while ((bytesInflated = this.inflater.inflate(buffer)) > 0) {
            outputBuffer.write(buffer, 0, bytesInflated);
        }
    }

    @Override
    public void encodeFrame(Frame inputFrame) throws ExtensionError {
        if (!(inputFrame instanceof DataFrame)) {
            return;
        }
        byte[] payloadData = inputFrame.getPayloadData();
        if (payloadData.length < this.threshold) {
            return;
        }
        if (!(inputFrame instanceof ContinuousFrame)) {
            ((DataFrame)inputFrame).setRSV1(true);
        }
        this.deflater.setInput(payloadData);
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            int bytesCompressed;
            byte[] buffer = new byte[1024];
            while ((bytesCompressed = this.deflater.deflate(buffer, 0, buffer.length, 2)) > 0) {
                output.write(buffer, 0, bytesCompressed);
            }
            byte[] outputBytes = output.toByteArray();
            int outputLength = outputBytes.length;
            if (inputFrame.isFin()) {
                if (PMDeflateExtension.endsWithTail(outputBytes)) {
                    outputLength -= TAIL_BYTES.length;
                }
                if (this.serverNoContextTakeover) {
                    this.deflater.end();
                    this.deflater = new Deflater(-1, true);
                }
            }
            ((AFrame)inputFrame).setPayload(Arrays.copyOfRange(outputBytes, 0, outputLength));
        }
        catch (Exception e) {
            throw new ExtensionError(1010, e.getMessage());
        }
    }

    private static boolean endsWithTail(byte[] data) {
        if (data.length < 4) {
            return false;
        }
        int length = data.length;
        for (int i = 0; i < TAIL_BYTES.length; ++i) {
            if (TAIL_BYTES[i] == data[length - TAIL_BYTES.length + i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean acceptProvidedExtensionAsServer(String inputExtension) {
        String[] requestedExtensions;
        for (String extension : requestedExtensions = inputExtension.split(",")) {
            ExtensionRequestData extensionData = ExtensionRequestData.parseExtensionRequest(extension);
            if (!EXTENSION_REGISTERED_NAME.equalsIgnoreCase(extensionData.getExtensionName())) continue;
            Map<String, String> headers = extensionData.getExtensionParameters();
            this.requestedParameters.putAll(headers);
            if (this.requestedParameters.containsKey(CLIENT_NO_CONTEXT_TAKEOVER)) {
                this.clientNoContextTakeover = true;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean acceptProvidedExtensionAsClient(String inputExtension) {
        String[] requestedExtensions;
        for (String extension : requestedExtensions = inputExtension.split(",")) {
            if (!EXTENSION_REGISTERED_NAME.equalsIgnoreCase(ExtensionRequestData.parseExtensionRequest(extension).getExtensionName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getProvidedExtensionAsClient() {
        this.requestedParameters.put(CLIENT_NO_CONTEXT_TAKEOVER, "");
        this.requestedParameters.put(SERVER_NO_CONTEXT_TAKEOVER, "");
        return "permessage-deflate; server_no_context_takeover; client_no_context_takeover";
    }

    @Override
    public String getProvidedExtensionAsServer() {
        return "permessage-deflate; server_no_context_takeover" + (this.clientNoContextTakeover ? "; client_no_context_takeover" : "");
    }

    @Override
    public IExtension copyInstance() {
        return new PMDeflateExtension();
    }

    @Override
    public boolean isFrameValid(Frame frame) {
        if (frame instanceof ContinuousFrame && (frame.isRSV1() || frame.isRSV2() || frame.isRSV3())) {
            return false;
        }
        return super.isFrameValid(frame);
    }

    @Override
    public String toString() {
        return "PerMessageDeflateExtension";
    }
}

