/*
 * Decompiled with CFR 0.152.
 */
package org.logdoc.fairhttp.service.tools.websocket.frames;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import org.logdoc.fairhttp.service.tools.websocket.Opcode;
import org.logdoc.fairhttp.service.tools.websocket.frames.ControlFrame;

public class CloseFrame
extends ControlFrame {
    public static final int NORMAL = 1000;
    public static final int GOING_AWAY = 1001;
    public static final int PROTOCOL_ERROR = 1002;
    public static final int REFUSE = 1003;
    public static final int NOCODE = 1005;
    public static final int ABNORMAL_CLOSE = 1006;
    public static final int NO_UTF8 = 1007;
    public static final int POLICY_VALIDATION = 1008;
    public static final int TOOBIG = 1009;
    public static final int EXTENSION = 1010;
    public static final int UNEXPECTED_CONDITION = 1011;
    public static final int SERVICE_RESTART = 1012;
    public static final int TRY_AGAIN_LATER = 1013;
    public static final int BAD_GATEWAY = 1014;
    public static final int TLS_ERROR = 1015;
    public static final int NEVER_CONNECTED = -1;
    public static final int BUGGYCLOSE = -2;
    public static final int FLASHPOLICY = -3;
    private int code;
    private String reason;

    public CloseFrame() {
        this(1000, "");
    }

    public CloseFrame(int code, String reason) {
        super(Opcode.CLOSING);
        this.reason = reason;
        this.setCode(code);
    }

    public void setCode(int code) {
        this.code = code;
        if (code == 1015) {
            this.code = 1005;
            this.reason = "";
        }
        this.updatePayload();
    }

    public void setReason(String reason) {
        this.reason = reason == null ? "" : reason;
        this.updatePayload();
    }

    public int getCloseCode() {
        return this.code;
    }

    public String getMessage() {
        return this.reason;
    }

    @Override
    public String toString() {
        return super.toString() + "code: " + this.code;
    }

    @Override
    public boolean isValid() {
        if (!super.isValid() || this.code == 1007 && this.reason.isEmpty() || this.code == 1005 && 0 < this.reason.length() || this.code > 1015 && this.code < 3000) {
            return false;
        }
        return this.code != 1006 && this.code != 1015 && this.code != 1005 && this.code <= 4999 && this.code >= 1000 && this.code != 1004;
    }

    @Override
    public void setPayload(byte[] payload) {
        this.reason = "";
        if (payload.length == 0) {
            this.code = 1000;
        } else if (payload.length == 1) {
            this.code = 1002;
        } else {
            this.code = (payload[0] & 0xFF) << 8 | payload[1] & 0xFF;
            try {
                this.reason = new String(Arrays.copyOfRange(payload, 2, payload.length), StandardCharsets.UTF_8);
            }
            catch (IllegalArgumentException e) {
                this.code = 1007;
                this.reason = null;
            }
        }
    }

    private void updatePayload() {
        byte[] rsn = this.reason.getBytes(StandardCharsets.UTF_8);
        byte[] out = new byte[rsn.length + 2];
        out[0] = (byte)(this.code >>> 8 & 0xFF);
        out[1] = (byte)(this.code & 0xFF);
        System.arraycopy(rsn, 0, out, 2, rsn.length);
        super.setPayload(out);
    }

    @Override
    public byte[] getPayloadData() {
        if (this.code == 1005) {
            return new byte[0];
        }
        return super.getPayloadData();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CloseFrame that = (CloseFrame)o;
        if (this.code != that.code) {
            return false;
        }
        return Objects.equals(this.reason, that.reason);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.code;
        result = 31 * result + (this.reason != null ? this.reason.hashCode() : 0);
        return result;
    }
}

