/*
 * Decompiled with CFR 0.152.
 */
package org.lorislab.quarkus.barn.sqlclient.deployment;

import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.lorislab.quarkus.barn.models.Resource;
import org.lorislab.quarkus.barn.models.ResourceLoader;
import org.lorislab.quarkus.barn.models.VersionedMigration;
import org.lorislab.quarkus.barn.sqlclient.deployment.BarnPoolBuildItem;
import org.lorislab.quarkus.barn.sqlclient.runtime.BarnBuildTimeConfig;
import org.lorislab.quarkus.barn.sqlclient.runtime.BarnRecorder;
import org.lorislab.quarkus.barn.sqlclient.runtime.BarnRuntimeConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BarnSqlClientProcessor {
    private static final Logger log = LoggerFactory.getLogger(BarnSqlClientProcessor.class);
    private static final String JAR_PROTOCOL = "jar";
    private static final String FILE_PROTOCOL = "file";
    public static String BARN_CLIENT = "barn-sql-client";
    BarnBuildTimeConfig config;

    @BuildStep
    CapabilityBuildItem capability() {
        return new CapabilityBuildItem(BARN_CLIENT);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    ServiceStartBuildItem configureRuntimeProperties(BarnRecorder recorder, BarnRuntimeConfig runtimeConfig, BarnPoolBuildItem poolBuildItem, BeanContainerBuildItem beanContainer) {
        BeanContainer container = beanContainer.getValue();
        recorder.doStartActions(poolBuildItem.getPool(), runtimeConfig, container);
        return new ServiceStartBuildItem(BARN_CLIENT);
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void build(BuildProducer<FeatureBuildItem> feature, BarnRecorder recorder, BuildProducer<NativeImageResourceBuildItem> resource) throws IOException, URISyntaxException {
        feature.produce((BuildItem)new FeatureBuildItem(BARN_CLIENT));
        String location = this.config.location;
        if (location == null || location.isBlank()) {
            throw new IllegalStateException("'barn.location' is empty!");
        }
        List<Resource> resources = this.getMigrationFiles(location);
        if (!resources.isEmpty()) {
            List migrations;
            ResourceLoader.validateResources(resources);
            String[] paths = (String[])resources.stream().map(x -> x.script).toArray(String[]::new);
            resource.produce((BuildItem)new NativeImageResourceBuildItem(paths));
            List repeatableMigration = resources.stream().filter(r -> r.repeatable).sorted().collect(Collectors.toList());
            if (!repeatableMigration.isEmpty()) {
                recorder.setRepeatableMigrations(repeatableMigration);
            }
            if (!(migrations = resources.stream().filter(r -> !r.repeatable).map(VersionedMigration::new).sorted().collect(Collectors.toList())).isEmpty()) {
                recorder.setVersionedMigrations(migrations);
            }
        }
        List afterMigrationScripts = this.config.testDataScripts;
        afterMigrationScripts.remove("-no-value-");
        if (!afterMigrationScripts.isEmpty()) {
            recorder.setAfterMigrationScripts(afterMigrationScripts);
            resource.produce((BuildItem)new NativeImageResourceBuildItem(afterMigrationScripts.toArray(new String[0])));
        }
    }

    private List<Resource> getMigrationFiles(String location) throws IOException, URISyntaxException {
        if (location == null || location.isBlank()) {
            return Collections.emptyList();
        }
        ArrayList<Resource> result = new ArrayList<Resource>();
        Enumeration<URL> migrations = Thread.currentThread().getContextClassLoader().getResources(location);
        while (migrations.hasMoreElements()) {
            URL path = migrations.nextElement();
            log.info("Adding application migrations in path '{}' using protocol '{}'", (Object)path.getPath(), (Object)path.getProtocol());
            if (JAR_PROTOCOL.equals(path.getProtocol())) {
                FileSystem fileSystem = this.initFileSystem(path.toURI());
                try {
                    result.addAll(this.getResources(location, path, JAR_PROTOCOL));
                    continue;
                }
                finally {
                    if (fileSystem != null) {
                        fileSystem.close();
                    }
                    continue;
                }
            }
            if (FILE_PROTOCOL.equals(path.getProtocol())) {
                result.addAll(this.getResources(location, path, FILE_PROTOCOL));
                continue;
            }
            log.warn("Unsupported URL protocol '{}' for path '{}'. Migration files will not be discovered.", (Object)path.getProtocol(), (Object)path.getPath());
        }
        return result;
    }

    private Set<Resource> getResources(String location, URL path, String protocol) throws IOException, URISyntaxException {
        try (Stream<Path> pathStream = Files.walk(Paths.get(path.toURI()), new FileVisitOption[0]);){
            Set<Resource> set = pathStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(it -> {
                String resourcePath = Paths.get(location, it.getFileName().toString()).toString();
                Resource r = ResourceLoader.createFrom((String)resourcePath);
                byte[] data = this.loadResourceContent(protocol, (Path)it, resourcePath);
                r.checksum = ResourceLoader.checksum((byte[])data);
                return r;
            }).filter(r -> r.checksum > 0L).peek(it -> log.debug("Discovered: " + it)).collect(Collectors.toSet());
            return set;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] loadResourceContent(String protocol, Path it, String resourcePath) {
        if (JAR_PROTOCOL.equals(protocol)) {
            try {
                return Files.readAllBytes(it);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
        try (InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourcePath);){
            if (in == null) return null;
            byte[] byArray = in.readAllBytes();
            return byArray;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private FileSystem initFileSystem(URI uri) throws IOException {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        return FileSystems.newFileSystem(uri, env);
    }
}

