/*
 * Decompiled with CFR 0.152.
 */
package org.lorislab.quarkus.jel.log.deployment;

import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.inject.Singleton;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.lorislab.quarkus.jel.log.deployment.BuildConfig;
import org.lorislab.quarkus.jel.log.deployment.LogBuilderEnhancer;
import org.lorislab.quarkus.jel.log.deployment.LoggerParamInfo;
import org.lorislab.quarkus.jel.log.interceptor.LoggerBuilder;
import org.lorislab.quarkus.jel.log.interceptor.LoggerBuilderService;
import org.lorislab.quarkus.jel.log.interceptor.LoggerParam;
import org.lorislab.quarkus.jel.log.interceptor.LoggerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogBuild {
    private static final Logger log = LoggerFactory.getLogger(LogBuild.class);
    BuildConfig buildConfig;
    private static final DotName LOG_PARAM = DotName.createSimple((String)LoggerParam.class.getName());
    private static final String LOG_BUILDER_SERVICE = LoggerBuilderService.class.getName();
    private static final List<DotName> ANNOTATION_DOT_NAMES = Stream.of(ApplicationScoped.class, Singleton.class, RequestScoped.class).map(Class::getName).map(DotName::createSimple).collect(Collectors.toList());
    static final String FEATURE_NAME = "jel-log";

    @BuildStep
    FeatureBuildItem createFeatureItem() {
        return new FeatureBuildItem(FEATURE_NAME);
    }

    @BuildStep
    void loggerParameter(CombinedIndexBuildItem indexBuildItem, BuildProducer<BytecodeTransformerBuildItem> transformers) {
        Collection annotations = indexBuildItem.getIndex().getAnnotations(LOG_PARAM);
        if (annotations != null && !annotations.isEmpty()) {
            HashMap<DotName, LoggerParamInfo> mapClasses = new HashMap<DotName, LoggerParamInfo>();
            HashMap<DotName, LoggerParamInfo> mapAssignableFrom = new HashMap<DotName, LoggerParamInfo>();
            for (AnnotationInstance annotation : annotations) {
                MethodInfo methodInfo = annotation.target().asMethod();
                short mod = methodInfo.flags();
                if (Modifier.isPublic(mod) && Modifier.isStatic(mod)) {
                    int priority = annotation.valueWithDefault(indexBuildItem.getIndex(), "priority").asInt();
                    this.addToMap(mapClasses, annotation, "classes", methodInfo, priority);
                    this.addToMap(mapAssignableFrom, annotation, "assignableFrom", methodInfo, priority);
                    continue;
                }
                log.warn("The method {}.{} is not public static and will be ignored.", (Object)methodInfo.declaringClass(), (Object)methodInfo.name());
            }
            if (!mapClasses.isEmpty() || !mapAssignableFrom.isEmpty()) {
                log.debug("MapClasses: {}", mapClasses);
                log.debug("MapAssignableFrom: {}", mapAssignableFrom);
                transformers.produce((BuildItem)new BytecodeTransformerBuildItem(LoggerBuilder.IMPL, (BiFunction)new LogBuilderEnhancer(mapClasses, mapAssignableFrom)));
            }
        }
    }

    private void addToMap(Map<DotName, LoggerParamInfo> map, AnnotationInstance annotation, String valueName, MethodInfo methodInfo, int priority) {
        List<DotName> classes = this.getClassArrayValue(annotation, valueName);
        for (DotName name : classes) {
            LoggerParamInfo info = map.get(name);
            if (info == null) {
                info = new LoggerParamInfo();
                info.name = name;
                info.priority = priority;
                info.methodInfo = methodInfo;
                map.put(name, info);
                continue;
            }
            if (info.priority >= priority) continue;
            info.priority = priority;
            info.methodInfo = methodInfo;
        }
    }

    private List<DotName> getClassArrayValue(AnnotationInstance annotation, String name) {
        AnnotationValue value = annotation.value(name);
        if (value == null) {
            return Collections.emptyList();
        }
        Type[] classes = value.asClassArray();
        if (classes.length > 0) {
            ArrayList<DotName> result = new ArrayList<DotName>(classes.length);
            for (Type type : classes) {
                result.add(type.name());
            }
            return result;
        }
        return Collections.emptyList();
    }

    @BuildStep
    public AnnotationsTransformerBuildItem interceptorBinding() {
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS;
            }

            public void transform(AnnotationsTransformer.TransformationContext context) {
                ClassInfo target = context.getTarget().asClass();
                Map tmp = target.annotations();
                Optional<DotName> dot = ANNOTATION_DOT_NAMES.stream().filter(tmp::containsKey).findFirst();
                if (dot.isPresent()) {
                    String name = target.name().toString();
                    Optional<String> add = LogBuild.this.buildConfig.includes.stream().filter(name::startsWith).findFirst();
                    if (add.isPresent() && !LOG_BUILDER_SERVICE.equals(name)) {
                        context.transform().add(LoggerService.class, new AnnotationValue[0]).done();
                    }
                }
            }
        });
    }
}

