/*
 * Decompiled with CFR 0.152.
 */
package org.lorislab.quarkus.jel.log.deployment;

import java.util.Map;
import java.util.function.BiFunction;
import org.jboss.jandex.DotName;
import org.lorislab.quarkus.jel.log.deployment.LoggerParamInfo;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class LogBuilderEnhancer
implements BiFunction<String, ClassVisitor, ClassVisitor> {
    private Map<DotName, LoggerParamInfo> mapClasses;
    private Map<DotName, LoggerParamInfo> mapAssignableFrom;

    public LogBuilderEnhancer(Map<DotName, LoggerParamInfo> mapClasses, Map<DotName, LoggerParamInfo> mapAssignableFrom) {
        this.mapClasses = mapClasses;
        this.mapAssignableFrom = mapAssignableFrom;
    }

    @Override
    public ClassVisitor apply(String className, ClassVisitor outputClassVisitor) {
        return new AbstractEntityBuilderEnhancerClassVisitor(outputClassVisitor, this.mapClasses, this.mapAssignableFrom);
    }

    static class AbstractEntityBuilderEnhancerClassVisitor
    extends ClassVisitor {
        private Map<DotName, LoggerParamInfo> mapClasses;
        private Map<DotName, LoggerParamInfo> mapAssignableFrom;

        public AbstractEntityBuilderEnhancerClassVisitor(ClassVisitor outputClassVisitor, Map<DotName, LoggerParamInfo> mapClasses, Map<DotName, LoggerParamInfo> mapAssignableFrom) {
            super(458752, outputClassVisitor);
            this.mapClasses = mapClasses;
            this.mapAssignableFrom = mapAssignableFrom;
        }

        public void visitEnd() {
            if (this.mapClasses != null && !this.mapClasses.isEmpty()) {
                this.addClasses("getClasses", this.mapClasses);
            }
            if (this.mapAssignableFrom != null && !this.mapAssignableFrom.isEmpty()) {
                this.addClasses("getAssignableFrom", this.mapAssignableFrom);
            }
            super.visitEnd();
        }

        private void addClasses(String methodName, Map<DotName, LoggerParamInfo> data) {
            MethodVisitor visitor = super.visitMethod(4161, methodName, "()Ljava/util/Map;", "()Ljava/util/Map<Ljava/lang/Class;Ljava/util/function/Function<Ljava/lang/Object;Ljava/lang/String;>;>;", null);
            visitor.visitCode();
            visitor.visitTypeInsn(187, "java/util/HashMap");
            visitor.visitInsn(89);
            visitor.visitMethodInsn(183, "java/util/HashMap", "<init>", "()V", false);
            visitor.visitVarInsn(58, 1);
            for (Map.Entry<DotName, LoggerParamInfo> entry : data.entrySet()) {
                LoggerParamInfo info = entry.getValue();
                this.addMapping(visitor, AbstractEntityBuilderEnhancerClassVisitor.getInternalName(info.name), AbstractEntityBuilderEnhancerClassVisitor.getInternalName(info.methodInfo.declaringClass().name()), info.methodInfo.name());
            }
            visitor.visitVarInsn(25, 1);
            visitor.visitInsn(176);
            visitor.visitMaxs(0, 1);
            visitor.visitEnd();
        }

        private void addMapping(MethodVisitor visitor, String className, String methodClass, String methodName) {
            Handle handle = new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", false);
            Type param1 = Type.getType((String)"(Ljava/lang/Object;)Ljava/lang/Object;");
            Handle param2 = new Handle(6, methodClass, methodName, "(Ljava/lang/Object;)Ljava/lang/String;", false);
            Type param3 = Type.getType((String)"(Ljava/lang/Object;)Ljava/lang/String;");
            visitor.visitVarInsn(25, 1);
            visitor.visitLdcInsn((Object)Type.getType((String)("L" + className + ";")));
            visitor.visitInvokeDynamicInsn("apply", "()Ljava/util/function/Function;", handle, new Object[]{param1, param2, param3});
            visitor.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", true);
            visitor.visitInsn(87);
        }

        private static String getInternalName(DotName clazz) {
            return clazz.toString().replace('.', '/');
        }
    }
}

