package org.lwapp.dropwizard.core.config;

import java.util.HashSet;
import java.util.Set;

import io.dropwizard.Configuration;

public class CoreConfiguration extends Configuration {

    private String applicationName;
    private Integer adminPort;
    private Set<String> applicationPackagesToLoad = new HashSet<>();

    public String getApplicationName() {
        return applicationName;
    }

    public void setApplicationName(final String applicationName) {
        this.applicationName = applicationName;
    }

    public Integer getAdminPort() {
        return adminPort;
    }

    public void setAdminPort(final Integer adminPort) {
        this.adminPort = adminPort;
    }

    public Set<String> getApplicationPackagesToLoad() {
        if (applicationPackagesToLoad == null) {
            applicationPackagesToLoad = new HashSet<>();
        }
        applicationPackagesToLoad.add("org.lwapp");
        return applicationPackagesToLoad;
    }

    public void setApplicationPackagesToLoad(final Set<String> applicationPackagesToLoad) {
        this.applicationPackagesToLoad = applicationPackagesToLoad;
    }

    //    KEY_STORE_PATH("application.keystore.path", "/var/opt/lwapp/ssl/keystore"), //
    //    KEY_STORE_PASS("application.key.store.password", true), //
    //    KEY_MANAGED_PASS("application.key.managed.password", true), //
    //    APPLICATION_NAME("application.name"), //
    //    TRUST_STORE_PASS("application.trust.store.password", true), //
    //    ADMIN_PORT("application.invoke.admin.port", "11111"), //
    //    IS_WEB_APP("application.is.web.application", "false"), //
    //    APP_ENVIRONMENT("application.environment", "DEV", "Identify the system type in which the application is deployed ('DEV','TEST' or 'PROD')"), //
    //

}
