package org.lwapp.dropwizard.core.metrics;

import java.lang.management.ManagementFactory;

import com.codahale.metrics.Gauge;
import com.sun.management.OperatingSystemMXBean;

public class CpuUsageGauge implements Gauge<Integer> {
    @Override
    public Integer getValue() {
        final OperatingSystemMXBean mbean = (com.sun.management.OperatingSystemMXBean) ManagementFactory.getOperatingSystemMXBean();

        return (int) Math.ceil(mbean.getSystemCpuLoad() * 100);
    }
}
