package org.lwapp.dropwizard.core.quartz;

import javax.inject.Inject;

import org.lwapp.configclient.AutoStartable;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerFactory;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

public abstract class AbstractQuartzSchedular implements AutoStartable {
    @Inject
    private CdiJobFactory jobFactory;

    @Override
    public void init() throws Exception {
        final SchedulerFactory sf = new StdSchedulerFactory();
        final Scheduler sched = sf.getScheduler();
        sched.setJobFactory(jobFactory);
        final JobDetail job = JobBuilder.newJob(getJobClass())
                .withIdentity(getClass().getName())
                .build();

        final Trigger trigger = createTrigger();
        sched.scheduleJob(job, trigger);
        sched.start();
    }

    protected abstract Class<? extends Job> getJobClass();

    protected abstract Trigger createTrigger();

}
