package org.lwapp.dropwizard.core.quartz;

import javax.enterprise.inject.Instance;
import javax.inject.Inject;

import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.spi.JobFactory;
import org.quartz.spi.TriggerFiredBundle;

public class CdiJobFactory implements JobFactory {

    @Inject
    private Instance<Job> jobInstance;

    @Override
    public Job newJob(final TriggerFiredBundle bundle, final Scheduler scheduler) throws SchedulerException {
        final JobDetail jobDetail = bundle.getJobDetail();
        final Class<? extends Job> jobClass = jobDetail.getJobClass();
        try {
            return getBean(jobClass);
        } catch (final Exception e) {
            throw new SchedulerException("Problem instantiating class '" + jobDetail.getJobClass().getName() + "'", e);
        }
    }

    private Job getBean(final Class<? extends Job> jobClass) {
        final Instance<? extends Job> job = jobInstance.select(jobClass);

        if (job.isAmbiguous()) {
            throw new IllegalStateException("Cannot produce job: ambiguous instance");
        }

        if (job.isUnsatisfied()) {
            throw new IllegalStateException("Cannot produce job: unsatisfied instance");
        }

        return job.get();
    }

}
