package org.macrocloud.kernel.fastdfs.controller;

import javax.annotation.Resource;

import org.macrocloud.kernel.fastdfs.utils.FileDfsUtil;
import org.macrocloud.kernel.toolkit.api.R;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class BaseController {
    @Resource
    private FileDfsUtil fileDfsUtil;
    
    
    @RequestMapping(value = "/module-fastdfs/uploadFile",headers="content-type=multipart/form-data", method = RequestMethod.POST)
    public R<String> uploadFile (@RequestParam("file") MultipartFile file){
        String result ;
        try{
            String path = fileDfsUtil.upload(file) ;
            if (!StringUtils.isEmpty(path)){
                result = path ;
            } else {
                result = "上传失败" ;
            }
        } catch (Exception e){
            e.printStackTrace() ;
            result = "服务异常" ;
        }
        return R.data(result);
    }

    @RequestMapping(value = "/module-fastdfs/deleteByPath", method = RequestMethod.GET)
    public R<String> deleteByPath (String filePathName){
       // String filePathName = "group1/M00/00/00/wKhIgl0n4AKABxQEABhlMYw_3Lo825.png" ;
        fileDfsUtil.deleteFile(filePathName);
        return R.data("SUCCESS") ;
    }

}
