/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.io.ByteStreams;
import io.minio.AbortMultipartUploadResponse;
import io.minio.BaseArgs;
import io.minio.BucketArgs;
import io.minio.BucketExistsArgs;
import io.minio.CloseableIterator;
import io.minio.ComposeObjectArgs;
import io.minio.ComposeSource;
import io.minio.CopyObjectArgs;
import io.minio.CreateMultipartUploadResponse;
import io.minio.DeleteBucketEncryptionArgs;
import io.minio.DeleteBucketLifecycleArgs;
import io.minio.DeleteBucketNotificationArgs;
import io.minio.DeleteBucketPolicyArgs;
import io.minio.DeleteBucketTagsArgs;
import io.minio.DeleteObjectLockConfigurationArgs;
import io.minio.DeleteObjectTagsArgs;
import io.minio.DeleteObjectsResponse;
import io.minio.Digest;
import io.minio.Directive;
import io.minio.DisableObjectLegalHoldArgs;
import io.minio.DownloadObjectArgs;
import io.minio.EnableObjectLegalHoldArgs;
import io.minio.GetBucketEncryptionArgs;
import io.minio.GetBucketLifecycleArgs;
import io.minio.GetBucketNotificationArgs;
import io.minio.GetBucketPolicyArgs;
import io.minio.GetBucketReplicationArgs;
import io.minio.GetBucketTagsArgs;
import io.minio.GetBucketVersioningArgs;
import io.minio.GetObjectArgs;
import io.minio.GetObjectLockConfigurationArgs;
import io.minio.GetObjectResponse;
import io.minio.GetObjectRetentionArgs;
import io.minio.GetObjectTagsArgs;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.HttpRequestBody;
import io.minio.IsObjectLegalHoldEnabledArgs;
import io.minio.ListBucketsArgs;
import io.minio.ListMultipartUploadsResponse;
import io.minio.ListObjectVersionsResponse;
import io.minio.ListObjectsArgs;
import io.minio.ListObjectsV1Response;
import io.minio.ListObjectsV2Response;
import io.minio.ListPartsResponse;
import io.minio.ListenBucketNotificationArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioProperties;
import io.minio.ObjectArgs;
import io.minio.ObjectReadArgs;
import io.minio.ObjectWriteResponse;
import io.minio.PostPolicy;
import io.minio.PutObjectArgs;
import io.minio.PutObjectBaseArgs;
import io.minio.RemoveBucketArgs;
import io.minio.RemoveObjectArgs;
import io.minio.RemoveObjectsArgs;
import io.minio.Result;
import io.minio.S3Escaper;
import io.minio.SelectObjectContentArgs;
import io.minio.SelectResponseStream;
import io.minio.ServerSideEncryptionCustomerKey;
import io.minio.SetBucketEncryptionArgs;
import io.minio.SetBucketLifecycleArgs;
import io.minio.SetBucketNotificationArgs;
import io.minio.SetBucketPolicyArgs;
import io.minio.SetBucketReplicationArgs;
import io.minio.SetBucketTagsArgs;
import io.minio.SetBucketVersioningArgs;
import io.minio.SetObjectLockConfigurationArgs;
import io.minio.SetObjectRetentionArgs;
import io.minio.SetObjectTagsArgs;
import io.minio.Signer;
import io.minio.StatObjectArgs;
import io.minio.StatObjectResponse;
import io.minio.Time;
import io.minio.UploadObjectArgs;
import io.minio.UploadPartCopyResponse;
import io.minio.UploadPartResponse;
import io.minio.Xml;
import io.minio.credentials.Credentials;
import io.minio.credentials.Provider;
import io.minio.credentials.StaticProvider;
import io.minio.errors.BucketPolicyTooLargeException;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import io.minio.http.Method;
import io.minio.messages.Bucket;
import io.minio.messages.CopyObjectResult;
import io.minio.messages.CopyPartResult;
import io.minio.messages.CreateBucketConfiguration;
import io.minio.messages.DeleteError;
import io.minio.messages.DeleteMarker;
import io.minio.messages.DeleteObject;
import io.minio.messages.DeleteRequest;
import io.minio.messages.DeleteResult;
import io.minio.messages.ErrorResponse;
import io.minio.messages.InitiateMultipartUploadResult;
import io.minio.messages.Item;
import io.minio.messages.LegalHold;
import io.minio.messages.LifecycleConfiguration;
import io.minio.messages.ListAllMyBucketsResult;
import io.minio.messages.ListBucketResultV1;
import io.minio.messages.ListBucketResultV2;
import io.minio.messages.ListMultipartUploadsResult;
import io.minio.messages.ListObjectsResult;
import io.minio.messages.ListPartsResult;
import io.minio.messages.ListVersionsResult;
import io.minio.messages.LocationConstraint;
import io.minio.messages.NotificationConfiguration;
import io.minio.messages.NotificationRecords;
import io.minio.messages.ObjectLockConfiguration;
import io.minio.messages.Part;
import io.minio.messages.Prefix;
import io.minio.messages.ReplicationConfiguration;
import io.minio.messages.Retention;
import io.minio.messages.SelectObjectContentRequest;
import io.minio.messages.SseConfiguration;
import io.minio.messages.Tags;
import io.minio.messages.VersioningConfiguration;
import io.minio.org.apache.commons.validator.routines.InetAddressValidator;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class MinioClient {
    private static final String NO_SUCH_BUCKET_MESSAGE = "Bucket does not exist";
    private static final String NO_SUCH_BUCKET = "NoSuchBucket";
    private static final String NO_SUCH_BUCKET_POLICY = "NoSuchBucketPolicy";
    private static final String NO_SUCH_OBJECT_LOCK_CONFIGURATION = "NoSuchObjectLockConfiguration";
    private static final String RETRY_HEAD = "RetryHead";
    private static final String SERVER_SIDE_ENCRYPTION_CONFIGURATION_NOT_FOUND_ERROR = "ServerSideEncryptionConfigurationNotFoundError";
    private static final byte[] EMPTY_BODY = new byte[0];
    private static final long DEFAULT_CONNECTION_TIMEOUT = 5L;
    private static final int MAX_BUCKET_POLICY_SIZE = 20480;
    private static final int DEFAULT_EXPIRY_TIME = 604800;
    private static final String DEFAULT_USER_AGENT = "MinIO (" + System.getProperty("os.name") + "; " + System.getProperty("os.arch") + ") minio-java/" + MinioProperties.INSTANCE.getVersion();
    private static final String END_HTTP = "----------END-HTTP----------";
    private static final String US_EAST_1 = "us-east-1";
    private static final String UPLOAD_ID = "uploadId";
    private static final Set<String> TRACE_QUERY_PARAMS = ImmutableSet.of((Object)"retention", (Object)"legal-hold", (Object)"tagging", (Object)"uploadId");
    private final Map<String, String> regionCache = new ConcurrentHashMap<String, String>();
    private String userAgent = DEFAULT_USER_AGENT;
    private PrintWriter traceStream;
    private HttpUrl baseUrl;
    private String region;
    private boolean isAwsHost;
    private boolean isAcceleratedHost;
    private boolean isDualStackHost;
    private boolean useVirtualStyle;
    private Provider provider;
    private OkHttpClient httpClient;

    private MinioClient(HttpUrl baseUrl, String region, boolean isAwsHost, boolean isAcceleratedHost, boolean isDualStackHost, boolean useVirtualStyle, Provider provider, OkHttpClient httpClient) {
        this.baseUrl = baseUrl;
        this.region = region;
        this.isAwsHost = isAwsHost;
        this.isAcceleratedHost = isAcceleratedHost;
        this.isDualStackHost = isDualStackHost;
        this.useVirtualStyle = useVirtualStyle;
        this.provider = provider;
        this.httpClient = httpClient;
    }

    protected MinioClient(MinioClient client) {
        this.baseUrl = client.baseUrl;
        this.region = client.region;
        this.isAwsHost = client.isAwsHost;
        this.isAcceleratedHost = client.isAcceleratedHost;
        this.isDualStackHost = client.isDualStackHost;
        this.useVirtualStyle = client.useVirtualStyle;
        this.provider = client.provider;
        this.httpClient = client.httpClient;
    }

    private void checkArgs(BaseArgs args) {
        if (args == null) {
            throw new IllegalArgumentException("null arguments");
        }
    }

    private Multimap<String, String> merge(Multimap<String, String> m1, Multimap<String, String> m2) {
        HashMultimap map = HashMultimap.create();
        if (m1 != null) {
            map.putAll(m1);
        }
        if (m2 != null) {
            map.putAll(m2);
        }
        return map;
    }

    private Multimap<String, String> newMultimap(String ... keysAndValues) {
        if (keysAndValues.length % 2 != 0) {
            throw new IllegalArgumentException("Expected alternating keys and values");
        }
        HashMultimap map = HashMultimap.create();
        for (int i = 0; i < keysAndValues.length; i += 2) {
            map.put((Object)keysAndValues[i], (Object)keysAndValues[i + 1]);
        }
        return map;
    }

    private Multimap<String, String> newMultimap(Map<String, String> map) {
        return map != null ? Multimaps.forMap(map) : HashMultimap.create();
    }

    private Multimap<String, String> newMultimap(Multimap<String, String> map) {
        return map != null ? HashMultimap.create(map) : HashMultimap.create();
    }

    private String[] handleRedirectResponse(Method method, String bucketName, Response response, boolean retry) {
        String code = null;
        String message = null;
        if (response.code() == 301) {
            code = "PermanentRedirect";
            message = "Moved Permanently";
        } else if (response.code() == 307) {
            code = "Redirect";
            message = "Temporary redirect";
        } else if (response.code() == 400) {
            code = "BadRequest";
            message = "Bad request";
        }
        String region = response.headers().get("x-amz-bucket-region");
        if (message != null && region != null) {
            message = message + ". Use region " + region;
        }
        if (retry && region != null && method.equals((Object)Method.HEAD) && bucketName != null && this.regionCache.get(bucketName) != null) {
            code = RETRY_HEAD;
            message = null;
        }
        return new String[]{code, message};
    }

    protected HttpUrl buildUrl(Method method, String bucketName, String objectName, String region, Multimap<String, String> queryParamMap) throws NoSuchAlgorithmException {
        if (bucketName == null && objectName != null) {
            throw new IllegalArgumentException("null bucket name for object '" + objectName + "'");
        }
        HttpUrl.Builder urlBuilder = this.baseUrl.newBuilder();
        String host = this.baseUrl.host();
        if (bucketName != null) {
            boolean enforcePathStyle = false;
            if (method == Method.PUT && objectName == null && queryParamMap == null) {
                enforcePathStyle = true;
            } else if (queryParamMap != null && queryParamMap.containsKey((Object)"location")) {
                enforcePathStyle = true;
            } else if (bucketName.contains(".") && this.baseUrl.isHttps()) {
                enforcePathStyle = true;
            }
            if (this.isAwsHost) {
                String[] s3Domain = "s3.";
                if (this.isAcceleratedHost) {
                    if (bucketName.contains(".")) {
                        throw new IllegalArgumentException("bucket name '" + bucketName + "' with '.' is not allowed for accelerated endpoint");
                    }
                    if (!enforcePathStyle) {
                        s3Domain = "s3-accelerate.";
                    }
                }
                String dualStack = "";
                if (this.isDualStackHost) {
                    dualStack = "dualstack.";
                }
                String endpoint = (String)s3Domain + dualStack;
                if (enforcePathStyle || !this.isAcceleratedHost) {
                    endpoint = endpoint + region + ".";
                }
                host = endpoint + host;
            }
            if (enforcePathStyle || !this.useVirtualStyle) {
                urlBuilder.host(host);
                urlBuilder.addEncodedPathSegment(S3Escaper.encode((String)bucketName));
            } else {
                urlBuilder.host(bucketName + "." + host);
            }
            if (objectName != null) {
                for (String token : objectName.split("/")) {
                    if (!token.equals(".") && !token.equals("..")) continue;
                    throw new IllegalArgumentException("object name with '.' or '..' path segment is not supported");
                }
                urlBuilder.addEncodedPathSegments(S3Escaper.encodePath((String)objectName));
            }
        } else if (this.isAwsHost) {
            urlBuilder.host("s3." + region + "." + host);
        }
        if (queryParamMap != null) {
            for (Map.Entry entry : queryParamMap.entries()) {
                urlBuilder.addEncodedQueryParameter(S3Escaper.encode((String)((String)entry.getKey())), S3Escaper.encode((String)((String)entry.getValue())));
            }
        }
        return urlBuilder.build();
    }

    private String getHostHeader(HttpUrl url) {
        if (url.scheme().equals("http") && url.port() == 80 || url.scheme().equals("https") && url.port() == 443) {
            return url.host();
        }
        return url.host() + ":" + url.port();
    }

    private Headers httpHeaders(Multimap<String, String> headerMap) {
        Headers.Builder builder = new Headers.Builder();
        if (headerMap == null) {
            return builder.build();
        }
        if (headerMap.containsKey((Object)"Content-Encoding")) {
            builder.add("Content-Encoding", headerMap.get((Object)"Content-Encoding").stream().distinct().filter(encoding -> !encoding.isEmpty()).collect(Collectors.joining(",")));
        }
        for (Map.Entry entry : headerMap.entries()) {
            if (((String)entry.getKey()).equals("Content-Encoding")) continue;
            builder.addUnsafeNonAscii((String)entry.getKey(), (String)entry.getValue());
        }
        return builder.build();
    }

    protected Request createRequest(HttpUrl url, Method method, Headers headers, Object body, int length, Credentials creds) throws InsufficientDataException, InternalException, IOException, NoSuchAlgorithmException {
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.url(url);
        if (headers != null) {
            requestBuilder.headers(headers);
        }
        requestBuilder.header("Host", this.getHostHeader(url));
        requestBuilder.header("Accept-Encoding", "identity");
        requestBuilder.header("User-Agent", this.userAgent);
        String sha256Hash = null;
        String md5Hash = null;
        if (creds != null) {
            if (url.isHttps()) {
                sha256Hash = "UNSIGNED-PAYLOAD";
                if (body != null) {
                    md5Hash = Digest.md5Hash((Object)body, (int)length);
                }
            } else {
                Object data = body;
                int len = length;
                if (data == null) {
                    data = new byte[0];
                    len = 0;
                }
                String[] hashes = Digest.sha256Md5Hashes((Object)data, (int)len);
                sha256Hash = hashes[0];
                md5Hash = hashes[1];
            }
        } else if (body != null) {
            md5Hash = Digest.md5Hash((Object)body, (int)length);
        }
        if (md5Hash != null) {
            requestBuilder.header("Content-MD5", md5Hash);
        }
        if (sha256Hash != null) {
            requestBuilder.header("x-amz-content-sha256", sha256Hash);
        }
        if (creds != null && creds.sessionToken() != null) {
            requestBuilder.header("X-Amz-Security-Token", creds.sessionToken());
        }
        ZonedDateTime date = ZonedDateTime.now();
        requestBuilder.header("x-amz-date", date.format(Time.AMZ_DATE_FORMAT));
        HttpRequestBody requestBody = null;
        if (body != null) {
            String contentType;
            String string = contentType = headers != null ? headers.get("Content-Type") : null;
            requestBody = body instanceof RandomAccessFile ? new HttpRequestBody((RandomAccessFile)body, length, contentType) : (body instanceof BufferedInputStream ? new HttpRequestBody((BufferedInputStream)body, length, contentType) : new HttpRequestBody((byte[])body, length, contentType));
        }
        requestBuilder.method(method.toString(), requestBody);
        return requestBuilder.build();
    }

    private StringBuilder newTraceBuilder(Request request, String body) {
        StringBuilder traceBuilder = new StringBuilder();
        traceBuilder.append("---------START-HTTP---------\n");
        String encodedPath = request.url().encodedPath();
        String encodedQuery = request.url().encodedQuery();
        if (encodedQuery != null) {
            encodedPath = encodedPath + "?" + encodedQuery;
        }
        traceBuilder.append(request.method()).append(" ").append(encodedPath).append(" HTTP/1.1\n");
        traceBuilder.append(request.headers().toString().replaceAll("Signature=([0-9a-f]+)", "Signature=*REDACTED*").replaceAll("Credential=([^/]+)", "Credential=*REDACTED*"));
        if (body != null) {
            traceBuilder.append("\n").append(body);
        }
        return traceBuilder;
    }

    protected Response execute(Method method, BaseArgs args, Multimap<String, String> headers, Multimap<String, String> queryParams, Object body, int length) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        String bucketName = null;
        String region = null;
        String objectName = null;
        if (args instanceof BucketArgs) {
            bucketName = ((BucketArgs)args).bucket();
            region = ((BucketArgs)args).region();
        }
        if (args instanceof ObjectArgs) {
            objectName = ((ObjectArgs)args).object();
        }
        return this.execute(method, bucketName, objectName, this.getRegion(bucketName, region), this.httpHeaders(this.merge((Multimap<String, String>)args.extraHeaders(), headers)), this.merge((Multimap<String, String>)args.extraQueryParams(), queryParams), body, length);
    }

    protected Response execute(Method method, String bucketName, String objectName, String region, Headers headers, Multimap<String, String> queryParamMap, Object body, int length) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        boolean traceRequestBody = false;
        if (!(body == null || body instanceof InputStream || body instanceof RandomAccessFile || body instanceof byte[])) {
            byte[] bytes = body instanceof CharSequence ? body.toString().getBytes(StandardCharsets.UTF_8) : Xml.marshal((Object)body).getBytes(StandardCharsets.UTF_8);
            body = bytes;
            length = bytes.length;
            traceRequestBody = true;
        }
        if (body == null && (method == Method.PUT || method == Method.POST)) {
            body = EMPTY_BODY;
        }
        HttpUrl url = this.buildUrl(method, bucketName, objectName, region, queryParamMap);
        Credentials creds = this.provider == null ? null : this.provider.fetch();
        Request request = this.createRequest(url, method, headers, body, length, creds);
        if (creds != null) {
            request = Signer.signV4S3((Request)request, (String)region, (String)creds.accessKey(), (String)creds.secretKey(), (String)request.header("x-amz-content-sha256"));
        }
        StringBuilder traceBuilder = this.newTraceBuilder(request, traceRequestBody ? new String((byte[])body, StandardCharsets.UTF_8) : null);
        PrintWriter traceStream = this.traceStream;
        if (traceStream != null) {
            traceStream.println(traceBuilder.toString());
        }
        traceBuilder.append("\n");
        OkHttpClient httpClient = this.httpClient;
        if (!(body instanceof byte[] || method != Method.PUT && method != Method.POST)) {
            httpClient = this.httpClient.newBuilder().retryOnConnectionFailure(false).build();
        }
        Response response = httpClient.newCall(request).execute();
        String trace = response.protocol().toString().toUpperCase(Locale.US) + " " + response.code() + "\n" + response.headers();
        traceBuilder.append(trace).append("\n");
        if (traceStream != null) {
            traceStream.println(trace);
        }
        if (response.isSuccessful()) {
            if (traceStream != null) {
                Set keys = queryParamMap.keySet();
                if (!(method == Method.GET && objectName != null && Collections.disjoint(keys, TRACE_QUERY_PARAMS) || keys.contains("events") && (keys.contains("prefix") || keys.contains("suffix")))) {
                    ResponseBody responseBody = response.peekBody(0x100000L);
                    traceStream.println(responseBody.string());
                }
                traceStream.println(END_HTTP);
            }
            return response;
        }
        String errorXml = null;
        try (ResponseBody responseBody = response.body();){
            errorXml = responseBody.string();
        }
        if (!"".equals(errorXml) || !method.equals((Object)Method.HEAD)) {
            traceBuilder.append(errorXml).append("\n");
            if (traceStream != null) {
                traceStream.println(errorXml);
            }
        }
        traceBuilder.append(END_HTTP).append("\n");
        if (traceStream != null) {
            traceStream.println(END_HTTP);
        }
        String contentType = response.headers().get("content-type");
        if (!(method.equals((Object)Method.HEAD) || contentType != null && Arrays.asList(contentType.split(";")).contains("application/xml"))) {
            throw new InvalidResponseException(response.code(), contentType, errorXml.substring(0, errorXml.length() > 1024 ? 1024 : errorXml.length()), traceBuilder.toString());
        }
        ErrorResponse errorResponse = null;
        if (!"".equals(errorXml)) {
            errorResponse = (ErrorResponse)Xml.unmarshal(ErrorResponse.class, (String)errorXml);
        } else if (!method.equals((Object)Method.HEAD)) {
            throw new InvalidResponseException(response.code(), contentType, errorXml, traceBuilder.toString());
        }
        if (errorResponse == null) {
            String code = null;
            String message = null;
            switch (response.code()) {
                case 301: 
                case 307: 
                case 400: {
                    String[] result = this.handleRedirectResponse(method, bucketName, response, true);
                    code = result[0];
                    message = result[1];
                    break;
                }
                case 404: {
                    if (objectName != null) {
                        code = "NoSuchKey";
                        message = "Object does not exist";
                        break;
                    }
                    if (bucketName != null) {
                        code = NO_SUCH_BUCKET;
                        message = NO_SUCH_BUCKET_MESSAGE;
                        break;
                    }
                    code = "ResourceNotFound";
                    message = "Request resource not found";
                    break;
                }
                case 405: 
                case 501: {
                    code = "MethodNotAllowed";
                    message = "The specified method is not allowed against this resource";
                    break;
                }
                case 409: {
                    if (bucketName != null) {
                        code = NO_SUCH_BUCKET;
                        message = NO_SUCH_BUCKET_MESSAGE;
                        break;
                    }
                    code = "ResourceConflict";
                    message = "Request resource conflicts";
                    break;
                }
                case 403: {
                    code = "AccessDenied";
                    message = "Access denied";
                    break;
                }
                case 412: {
                    code = "PreconditionFailed";
                    message = "At least one of the preconditions you specified did not hold";
                    break;
                }
                case 416: {
                    code = "InvalidRange";
                    message = "The requested range cannot be satisfied";
                    break;
                }
                default: {
                    if (response.code() >= 500) {
                        throw new ServerException("server failed with HTTP status code " + response.code(), traceBuilder.toString());
                    }
                    throw new InternalException("unhandled HTTP code " + response.code() + ".  Please report this issue at https://github.com/minio/minio-java/issues", traceBuilder.toString());
                }
            }
            errorResponse = new ErrorResponse(code, message, bucketName, objectName, request.url().encodedPath(), response.header("x-amz-request-id"), response.header("x-amz-id-2"));
        }
        if (errorResponse.code().equals(NO_SUCH_BUCKET) || errorResponse.code().equals(RETRY_HEAD)) {
            this.regionCache.remove(bucketName);
        }
        throw new ErrorResponseException(errorResponse, response, traceBuilder.toString());
    }

    protected String getRegion(String bucketName, String region) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        if (region != null) {
            if (this.region != null && !this.region.equals(region)) {
                throw new IllegalArgumentException("region must be " + this.region + ", but passed " + region);
            }
            return region;
        }
        if (this.region != null && !this.region.equals("")) {
            return this.region;
        }
        if (bucketName == null || this.provider == null) {
            return US_EAST_1;
        }
        region = this.regionCache.get(bucketName);
        if (region != null) {
            return region;
        }
        Response response = this.execute(Method.GET, bucketName, null, US_EAST_1, null, this.newMultimap("location", null), null, 0);
        try (ResponseBody body = response.body();){
            LocationConstraint lc = (LocationConstraint)Xml.unmarshal(LocationConstraint.class, (Reader)body.charStream());
            region = lc.location() == null || lc.location().equals("") ? US_EAST_1 : (lc.location().equals("EU") ? "eu-west-1" : lc.location());
        }
        this.regionCache.put(bucketName, region);
        return region;
    }

    private Response executeGet(BaseArgs args, Multimap<String, String> headers, Multimap<String, String> queryParams) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        return this.execute(Method.GET, args, headers, queryParams, null, 0);
    }

    private Response executeHead(BaseArgs args, Multimap<String, String> headers, Multimap<String, String> queryParams) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            Response response = this.execute(Method.HEAD, args, headers, queryParams, null, 0);
            response.body().close();
            return response;
        }
        catch (ErrorResponseException e) {
            if (!e.errorResponse().code().equals(RETRY_HEAD)) {
                throw e;
            }
            try {
                Response response = this.execute(Method.HEAD, args, headers, queryParams, null, 0);
                response.body().close();
                return response;
            }
            catch (ErrorResponseException e2) {
                ErrorResponse errorResponse = e2.errorResponse();
                if (!errorResponse.code().equals(RETRY_HEAD)) {
                    throw e2;
                }
                String[] result = this.handleRedirectResponse(Method.HEAD, errorResponse.bucketName(), e2.response(), false);
                throw new ErrorResponseException(new ErrorResponse(result[0], result[1], errorResponse.bucketName(), errorResponse.objectName(), errorResponse.resource(), errorResponse.requestId(), errorResponse.hostId()), e2.response(), e2.httpTrace());
            }
        }
    }

    private Response executeDelete(BaseArgs args, Multimap<String, String> headers, Multimap<String, String> queryParams) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        Response response = this.execute(Method.DELETE, args, headers, queryParams, null, 0);
        response.body().close();
        return response;
    }

    private Response executePost(BaseArgs args, Multimap<String, String> headers, Multimap<String, String> queryParams, Object data) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        return this.execute(Method.POST, args, headers, queryParams, data, 0);
    }

    private Response executePut(BaseArgs args, Multimap<String, String> headers, Multimap<String, String> queryParams, Object data, int length) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        return this.execute(Method.PUT, args, headers, queryParams, data, length);
    }

    public StatObjectResponse statObject(StatObjectArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs((BaseArgs)args);
        args.validateSsec(this.baseUrl);
        Response response = this.executeHead((BaseArgs)args, (Multimap<String, String>)args.getHeaders(), args.versionId() != null ? this.newMultimap("versionId", args.versionId()) : null);
        return new StatObjectResponse(response.headers(), args.bucket(), args.region(), args.object());
    }

    public GetObjectResponse getObject(GetObjectArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs((BaseArgs)args);
        args.validateSsec(this.baseUrl);
        Response response = this.executeGet((BaseArgs)args, (Multimap<String, String>)args.getHeaders(), args.versionId() != null ? this.newMultimap("versionId", args.versionId()) : null);
        return new GetObjectResponse(response.headers(), args.bucket(), args.region(), args.object(), response.body().byteStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadObject(DownloadObjectArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        String filename = args.filename();
        Path filePath = Paths.get(filename, new String[0]);
        boolean fileExists = Files.exists(filePath, new LinkOption[0]);
        StatObjectResponse stat = this.statObject(new StatObjectArgs((ObjectReadArgs)args));
        String tempFilename = filename + "." + stat.etag() + ".part.minio";
        Path tempFilePath = Paths.get(tempFilename, new String[0]);
        boolean tempFileExists = Files.exists(tempFilePath, new LinkOption[0]);
        if (tempFileExists && !Files.isRegularFile(tempFilePath, new LinkOption[0])) {
            throw new IOException(tempFilename + ": not a regular file");
        }
        long tempFileSize = 0L;
        if (tempFileExists && (tempFileSize = Files.size(tempFilePath)) > stat.size()) {
            Files.delete(tempFilePath);
            tempFileExists = false;
            tempFileSize = 0L;
        }
        if (fileExists) {
            long fileSize = Files.size(filePath);
            if (fileSize == stat.size()) {
                return;
            }
            if (fileSize > stat.size()) {
                throw new IllegalArgumentException("Source object, '" + args.object() + "', size:" + stat.size() + " is smaller than the destination file, '" + filename + "', size:" + fileSize);
            }
            if (!tempFileExists) {
                Files.copy(filePath, tempFilePath, new CopyOption[0]);
                tempFileSize = fileSize;
                tempFileExists = true;
            }
        }
        InputStream is = null;
        OutputStream os = null;
        try {
            is = this.getObject(new GetObjectArgs(args));
            os = Files.newOutputStream(tempFilePath, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            long bytesWritten = ByteStreams.copy((InputStream)is, (OutputStream)os);
            is.close();
            os.close();
            if (bytesWritten != stat.size() - tempFileSize) {
                throw new IOException(tempFilename + ": unexpected data written.  expected = " + (stat.size() - tempFileSize) + ", written = " + bytesWritten);
            }
            Files.move(tempFilePath, filePath, StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    public ObjectWriteResponse copyObject(CopyObjectArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs((BaseArgs)args);
        args.validateSse(this.baseUrl);
        long size = -1L;
        if (args.source().offset() != null && args.source().length() != null) {
            StatObjectResponse stat = this.statObject(new StatObjectArgs((ObjectReadArgs)args.source()));
            size = stat.size();
        }
        if (args.source().offset() != null || args.source().length() != null || size > 0x140000000L) {
            if (args.metadataDirective() != null && args.metadataDirective() == Directive.COPY) {
                throw new IllegalArgumentException("COPY metadata directive is not applicable to source object size greater than 5 GiB");
            }
            if (args.taggingDirective() != null && args.taggingDirective() == Directive.COPY) {
                throw new IllegalArgumentException("COPY tagging directive is not applicable to source object size greater than 5 GiB");
            }
            return this.composeObject(new ComposeObjectArgs(args));
        }
        Multimap headers = args.genHeaders();
        if (args.metadataDirective() != null) {
            headers.put((Object)"x-amz-metadata-directive", (Object)args.metadataDirective().name());
        }
        if (args.taggingDirective() != null) {
            headers.put((Object)"x-amz-tagging-directive", (Object)args.taggingDirective().name());
        }
        headers.putAll(args.source().genCopyHeaders());
        try (Response response = this.executePut((BaseArgs)args, (Multimap<String, String>)headers, null, null, 0);){
            CopyObjectResult result = (CopyObjectResult)Xml.unmarshal(CopyObjectResult.class, (Reader)response.body().charStream());
            ObjectWriteResponse objectWriteResponse = new ObjectWriteResponse(response.headers(), args.bucket(), args.region(), args.object(), result.etag(), response.header("x-amz-version-id"));
            return objectWriteResponse;
        }
    }

    private int calculatePartCount(List<ComposeSource> sources) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        long objectSize = 0L;
        int partCount = 0;
        int i = 0;
        for (ComposeSource src : sources) {
            ++i;
            StatObjectResponse stat = this.statObject(new StatObjectArgs((ObjectReadArgs)src));
            src.buildHeaders(stat.size(), stat.etag());
            long size = stat.size();
            if (src.length() != null) {
                size = src.length();
            } else if (src.offset() != null) {
                size -= src.offset().longValue();
            }
            if (size < 0x500000L && sources.size() != 1 && i != sources.size()) {
                throw new IllegalArgumentException("source " + src.bucket() + "/" + src.object() + ": size " + size + " must be greater than " + 0x500000);
            }
            if ((objectSize += size) > 0x50000000000L) {
                throw new IllegalArgumentException("destination object size must be less than 5497558138880");
            }
            if (size > 0x140000000L) {
                long count = size / 0x140000000L;
                long lastPartSize = size - count * 0x140000000L;
                if (lastPartSize > 0L) {
                    ++count;
                } else {
                    lastPartSize = 0x140000000L;
                }
                if (lastPartSize < 0x500000L && sources.size() != 1 && i != sources.size()) {
                    throw new IllegalArgumentException("source " + src.bucket() + "/" + src.object() + ": for multipart split upload of " + size + ", last part size is less than " + 0x500000);
                }
                partCount += (int)count;
            } else {
                ++partCount;
            }
            if (partCount <= 10000) continue;
            throw new IllegalArgumentException("Compose sources create more than allowed multipart count 10000");
        }
        return partCount;
    }

    public ObjectWriteResponse composeObject(ComposeObjectArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs((BaseArgs)args);
        args.validateSse(this.baseUrl);
        List sources = args.sources();
        int partCount = this.calculatePartCount(sources);
        if (partCount == 1 && ((ComposeSource)args.sources().get(0)).offset() == null && ((ComposeSource)args.sources().get(0)).length() == null) {
            return this.copyObject(new CopyObjectArgs(args));
        }
        Multimap<String, String> headers = this.newMultimap((Multimap<String, String>)args.extraHeaders());
        headers.putAll(args.genHeaders());
        CreateMultipartUploadResponse createMultipartUploadResponse = this.createMultipartUpload(args.bucket(), args.region(), args.object(), headers, (Multimap<String, String>)args.extraQueryParams());
        String uploadId = createMultipartUploadResponse.result().uploadId();
        HashMultimap ssecHeaders = HashMultimap.create();
        if (args.sse() != null && args.sse() instanceof ServerSideEncryptionCustomerKey) {
            ssecHeaders.putAll(this.newMultimap(args.sse().headers()));
        }
        try {
            int partNumber = 0;
            Part[] totalParts = new Part[partCount];
            for (ComposeSource src : sources) {
                long size = src.objectSize();
                if (src.length() != null) {
                    size = src.length();
                } else if (src.offset() != null) {
                    size -= src.offset().longValue();
                }
                long offset = 0L;
                if (src.offset() != null) {
                    offset = src.offset();
                }
                headers = this.newMultimap((Multimap<String, String>)src.headers());
                headers.putAll((Multimap)ssecHeaders);
                if (size <= 0x140000000L) {
                    ++partNumber;
                    if (src.length() != null) {
                        headers.put((Object)"x-amz-copy-source-range", (Object)("bytes=" + offset + "-" + (offset + src.length() - 1L)));
                    } else if (src.offset() != null) {
                        headers.put((Object)"x-amz-copy-source-range", (Object)("bytes=" + offset + "-" + (offset + size - 1L)));
                    }
                    UploadPartCopyResponse response = this.uploadPartCopy(args.bucket(), args.region(), args.object(), uploadId, partNumber, headers, null);
                    String eTag = response.result().etag();
                    totalParts[partNumber - 1] = new Part(partNumber, eTag);
                    continue;
                }
                while (size > 0L) {
                    ++partNumber;
                    long startBytes = offset;
                    long endBytes = startBytes + 0x140000000L;
                    if (size < 0x140000000L) {
                        endBytes = startBytes + size;
                    }
                    Multimap<String, String> headersCopy = this.newMultimap(headers);
                    headersCopy.put((Object)"x-amz-copy-source-range", (Object)("bytes=" + startBytes + "-" + endBytes));
                    UploadPartCopyResponse response = this.uploadPartCopy(args.bucket(), args.region(), args.object(), uploadId, partNumber, headersCopy, null);
                    String eTag = response.result().etag();
                    totalParts[partNumber - 1] = new Part(partNumber, eTag);
                    offset = startBytes;
                    size -= endBytes - startBytes;
                }
            }
            return this.completeMultipartUpload(args.bucket(), this.getRegion(args.bucket(), args.region()), args.object(), uploadId, totalParts, null, null);
        }
        catch (RuntimeException e) {
            this.abortMultipartUpload(args.bucket(), args.region(), args.object(), uploadId, null, null);
            throw e;
        }
        catch (Exception e) {
            this.abortMultipartUpload(args.bucket(), args.region(), args.object(), uploadId, null, null);
            throw e;
        }
    }

    public String getPresignedObjectUrl(GetPresignedObjectUrlArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException, ServerException {
        this.checkArgs((BaseArgs)args);
        byte[] body = (byte[])(args.method() == Method.PUT || args.method() == Method.POST ? EMPTY_BODY : null);
        Multimap<String, String> queryParams = this.newMultimap((Multimap<String, String>)args.extraQueryParams());
        if (args.versionId() != null) {
            queryParams.put((Object)"versionId", (Object)args.versionId());
        }
        String region = this.getRegion(args.bucket(), args.region());
        if (this.provider == null) {
            HttpUrl url = this.buildUrl(args.method(), args.bucket(), args.object(), region, queryParams);
            return url.toString();
        }
        Credentials creds = this.provider.fetch();
        if (creds.sessionToken() != null) {
            queryParams.put((Object)"X-Amz-Security-Token", (Object)creds.sessionToken());
        }
        HttpUrl url = this.buildUrl(args.method(), args.bucket(), args.object(), region, queryParams);
        Request request = this.createRequest(url, args.method(), args.extraHeaders() == null ? null : this.httpHeaders((Multimap<String, String>)args.extraHeaders()), body, 0, creds);
        url = Signer.presignV4((Request)request, (String)region, (String)creds.accessKey(), (String)creds.secretKey(), (int)args.expiry());
        return url.toString();
    }

    public Map<String, String> getPresignedPostFormData(PostPolicy policy) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        if (this.provider == null) {
            throw new IllegalArgumentException("Anonymous access does not require presigned post form-data");
        }
        return policy.formData(this.provider.fetch(), this.getRegion(policy.bucket(), null));
    }

    public void removeObject(RemoveObjectArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs((BaseArgs)args);
        this.executeDelete((BaseArgs)args, args.bypassGovernanceMode() ? this.newMultimap("x-amz-bypass-governance-retention", "true") : null, args.versionId() != null ? this.newMultimap("versionId", args.versionId()) : null);
    }

    public Iterable<Result<DeleteError>> removeObjects(final RemoveObjectsArgs args) {
        this.checkArgs((BaseArgs)args);
        return new Iterable<Result<DeleteError>>(){

            @Override
            public Iterator<Result<DeleteError>> iterator() {
                return new Iterator<Result<DeleteError>>(){
                    private Result<DeleteError> error = null;
                    private Iterator<DeleteError> errorIterator = null;
                    private boolean completed = false;
                    private Iterator<DeleteObject> objectIter;
                    {
                        this.objectIter = args.objects().iterator();
                    }

                    private void setError() {
                        this.error = null;
                        while (this.errorIterator.hasNext()) {
                            DeleteError deleteError = this.errorIterator.next();
                            if ("NoSuchVersion".equals(deleteError.code())) continue;
                            this.error = new Result((Object)deleteError);
                            break;
                        }
                    }

                    private synchronized void populate() {
                        if (this.completed) {
                            return;
                        }
                        try {
                            LinkedList<DeleteObject> objectList = new LinkedList<DeleteObject>();
                            while (this.objectIter.hasNext() && objectList.size() < 1000) {
                                objectList.add(this.objectIter.next());
                            }
                            this.completed = objectList.isEmpty();
                            if (this.completed) {
                                return;
                            }
                            DeleteObjectsResponse response = MinioClient.this.deleteObjects(args.bucket(), args.region(), objectList, true, args.bypassGovernanceMode(), (Multimap<String, String>)args.extraHeaders(), (Multimap<String, String>)args.extraQueryParams());
                            if (!response.result().errorList().isEmpty()) {
                                this.errorIterator = response.result().errorList().iterator();
                                this.setError();
                                this.completed = true;
                            }
                        }
                        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
                            this.error = new Result((Exception)e);
                            this.completed = true;
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        while (this.error == null && this.errorIterator == null && !this.completed) {
                            this.populate();
                        }
                        if (this.error == null && this.errorIterator != null) {
                            this.setError();
                        }
                        if (this.error != null) {
                            return true;
                        }
                        if (this.completed) {
                            return false;
                        }
                        this.errorIterator = null;
                        return this.hasNext();
                    }

                    @Override
                    public Result<DeleteError> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        if (this.error != null) {
                            Result<DeleteError> error = this.error;
                            this.error = null;
                            return error;
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public Iterable<Result<Item>> listObjects(ListObjectsArgs args) {
        if (args.includeVersions() || args.versionIdMarker() != null) {
            return this.listObjectVersions(args);
        }
        if (args.useApiVersion1()) {
            return this.listObjectsV1(args);
        }
        return this.listObjectsV2(args);
    }

    private Iterable<Result<Item>> listObjectsV2(final ListObjectsArgs args) {
        return new Iterable<Result<Item>>(){

            @Override
            public Iterator<Result<Item>> iterator() {
                return new ObjectIterator(){
                    private ListBucketResultV2 result;
                    {
                        this.result = null;
                    }

                    @Override
                    protected void populateResult() throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
                        this.listObjectsResult = null;
                        this.itemIterator = null;
                        this.prefixIterator = null;
                        ListObjectsV2Response response = MinioClient.this.listObjectsV2(args.bucket(), args.region(), args.delimiter(), args.useUrlEncodingType() ? "url" : null, args.startAfter(), args.maxKeys(), args.prefix(), this.result == null ? args.continuationToken() : this.result.nextContinuationToken(), args.fetchOwner(), args.includeUserMetadata(), (Multimap<String, String>)args.extraHeaders(), (Multimap<String, String>)args.extraQueryParams());
                        this.result = response.result();
                        this.listObjectsResult = response.result();
                    }
                };
            }
        };
    }

    private Iterable<Result<Item>> listObjectsV1(final ListObjectsArgs args) {
        return new Iterable<Result<Item>>(){

            @Override
            public Iterator<Result<Item>> iterator() {
                return new ObjectIterator(){
                    private ListBucketResultV1 result;
                    {
                        this.result = null;
                    }

                    @Override
                    protected void populateResult() throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
                        String nextMarker;
                        this.listObjectsResult = null;
                        this.itemIterator = null;
                        this.prefixIterator = null;
                        String string = nextMarker = this.result == null ? args.marker() : this.result.nextMarker();
                        if (nextMarker == null) {
                            nextMarker = this.lastObjectName;
                        }
                        ListObjectsV1Response response = MinioClient.this.listObjectsV1(args.bucket(), args.region(), args.delimiter(), args.useUrlEncodingType() ? "url" : null, nextMarker, args.maxKeys(), args.prefix(), (Multimap<String, String>)args.extraHeaders(), (Multimap<String, String>)args.extraQueryParams());
                        this.result = response.result();
                        this.listObjectsResult = response.result();
                    }
                };
            }
        };
    }

    private Iterable<Result<Item>> listObjectVersions(final ListObjectsArgs args) {
        return new Iterable<Result<Item>>(){

            @Override
            public Iterator<Result<Item>> iterator() {
                return new ObjectIterator(){
                    private ListVersionsResult result;
                    {
                        this.result = null;
                    }

                    @Override
                    protected void populateResult() throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
                        this.listObjectsResult = null;
                        this.itemIterator = null;
                        this.prefixIterator = null;
                        ListObjectVersionsResponse response = MinioClient.this.listObjectVersions(args.bucket(), args.region(), args.delimiter(), args.useUrlEncodingType() ? "url" : null, this.result == null ? args.keyMarker() : this.result.nextKeyMarker(), args.maxKeys(), args.prefix(), this.result == null ? args.versionIdMarker() : this.result.nextVersionIdMarker(), (Multimap<String, String>)args.extraHeaders(), (Multimap<String, String>)args.extraQueryParams());
                        this.result = response.result();
                        this.listObjectsResult = response.result();
                    }
                };
            }
        };
    }

    public List<Bucket> listBuckets() throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        return this.listBuckets((ListBucketsArgs)ListBucketsArgs.builder().build());
    }

    public List<Bucket> listBuckets(ListBucketsArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try (Response response = this.executeGet((BaseArgs)args, null, null);){
            ListAllMyBucketsResult result = (ListAllMyBucketsResult)Xml.unmarshal(ListAllMyBucketsResult.class, (Reader)response.body().charStream());
            List list = result.buckets();
            return list;
        }
    }

    public boolean bucketExists(BucketExistsArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            this.executeHead((BaseArgs)args, null, null);
            return true;
        }
        catch (ErrorResponseException e) {
            if (!e.errorResponse().code().equals(NO_SUCH_BUCKET)) {
                throw e;
            }
            return false;
        }
    }

    public void makeBucket(MakeBucketArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs((BaseArgs)args);
        String region = args.region();
        if (this.region != null && !this.region.isEmpty()) {
            if (region != null && !region.equals(this.region)) {
                throw new IllegalArgumentException("region must be " + this.region + ", but passed " + region);
            }
            region = this.region;
        }
        if (region == null) {
            region = US_EAST_1;
        }
        Multimap<String, String> headers = args.objectLock() ? this.newMultimap("x-amz-bucket-object-lock-enabled", "true") : null;
        try (Response response = this.execute(Method.PUT, args.bucket(), null, region, this.httpHeaders(this.merge((Multimap<String, String>)args.extraHeaders(), headers)), (Multimap<String, String>)args.extraQueryParams(), region.equals(US_EAST_1) ? null : new CreateBucketConfiguration(region), 0);){
            this.regionCache.put(args.bucket(), region);
        }
    }

    public void setBucketVersioning(SetBucketVersioningArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs((BaseArgs)args);
        Response response = this.executePut((BaseArgs)args, null, this.newMultimap("versioning", ""), args.config(), 0);
        response.close();
    }

    public VersioningConfiguration getBucketVersioning(GetBucketVersioningArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs((BaseArgs)args);
        try (Response response = this.executeGet((BaseArgs)args, null, this.newMultimap("versioning", ""));){
            VersioningConfiguration versioningConfiguration = (VersioningConfiguration)Xml.unmarshal(VersioningConfiguration.class, (Reader)response.body().charStream());
            return versioningConfiguration;
        }
    }

    public void setObjectLockConfiguration(SetObjectLockConfigurationArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs((BaseArgs)args);
        Response response = this.executePut((BaseArgs)args, null, this.newMultimap("object-lock", ""), args.config(), 0);
        response.close();
    }

    public void deleteObjectLockConfiguration(DeleteObjectLockConfigurationArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs((BaseArgs)args);
        Response response = this.executePut((BaseArgs)args, null, this.newMultimap("object-lock", ""), new ObjectLockConfiguration(), 0);
        response.close();
    }

    public ObjectLockConfiguration getObjectLockConfiguration(GetObjectLockConfigurationArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs((BaseArgs)args);
        try (Response response = this.executeGet((BaseArgs)args, null, this.newMultimap("object-lock", ""));){
            ObjectLockConfiguration objectLockConfiguration = (ObjectLockConfiguration)Xml.unmarshal(ObjectLockConfiguration.class, (Reader)response.body().charStream());
            return objectLockConfiguration;
        }
    }

    public void setObjectRetention(SetObjectRetentionArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs((BaseArgs)args);
        Multimap<String, String> queryParams = this.newMultimap("retention", "");
        if (args.versionId() != null) {
            queryParams.put((Object)"versionId", (Object)args.versionId());
        }
        Response response = this.executePut((BaseArgs)args, args.bypassGovernanceMode() ? this.newMultimap("x-amz-bypass-governance-retention", "True") : null, queryParams, args.config(), 0);
        response.close();
    }

    public Retention getObjectRetention(GetObjectRetentionArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        Retention retention;
        block10: {
            this.checkArgs((BaseArgs)args);
            Multimap<String, String> queryParams = this.newMultimap("retention", "");
            if (args.versionId() != null) {
                queryParams.put((Object)"versionId", (Object)args.versionId());
            }
            Response response = this.executeGet((BaseArgs)args, null, queryParams);
            try {
                retention = (Retention)Xml.unmarshal(Retention.class, (Reader)response.body().charStream());
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ErrorResponseException e) {
                    if (!e.errorResponse().code().equals(NO_SUCH_OBJECT_LOCK_CONFIGURATION)) {
                        throw e;
                    }
                    return null;
                }
            }
            response.close();
        }
        return retention;
    }

    public void enableObjectLegalHold(EnableObjectLegalHoldArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs((BaseArgs)args);
        Multimap<String, String> queryParams = this.newMultimap("legal-hold", "");
        if (args.versionId() != null) {
            queryParams.put((Object)"versionId", (Object)args.versionId());
        }
        Response response = this.executePut((BaseArgs)args, null, queryParams, new LegalHold(true), 0);
        response.close();
    }

    public void disableObjectLegalHold(DisableObjectLegalHoldArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs((BaseArgs)args);
        Multimap<String, String> queryParams = this.newMultimap("legal-hold", "");
        if (args.versionId() != null) {
            queryParams.put((Object)"versionId", (Object)args.versionId());
        }
        Response response = this.executePut((BaseArgs)args, null, queryParams, new LegalHold(false), 0);
        response.close();
    }

    public boolean isObjectLegalHoldEnabled(IsObjectLegalHoldEnabledArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        boolean bl;
        block10: {
            this.checkArgs((BaseArgs)args);
            Multimap<String, String> queryParams = this.newMultimap("legal-hold", "");
            if (args.versionId() != null) {
                queryParams.put((Object)"versionId", (Object)args.versionId());
            }
            Response response = this.executeGet((BaseArgs)args, null, queryParams);
            try {
                LegalHold result = (LegalHold)Xml.unmarshal(LegalHold.class, (Reader)response.body().charStream());
                bl = result.status();
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ErrorResponseException e) {
                    if (!e.errorResponse().code().equals(NO_SUCH_OBJECT_LOCK_CONFIGURATION)) {
                        throw e;
                    }
                    return false;
                }
            }
            response.close();
        }
        return bl;
    }

    public void removeBucket(RemoveBucketArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs((BaseArgs)args);
        this.executeDelete((BaseArgs)args, null, null);
        this.regionCache.remove(args.bucket());
    }

    private ObjectWriteResponse putObject(PutObjectBaseArgs args, Object data, long objectSize, long partSize, int partCount, String contentType) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        Multimap<String, String> headers = this.newMultimap((Multimap<String, String>)args.extraHeaders());
        headers.putAll(args.genHeaders());
        if (!headers.containsKey((Object)"Content-Type")) {
            headers.put((Object)"Content-Type", (Object)contentType);
        }
        String uploadId = null;
        long uploadedSize = 0L;
        Part[] parts = null;
        ByteArrayOutputStream buffer = null;
        try {
            for (int partNumber = 1; partNumber <= partCount || partCount < 0; ++partNumber) {
                long availableSize = partSize;
                if (partCount > 0) {
                    if (partNumber == partCount) {
                        availableSize = objectSize - uploadedSize;
                    }
                } else {
                    availableSize = this.getAvailableSize(data, partSize + 1L);
                    if (availableSize <= partSize) {
                        partCount = partNumber;
                    } else {
                        availableSize = partSize;
                    }
                }
                Object body = data;
                if (args.preloadData()) {
                    if (buffer == null) {
                        buffer = new ByteArrayOutputStream();
                    }
                    this.fillData(buffer, data, availableSize);
                    body = buffer.toByteArray();
                }
                if (partCount == 1) {
                    return this.putObject(args.bucket(), args.region(), args.object(), body, (int)availableSize, headers, (Multimap<String, String>)args.extraQueryParams());
                }
                if (uploadId == null) {
                    CreateMultipartUploadResponse response = this.createMultipartUpload(args.bucket(), args.region(), args.object(), headers, (Multimap<String, String>)args.extraQueryParams());
                    uploadId = response.result().uploadId();
                    parts = new Part[10000];
                }
                Map ssecHeaders = null;
                if (args.sse() != null && args.sse() instanceof ServerSideEncryptionCustomerKey) {
                    ssecHeaders = args.sse().headers();
                }
                UploadPartResponse response = this.uploadPart(args.bucket(), args.region(), args.object(), body, (int)availableSize, uploadId, partNumber, (Multimap<String, String>)(ssecHeaders != null ? Multimaps.forMap((Map)ssecHeaders) : null), null);
                String etag = response.etag();
                parts[partNumber - 1] = new Part(partNumber, etag);
                uploadedSize += availableSize;
            }
            return this.completeMultipartUpload(args.bucket(), args.region(), args.object(), uploadId, parts, null, null);
        }
        catch (RuntimeException e) {
            if (uploadId != null) {
                this.abortMultipartUpload(args.bucket(), args.region(), args.object(), uploadId, null, null);
            }
            throw e;
        }
        catch (Exception e) {
            if (uploadId != null) {
                this.abortMultipartUpload(args.bucket(), args.region(), args.object(), uploadId, null, null);
            }
            throw e;
        }
    }

    public ObjectWriteResponse putObject(PutObjectArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs((BaseArgs)args);
        args.validateSse(this.baseUrl);
        return this.putObject((PutObjectBaseArgs)args, args.stream(), args.objectSize(), args.partSize(), args.partCount(), args.contentType());
    }

    public ObjectWriteResponse uploadObject(UploadObjectArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs((BaseArgs)args);
        args.validateSse(this.baseUrl);
        try (RandomAccessFile file = new RandomAccessFile(args.filename(), "r");){
            ObjectWriteResponse objectWriteResponse = this.putObject((PutObjectBaseArgs)args, file, args.objectSize(), args.partSize(), args.partCount(), args.contentType());
            return objectWriteResponse;
        }
    }

    public String getBucketPolicy(GetBucketPolicyArgs args) throws BucketPolicyTooLargeException, ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        String string;
        block12: {
            this.checkArgs((BaseArgs)args);
            Response response = this.executeGet((BaseArgs)args, null, this.newMultimap("policy", ""));
            try {
                byte[] buf = new byte[20480];
                int bytesRead = 0;
                bytesRead = response.body().byteStream().read(buf, 0, 20480);
                if (bytesRead < 0) {
                    throw new IOException("unexpected EOF when reading bucket policy");
                }
                if (bytesRead == 20480) {
                    int byteRead = 0;
                    while (byteRead == 0 && (byteRead = response.body().byteStream().read()) >= 0) {
                        if (byteRead <= 0) continue;
                        throw new BucketPolicyTooLargeException(args.bucket());
                    }
                }
                string = new String(buf, 0, bytesRead, StandardCharsets.UTF_8);
                if (response == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ErrorResponseException e) {
                    if (!e.errorResponse().code().equals(NO_SUCH_BUCKET_POLICY)) {
                        throw e;
                    }
                    return "";
                }
            }
            response.close();
        }
        return string;
    }

    public void setBucketPolicy(SetBucketPolicyArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs((BaseArgs)args);
        Response response = this.executePut((BaseArgs)args, this.newMultimap("Content-Type", "application/json"), this.newMultimap("policy", ""), args.config(), 0);
        response.close();
    }

    public void deleteBucketPolicy(DeleteBucketPolicyArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        block2: {
            this.checkArgs((BaseArgs)args);
            try {
                this.executeDelete((BaseArgs)args, null, this.newMultimap("policy", ""));
            }
            catch (ErrorResponseException e) {
                if (e.errorResponse().code().equals(NO_SUCH_BUCKET_POLICY)) break block2;
                throw e;
            }
        }
    }

    public void setBucketLifecycle(SetBucketLifecycleArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs((BaseArgs)args);
        Response response = this.executePut((BaseArgs)args, null, this.newMultimap("lifecycle", ""), args.config(), 0);
        response.close();
    }

    public void deleteBucketLifecycle(DeleteBucketLifecycleArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs((BaseArgs)args);
        this.executeDelete((BaseArgs)args, null, this.newMultimap("lifecycle", ""));
    }

    public LifecycleConfiguration getBucketLifecycle(GetBucketLifecycleArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        LifecycleConfiguration lifecycleConfiguration;
        block9: {
            this.checkArgs((BaseArgs)args);
            Response response = this.executeGet((BaseArgs)args, null, this.newMultimap("lifecycle", ""));
            try {
                lifecycleConfiguration = (LifecycleConfiguration)Xml.unmarshal(LifecycleConfiguration.class, (Reader)response.body().charStream());
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ErrorResponseException e) {
                    if (!e.errorResponse().code().equals("NoSuchLifecycleConfiguration")) {
                        throw e;
                    }
                    return null;
                }
            }
            response.close();
        }
        return lifecycleConfiguration;
    }

    public NotificationConfiguration getBucketNotification(GetBucketNotificationArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs((BaseArgs)args);
        try (Response response = this.executeGet((BaseArgs)args, null, this.newMultimap("notification", ""));){
            NotificationConfiguration notificationConfiguration = (NotificationConfiguration)Xml.unmarshal(NotificationConfiguration.class, (Reader)response.body().charStream());
            return notificationConfiguration;
        }
    }

    public void setBucketNotification(SetBucketNotificationArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs((BaseArgs)args);
        Response response = this.executePut((BaseArgs)args, null, this.newMultimap("notification", ""), args.config(), 0);
        response.close();
    }

    public void deleteBucketNotification(DeleteBucketNotificationArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs((BaseArgs)args);
        Response response = this.executePut((BaseArgs)args, null, this.newMultimap("notification", ""), new NotificationConfiguration(), 0);
        response.close();
    }

    public ReplicationConfiguration getBucketReplication(GetBucketReplicationArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        ReplicationConfiguration replicationConfiguration;
        block9: {
            this.checkArgs((BaseArgs)args);
            Response response = this.executeGet((BaseArgs)args, null, this.newMultimap("replication", ""));
            try {
                replicationConfiguration = (ReplicationConfiguration)Xml.unmarshal(ReplicationConfiguration.class, (Reader)response.body().charStream());
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ErrorResponseException e) {
                    if (!e.errorResponse().code().equals("ReplicationConfigurationNotFoundError")) {
                        throw e;
                    }
                    return null;
                }
            }
            response.close();
        }
        return replicationConfiguration;
    }

    public void setBucketReplication(SetBucketReplicationArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs((BaseArgs)args);
        Response response = this.executePut((BaseArgs)args, args.objectLockToken() != null ? this.newMultimap("x-amz-bucket-object-lock-token", args.objectLockToken()) : null, this.newMultimap("replication", ""), args.config(), 0);
        response.close();
    }

    public CloseableIterator<Result<NotificationRecords>> listenBucketNotification(ListenBucketNotificationArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs((BaseArgs)args);
        Multimap<String, String> queryParams = this.newMultimap("prefix", args.prefix(), "suffix", args.suffix());
        for (String event : args.events()) {
            queryParams.put((Object)"events", (Object)event);
        }
        Response response = this.executeGet((BaseArgs)args, null, queryParams);
        NotificationResultRecords result = new NotificationResultRecords(response);
        return result.closeableIterator();
    }

    public SelectResponseStream selectObjectContent(SelectObjectContentArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs((BaseArgs)args);
        args.validateSsec(this.baseUrl);
        Response response = this.executePost((BaseArgs)args, args.ssec() != null ? this.newMultimap(args.ssec().headers()) : null, this.newMultimap("select", "", "select-type", "2"), new SelectObjectContentRequest(args.sqlExpression(), args.requestProgress().booleanValue(), args.inputSerialization(), args.outputSerialization(), args.scanStartRange(), args.scanEndRange()));
        return new SelectResponseStream(response.body().byteStream());
    }

    public void setBucketEncryption(SetBucketEncryptionArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs((BaseArgs)args);
        Response response = this.executePut((BaseArgs)args, null, this.newMultimap("encryption", ""), args.config(), 0);
        response.close();
    }

    public SseConfiguration getBucketEncryption(GetBucketEncryptionArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        SseConfiguration sseConfiguration;
        block9: {
            this.checkArgs((BaseArgs)args);
            Response response = this.executeGet((BaseArgs)args, null, this.newMultimap("encryption", ""));
            try {
                sseConfiguration = (SseConfiguration)Xml.unmarshal(SseConfiguration.class, (Reader)response.body().charStream());
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ErrorResponseException e) {
                    if (!e.errorResponse().code().equals(SERVER_SIDE_ENCRYPTION_CONFIGURATION_NOT_FOUND_ERROR)) {
                        throw e;
                    }
                    return new SseConfiguration(null);
                }
            }
            response.close();
        }
        return sseConfiguration;
    }

    public void deleteBucketEncryption(DeleteBucketEncryptionArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        block2: {
            this.checkArgs((BaseArgs)args);
            try {
                this.executeDelete((BaseArgs)args, null, this.newMultimap("encryption", ""));
            }
            catch (ErrorResponseException e) {
                if (e.errorResponse().code().equals(SERVER_SIDE_ENCRYPTION_CONFIGURATION_NOT_FOUND_ERROR)) break block2;
                throw e;
            }
        }
    }

    public Tags getBucketTags(GetBucketTagsArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        Tags tags;
        block9: {
            this.checkArgs((BaseArgs)args);
            Response response = this.executeGet((BaseArgs)args, null, this.newMultimap("tagging", ""));
            try {
                tags = (Tags)Xml.unmarshal(Tags.class, (Reader)response.body().charStream());
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ErrorResponseException e) {
                    if (!e.errorResponse().code().equals("NoSuchTagSet")) {
                        throw e;
                    }
                    return new Tags();
                }
            }
            response.close();
        }
        return tags;
    }

    public void setBucketTags(SetBucketTagsArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs((BaseArgs)args);
        Response response = this.executePut((BaseArgs)args, null, this.newMultimap("tagging", ""), args.tags(), 0);
        response.close();
    }

    public void deleteBucketTags(DeleteBucketTagsArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs((BaseArgs)args);
        this.executeDelete((BaseArgs)args, null, this.newMultimap("tagging", ""));
    }

    public Tags getObjectTags(GetObjectTagsArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs((BaseArgs)args);
        Multimap<String, String> queryParams = this.newMultimap("tagging", "");
        if (args.versionId() != null) {
            queryParams.put((Object)"versionId", (Object)args.versionId());
        }
        try (Response response = this.executeGet((BaseArgs)args, null, queryParams);){
            Tags tags = (Tags)Xml.unmarshal(Tags.class, (Reader)response.body().charStream());
            return tags;
        }
    }

    public void setObjectTags(SetObjectTagsArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs((BaseArgs)args);
        Multimap<String, String> queryParams = this.newMultimap("tagging", "");
        if (args.versionId() != null) {
            queryParams.put((Object)"versionId", (Object)args.versionId());
        }
        Response response = this.executePut((BaseArgs)args, null, queryParams, args.tags(), 0);
        response.close();
    }

    public void deleteObjectTags(DeleteObjectTagsArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs((BaseArgs)args);
        Multimap<String, String> queryParams = this.newMultimap("tagging", "");
        if (args.versionId() != null) {
            queryParams.put((Object)"versionId", (Object)args.versionId());
        }
        this.executeDelete((BaseArgs)args, null, queryParams);
    }

    private long getAvailableSize(Object data, long expectedReadSize) throws IOException, InternalException {
        long totalBytesRead;
        int bytesRead;
        if (!(data instanceof BufferedInputStream)) {
            throw new InternalException("data must be BufferedInputStream. This should not happen.  Please report to https://github.com/minio/minio-java/issues/", null);
        }
        BufferedInputStream stream = (BufferedInputStream)data;
        stream.mark((int)expectedReadSize);
        byte[] buf = new byte[16384];
        for (totalBytesRead = 0L; totalBytesRead < expectedReadSize; totalBytesRead += (long)bytesRead) {
            long bytesToRead = expectedReadSize - totalBytesRead;
            if (bytesToRead > (long)buf.length) {
                bytesToRead = buf.length;
            }
            if ((bytesRead = stream.read(buf, 0, (int)bytesToRead)) < 0) break;
        }
        stream.reset();
        return totalBytesRead;
    }

    private void fillData(ByteArrayOutputStream buffer, Object data, long size) throws IOException {
        int bytesRead;
        buffer.reset();
        byte[] buf = new byte[16384];
        for (long totalBytesRead = 0L; totalBytesRead < size; totalBytesRead += (long)bytesRead) {
            long bytesToRead = size - totalBytesRead;
            if (bytesToRead > (long)buf.length) {
                bytesToRead = buf.length;
            }
            bytesRead = -1;
            if (data instanceof RandomAccessFile) {
                bytesRead = ((RandomAccessFile)data).read(buf, 0, (int)bytesToRead);
            } else if (data instanceof BufferedInputStream) {
                bytesRead = ((BufferedInputStream)data).read(buf, 0, (int)bytesToRead);
            }
            if (bytesRead < 0) {
                throw new IOException("EOF on reading data");
            }
            buffer.write(buf, 0, bytesRead);
        }
    }

    public void setTimeout(long connectTimeout, long writeTimeout, long readTimeout) {
        this.httpClient = this.httpClient.newBuilder().connectTimeout(connectTimeout, TimeUnit.MILLISECONDS).writeTimeout(writeTimeout, TimeUnit.MILLISECONDS).readTimeout(readTimeout, TimeUnit.MILLISECONDS).build();
    }

    public void ignoreCertCheck() throws KeyManagementException, NoSuchAlgorithmException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, trustAllCerts, new SecureRandom());
        SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
        this.httpClient = this.httpClient.newBuilder().sslSocketFactory(sslSocketFactory, (X509TrustManager)trustAllCerts[0]).hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        }).build();
    }

    public void setAppInfo(String name, String version) {
        if (name == null || version == null) {
            return;
        }
        this.userAgent = DEFAULT_USER_AGENT + " " + name.trim() + "/" + version.trim();
    }

    public void traceOn(OutputStream traceStream) {
        if (traceStream == null) {
            throw new NullPointerException();
        }
        this.traceStream = new PrintWriter((Writer)new OutputStreamWriter(traceStream, StandardCharsets.UTF_8), true);
    }

    public void traceOff() throws IOException {
        this.traceStream = null;
    }

    public void enableAccelerateEndpoint() {
        this.isAcceleratedHost = true;
    }

    public void disableAccelerateEndpoint() {
        this.isAcceleratedHost = false;
    }

    public void enableDualStackEndpoint() {
        this.isDualStackHost = true;
    }

    public void disableDualStackEndpoint() {
        this.isDualStackHost = false;
    }

    public void enableVirtualStyleEndpoint() {
        this.useVirtualStyle = true;
    }

    public void disableVirtualStyleEndpoint() {
        this.useVirtualStyle = false;
    }

    protected AbortMultipartUploadResponse abortMultipartUpload(String bucketName, String region, String objectName, String uploadId, Multimap<String, String> extraHeaders, Multimap<String, String> extraQueryParams) throws NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, ServerException, XmlParserException, ErrorResponseException, InternalException, InvalidResponseException {
        try (Response response = this.execute(Method.DELETE, bucketName, objectName, this.getRegion(bucketName, region), this.httpHeaders(extraHeaders), this.merge(extraQueryParams, this.newMultimap(UPLOAD_ID, uploadId)), null, 0);){
            AbortMultipartUploadResponse abortMultipartUploadResponse = new AbortMultipartUploadResponse(response.headers(), bucketName, region, objectName, uploadId);
            return abortMultipartUploadResponse;
        }
    }

    /*
     * Exception decompiling
     */
    public ObjectWriteResponse completeMultipartUpload(String bucketName, String region, String objectName, String uploadId, Part[] parts, Multimap<String, String> extraHeaders, Multimap<String, String> extraQueryParams) throws NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, ServerException, XmlParserException, ErrorResponseException, InternalException, InvalidResponseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public CreateMultipartUploadResponse createMultipartUpload(String bucketName, String region, String objectName, Multimap<String, String> headers, Multimap<String, String> extraQueryParams) throws NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, ServerException, XmlParserException, ErrorResponseException, InternalException, InvalidResponseException {
        Multimap<String, String> queryParams = this.newMultimap(extraQueryParams);
        queryParams.put((Object)"uploads", (Object)"");
        Multimap<String, String> headersCopy = this.newMultimap(headers);
        if (!headersCopy.containsKey((Object)"Content-Type")) {
            headersCopy.put((Object)"Content-Type", (Object)"application/octet-stream");
        }
        try (Response response = this.execute(Method.POST, bucketName, objectName, this.getRegion(bucketName, region), this.httpHeaders(headersCopy), queryParams, null, 0);){
            InitiateMultipartUploadResult result = (InitiateMultipartUploadResult)Xml.unmarshal(InitiateMultipartUploadResult.class, (Reader)response.body().charStream());
            CreateMultipartUploadResponse createMultipartUploadResponse = new CreateMultipartUploadResponse(response.headers(), bucketName, region, objectName, result);
            return createMultipartUploadResponse;
        }
    }

    protected DeleteObjectsResponse deleteObjects(String bucketName, String region, List<DeleteObject> objectList, boolean quiet, boolean bypassGovernanceMode, Multimap<String, String> extraHeaders, Multimap<String, String> extraQueryParams) throws NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, ServerException, XmlParserException, ErrorResponseException, InternalException, InvalidResponseException {
        if (objectList == null) {
            objectList = new LinkedList<DeleteObject>();
        }
        if (objectList.size() > 1000) {
            throw new IllegalArgumentException("list of objects must not be more than 1000");
        }
        Multimap<String, String> headers = this.merge(extraHeaders, bypassGovernanceMode ? this.newMultimap("x-amz-bypass-governance-retention", "true") : null);
        try (Response response = this.execute(Method.POST, bucketName, null, this.getRegion(bucketName, region), this.httpHeaders(headers), this.merge(extraQueryParams, this.newMultimap("delete", "")), new DeleteRequest(objectList, quiet), 0);){
            String bodyContent = response.body().string();
            try {
                if (Xml.validate(DeleteError.class, (String)bodyContent)) {
                    DeleteError error = (DeleteError)Xml.unmarshal(DeleteError.class, (String)bodyContent);
                    DeleteResult result = new DeleteResult(error);
                    DeleteObjectsResponse deleteObjectsResponse = new DeleteObjectsResponse(response.headers(), bucketName, region, result);
                    return deleteObjectsResponse;
                }
            }
            catch (XmlParserException error) {
                // empty catch block
            }
            DeleteResult result = (DeleteResult)Xml.unmarshal(DeleteResult.class, (String)bodyContent);
            DeleteObjectsResponse deleteObjectsResponse = new DeleteObjectsResponse(response.headers(), bucketName, region, result);
            return deleteObjectsResponse;
        }
    }

    private Multimap<String, String> getCommonListObjectsQueryParams(String delimiter, String encodingType, Integer maxKeys, String prefix) {
        Multimap<String, String> queryParams = this.newMultimap("delimiter", delimiter == null ? "" : delimiter, "max-keys", Integer.toString(maxKeys > 0 ? maxKeys : 1000), "prefix", prefix == null ? "" : prefix);
        if (encodingType != null) {
            queryParams.put((Object)"encoding-type", (Object)encodingType);
        }
        return queryParams;
    }

    protected ListObjectsV2Response listObjectsV2(String bucketName, String region, String delimiter, String encodingType, String startAfter, Integer maxKeys, String prefix, String continuationToken, boolean fetchOwner, boolean includeUserMetadata, Multimap<String, String> extraHeaders, Multimap<String, String> extraQueryParams) throws InvalidKeyException, NoSuchAlgorithmException, InsufficientDataException, ServerException, XmlParserException, ErrorResponseException, InternalException, InvalidResponseException, IOException {
        Multimap<String, String> queryParams = this.merge(extraQueryParams, this.getCommonListObjectsQueryParams(delimiter, encodingType, maxKeys, prefix));
        queryParams.put((Object)"list-type", (Object)"2");
        if (continuationToken != null) {
            queryParams.put((Object)"continuation-token", (Object)continuationToken);
        }
        if (fetchOwner) {
            queryParams.put((Object)"fetch-owner", (Object)"true");
        }
        if (startAfter != null) {
            queryParams.put((Object)"start-after", (Object)startAfter);
        }
        if (includeUserMetadata) {
            queryParams.put((Object)"metadata", (Object)"true");
        }
        try (Response response = this.execute(Method.GET, bucketName, null, this.getRegion(bucketName, region), this.httpHeaders(extraHeaders), queryParams, null, 0);){
            ListBucketResultV2 result = (ListBucketResultV2)Xml.unmarshal(ListBucketResultV2.class, (Reader)response.body().charStream());
            ListObjectsV2Response listObjectsV2Response = new ListObjectsV2Response(response.headers(), bucketName, region, result);
            return listObjectsV2Response;
        }
    }

    protected ListObjectsV1Response listObjectsV1(String bucketName, String region, String delimiter, String encodingType, String marker, Integer maxKeys, String prefix, Multimap<String, String> extraHeaders, Multimap<String, String> extraQueryParams) throws NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, ServerException, XmlParserException, ErrorResponseException, InternalException, InvalidResponseException {
        Multimap<String, String> queryParams = this.merge(extraQueryParams, this.getCommonListObjectsQueryParams(delimiter, encodingType, maxKeys, prefix));
        if (marker != null) {
            queryParams.put((Object)"marker", (Object)marker);
        }
        try (Response response = this.execute(Method.GET, bucketName, null, this.getRegion(bucketName, region), this.httpHeaders(extraHeaders), queryParams, null, 0);){
            ListBucketResultV1 result = (ListBucketResultV1)Xml.unmarshal(ListBucketResultV1.class, (Reader)response.body().charStream());
            ListObjectsV1Response listObjectsV1Response = new ListObjectsV1Response(response.headers(), bucketName, region, result);
            return listObjectsV1Response;
        }
    }

    protected ListObjectVersionsResponse listObjectVersions(String bucketName, String region, String delimiter, String encodingType, String keyMarker, Integer maxKeys, String prefix, String versionIdMarker, Multimap<String, String> extraHeaders, Multimap<String, String> extraQueryParams) throws NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, ServerException, XmlParserException, ErrorResponseException, InternalException, InvalidResponseException {
        Multimap<String, String> queryParams = this.merge(extraQueryParams, this.getCommonListObjectsQueryParams(delimiter, encodingType, maxKeys, prefix));
        if (keyMarker != null) {
            queryParams.put((Object)"key-marker", (Object)keyMarker);
        }
        if (versionIdMarker != null) {
            queryParams.put((Object)"version-id-marker", (Object)versionIdMarker);
        }
        queryParams.put((Object)"versions", (Object)"");
        try (Response response = this.execute(Method.GET, bucketName, null, this.getRegion(bucketName, region), this.httpHeaders(extraHeaders), queryParams, null, 0);){
            ListVersionsResult result = (ListVersionsResult)Xml.unmarshal(ListVersionsResult.class, (Reader)response.body().charStream());
            ListObjectVersionsResponse listObjectVersionsResponse = new ListObjectVersionsResponse(response.headers(), bucketName, region, result);
            return listObjectVersionsResponse;
        }
    }

    protected ObjectWriteResponse putObject(String bucketName, String region, String objectName, Object data, int length, Multimap<String, String> headers, Multimap<String, String> extraQueryParams) throws NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, ServerException, XmlParserException, ErrorResponseException, InternalException, InvalidResponseException {
        if (!(data instanceof BufferedInputStream || data instanceof RandomAccessFile || data instanceof byte[] || data instanceof CharSequence)) {
            throw new IllegalArgumentException("data must be BufferedInputStream, RandomAccessFile, byte[] or String");
        }
        try (Response response = this.execute(Method.PUT, bucketName, objectName, this.getRegion(bucketName, region), this.httpHeaders(headers), extraQueryParams, data, length);){
            ObjectWriteResponse objectWriteResponse = new ObjectWriteResponse(response.headers(), bucketName, region, objectName, response.header("ETag").replaceAll("\"", ""), response.header("x-amz-version-id"));
            return objectWriteResponse;
        }
    }

    protected ListMultipartUploadsResponse listMultipartUploads(String bucketName, String region, String delimiter, String encodingType, String keyMarker, Integer maxUploads, String prefix, String uploadIdMarker, Multimap<String, String> extraHeaders, Multimap<String, String> extraQueryParams) throws NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, ServerException, XmlParserException, ErrorResponseException, InternalException, InvalidResponseException {
        Multimap<String, String> queryParams = this.merge(extraQueryParams, this.newMultimap("uploads", "", "delimiter", delimiter != null ? delimiter : "", "max-uploads", maxUploads != null ? maxUploads.toString() : "1000", "prefix", prefix != null ? prefix : "", "encoding-type", "url"));
        if (encodingType != null) {
            queryParams.put((Object)"encoding-type", (Object)encodingType);
        }
        if (keyMarker != null) {
            queryParams.put((Object)"key-marker", (Object)keyMarker);
        }
        if (uploadIdMarker != null) {
            queryParams.put((Object)"upload-id-marker", (Object)uploadIdMarker);
        }
        try (Response response = this.execute(Method.GET, bucketName, null, this.getRegion(bucketName, region), this.httpHeaders(extraHeaders), queryParams, null, 0);){
            ListMultipartUploadsResult result = (ListMultipartUploadsResult)Xml.unmarshal(ListMultipartUploadsResult.class, (Reader)response.body().charStream());
            ListMultipartUploadsResponse listMultipartUploadsResponse = new ListMultipartUploadsResponse(response.headers(), bucketName, region, result);
            return listMultipartUploadsResponse;
        }
    }

    protected ListPartsResponse listParts(String bucketName, String region, String objectName, Integer maxParts, Integer partNumberMarker, String uploadId, Multimap<String, String> extraHeaders, Multimap<String, String> extraQueryParams) throws NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, ServerException, XmlParserException, ErrorResponseException, InternalException, InvalidResponseException {
        Multimap<String, String> queryParams = this.merge(extraQueryParams, this.newMultimap(UPLOAD_ID, uploadId, "max-parts", maxParts != null ? maxParts.toString() : "1000"));
        if (partNumberMarker != null) {
            queryParams.put((Object)"part-number-marker", (Object)partNumberMarker.toString());
        }
        try (Response response = this.execute(Method.GET, bucketName, objectName, this.getRegion(bucketName, region), this.httpHeaders(extraHeaders), queryParams, null, 0);){
            ListPartsResult result = (ListPartsResult)Xml.unmarshal(ListPartsResult.class, (Reader)response.body().charStream());
            ListPartsResponse listPartsResponse = new ListPartsResponse(response.headers(), bucketName, region, objectName, result);
            return listPartsResponse;
        }
    }

    public UploadPartResponse uploadPart(String bucketName, String region, String objectName, Object data, int length, String uploadId, int partNumber, Multimap<String, String> extraHeaders, Multimap<String, String> extraQueryParams) throws NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, ServerException, XmlParserException, ErrorResponseException, InternalException, InvalidResponseException {
        if (!(data instanceof BufferedInputStream || data instanceof RandomAccessFile || data instanceof byte[] || data instanceof CharSequence)) {
            throw new IllegalArgumentException("data must be BufferedInputStream, RandomAccessFile, byte[] or String");
        }
        try (Response response = this.execute(Method.PUT, bucketName, objectName, this.getRegion(bucketName, region), this.httpHeaders(extraHeaders), this.merge(extraQueryParams, this.newMultimap("partNumber", Integer.toString(partNumber), UPLOAD_ID, uploadId)), data, length);){
            UploadPartResponse uploadPartResponse = new UploadPartResponse(response.headers(), bucketName, region, objectName, uploadId, partNumber, response.header("ETag").replaceAll("\"", ""));
            return uploadPartResponse;
        }
    }

    protected UploadPartCopyResponse uploadPartCopy(String bucketName, String region, String objectName, String uploadId, int partNumber, Multimap<String, String> headers, Multimap<String, String> extraQueryParams) throws NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, ServerException, XmlParserException, ErrorResponseException, InternalException, InvalidResponseException {
        try (Response response = this.execute(Method.PUT, bucketName, objectName, this.getRegion(bucketName, region), this.httpHeaders(headers), this.merge(extraQueryParams, this.newMultimap("partNumber", Integer.toString(partNumber), UPLOAD_ID, uploadId)), null, 0);){
            CopyPartResult result = (CopyPartResult)Xml.unmarshal(CopyPartResult.class, (Reader)response.body().charStream());
            UploadPartCopyResponse uploadPartCopyResponse = new UploadPartCopyResponse(response.headers(), bucketName, region, objectName, uploadId, partNumber, result);
            return uploadPartCopyResponse;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    private static class NotificationResultRecords {
        Response response = null;
        Scanner scanner = null;
        ObjectMapper mapper = null;

        public NotificationResultRecords(Response response) {
            this.response = response;
            this.scanner = new Scanner(response.body().charStream()).useDelimiter("\n");
            this.mapper = new ObjectMapper();
            this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.mapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
        }

        public CloseableIterator<Result<NotificationRecords>> closeableIterator() {
            return new CloseableIterator<Result<NotificationRecords>>(){
                String recordsString = null;
                NotificationRecords records = null;
                boolean isClosed = false;

                public void close() throws IOException {
                    if (!this.isClosed) {
                        try {
                            response.body().close();
                            scanner.close();
                        }
                        finally {
                            this.isClosed = true;
                        }
                    }
                }

                public boolean populate() {
                    if (this.isClosed) {
                        return false;
                    }
                    if (this.recordsString != null) {
                        return true;
                    }
                    while (scanner.hasNext()) {
                        this.recordsString = scanner.next().trim();
                        if (this.recordsString.equals("")) continue;
                    }
                    if (this.recordsString == null || this.recordsString.equals("")) {
                        try {
                            this.close();
                        }
                        catch (IOException e) {
                            this.isClosed = true;
                        }
                        return false;
                    }
                    return true;
                }

                public boolean hasNext() {
                    return this.populate();
                }

                public Result<NotificationRecords> next() {
                    if (this.isClosed) {
                        throw new NoSuchElementException();
                    }
                    if ((this.recordsString == null || this.recordsString.equals("")) && !this.populate()) {
                        throw new NoSuchElementException();
                    }
                    try {
                        this.records = (NotificationRecords)mapper.readValue(this.recordsString, NotificationRecords.class);
                        Result result = new Result((Object)this.records);
                        return result;
                    }
                    catch (JsonMappingException e) {
                        Result result = new Result((Exception)((Object)e));
                        return result;
                    }
                    catch (JsonParseException e) {
                        Result result = new Result((Exception)((Object)e));
                        return result;
                    }
                    catch (IOException e) {
                        Result result = new Result((Exception)e);
                        return result;
                    }
                    finally {
                        this.recordsString = null;
                        this.records = null;
                    }
                }
            };
        }
    }

    public static final class Builder {
        HttpUrl baseUrl;
        String region;
        OkHttpClient httpClient;
        boolean isAwsHost;
        boolean isAwsChinaHost;
        boolean isAcceleratedHost;
        boolean isDualStackHost;
        boolean useVirtualStyle;
        String regionInUrl;
        Provider provider;

        private boolean isAwsEndpoint(String endpoint) {
            return !(!endpoint.startsWith("s3.") && !this.isAwsAccelerateEndpoint(endpoint) || !endpoint.endsWith(".amazonaws.com") && !endpoint.endsWith(".amazonaws.com.cn"));
        }

        private boolean isAwsAccelerateEndpoint(String endpoint) {
            return endpoint.startsWith("s3-accelerate.");
        }

        private boolean isAwsDualStackEndpoint(String endpoint) {
            return endpoint.contains(".dualstack.");
        }

        private String extractRegion(String endpoint) {
            String[] tokens = endpoint.split("\\.");
            String token = tokens[1];
            if (token.equals("dualstack")) {
                token = tokens[2];
            }
            if (token.equals("amazonaws")) {
                return null;
            }
            return token;
        }

        private void setBaseUrl(HttpUrl url) {
            String host = url.host();
            this.isAwsHost = this.isAwsEndpoint(host);
            this.isAwsChinaHost = false;
            if (this.isAwsHost) {
                this.isAwsChinaHost = host.endsWith(".cn");
                url = url.newBuilder().host(this.isAwsChinaHost ? "amazonaws.com.cn" : "amazonaws.com").build();
                this.isAcceleratedHost = this.isAwsAccelerateEndpoint(host);
                this.isDualStackHost = this.isAwsDualStackEndpoint(host);
                this.regionInUrl = this.extractRegion(host);
                this.useVirtualStyle = true;
            } else {
                this.useVirtualStyle = host.endsWith("aliyuncs.com");
            }
            this.baseUrl = url;
        }

        private OkHttpClient enableExternalCertificates(OkHttpClient httpClient, String filename) throws GeneralSecurityException, IOException {
            Collection<? extends Certificate> certificates = null;
            try (FileInputStream fis = new FileInputStream(filename);){
                certificates = CertificateFactory.getInstance("X.509").generateCertificates(fis);
            }
            if (certificates == null || certificates.isEmpty()) {
                throw new IllegalArgumentException("expected non-empty set of trusted certificates");
            }
            char[] password = "password".toCharArray();
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, password);
            int index = 0;
            for (Certificate certificate : certificates) {
                String certificateAlias = Integer.toString(index++);
                keyStore.setCertificateEntry(certificateAlias, certificate);
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, password);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, trustManagers, null);
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            return httpClient.newBuilder().sslSocketFactory(sslSocketFactory, (X509TrustManager)trustManagers[0]).build();
        }

        protected void validateNotNull(Object arg, String argName) {
            if (arg == null) {
                throw new IllegalArgumentException(argName + " must not be null.");
            }
        }

        protected void validateNotEmptyString(String arg, String argName) {
            this.validateNotNull(arg, argName);
            if (arg.isEmpty()) {
                throw new IllegalArgumentException(argName + " must be a non-empty string.");
            }
        }

        protected void validateNullOrNotEmptyString(String arg, String argName) {
            if (arg != null && arg.isEmpty()) {
                throw new IllegalArgumentException(argName + " must be a non-empty string.");
            }
        }

        private void validateUrl(HttpUrl url) {
            if (!url.encodedPath().equals("/")) {
                throw new IllegalArgumentException("no path allowed in endpoint " + url);
            }
        }

        private void validateHostnameOrIPAddress(String endpoint) {
            if (InetAddressValidator.getInstance().isValid(endpoint)) {
                return;
            }
            if (endpoint.length() < 1 || endpoint.length() > 253) {
                throw new IllegalArgumentException("invalid hostname");
            }
            for (String label : endpoint.split("\\.")) {
                if (label.length() < 1 || label.length() > 63) {
                    throw new IllegalArgumentException("invalid hostname");
                }
                if (label.matches("^[a-zA-Z0-9]([a-zA-Z0-9-]*[a-zA-Z0-9])?$")) continue;
                throw new IllegalArgumentException("invalid hostname");
            }
        }

        private HttpUrl getBaseUrl(String endpoint) {
            this.validateNotEmptyString(endpoint, "endpoint");
            HttpUrl url = HttpUrl.parse((String)endpoint);
            if (url == null) {
                this.validateHostnameOrIPAddress(endpoint);
                url = new HttpUrl.Builder().scheme("https").host(endpoint).build();
            } else {
                this.validateUrl(url);
            }
            return url;
        }

        public Builder endpoint(String endpoint) {
            this.setBaseUrl(this.getBaseUrl(endpoint));
            return this;
        }

        public Builder endpoint(String endpoint, int port, boolean secure) {
            HttpUrl url = this.getBaseUrl(endpoint);
            if (port < 1 || port > 65535) {
                throw new IllegalArgumentException("port must be in range of 1 to 65535");
            }
            url = url.newBuilder().port(port).scheme(secure ? "https" : "http").build();
            this.setBaseUrl(url);
            return this;
        }

        public Builder endpoint(URL url) {
            this.validateNotNull(url, "url");
            return this.endpoint(HttpUrl.get((URL)url));
        }

        public Builder endpoint(HttpUrl url) {
            this.validateNotNull(url, "url");
            this.validateUrl(url);
            this.setBaseUrl(url);
            return this;
        }

        public Builder region(String region) {
            this.validateNullOrNotEmptyString(region, "region");
            this.region = region;
            this.regionInUrl = region;
            return this;
        }

        public Builder credentials(String accessKey, String secretKey) {
            this.provider = new StaticProvider(accessKey, secretKey, null);
            return this;
        }

        public Builder credentialsProvider(Provider provider) {
            this.provider = provider;
            return this;
        }

        public Builder httpClient(OkHttpClient httpClient) {
            this.validateNotNull(httpClient, "http client");
            this.httpClient = httpClient;
            return this;
        }

        public MinioClient build() {
            this.validateNotNull(this.baseUrl, "endpoint");
            if (this.isAwsChinaHost && this.regionInUrl == null && this.region == null) {
                throw new IllegalArgumentException("Region missing in Amazon S3 China endpoint " + this.baseUrl);
            }
            if (this.httpClient == null) {
                this.httpClient = new OkHttpClient().newBuilder().connectTimeout(5L, TimeUnit.MINUTES).writeTimeout(5L, TimeUnit.MINUTES).readTimeout(5L, TimeUnit.MINUTES).protocols(Arrays.asList(Protocol.HTTP_1_1)).build();
                String filename = System.getenv("SSL_CERT_FILE");
                if (filename != null && !filename.isEmpty()) {
                    try {
                        this.httpClient = this.enableExternalCertificates(this.httpClient, filename);
                    }
                    catch (IOException | GeneralSecurityException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            return new MinioClient(this.baseUrl, this.region != null ? this.region : this.regionInUrl, this.isAwsHost, this.isAcceleratedHost, this.isDualStackHost, this.useVirtualStyle, this.provider, this.httpClient);
        }
    }

    private abstract class ObjectIterator
    implements Iterator<Result<Item>> {
        protected Result<Item> error;
        protected Iterator<? extends Item> itemIterator;
        protected Iterator<DeleteMarker> deleteMarkerIterator;
        protected Iterator<Prefix> prefixIterator;
        protected boolean completed = false;
        protected ListObjectsResult listObjectsResult;
        protected String lastObjectName;

        private ObjectIterator() {
        }

        protected abstract void populateResult() throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException;

        protected synchronized void populate() {
            try {
                this.populateResult();
            }
            catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
                this.error = new Result((Exception)e);
            }
            if (this.listObjectsResult != null) {
                this.itemIterator = this.listObjectsResult.contents().iterator();
                this.deleteMarkerIterator = this.listObjectsResult.deleteMarkers().iterator();
                this.prefixIterator = this.listObjectsResult.commonPrefixes().iterator();
            } else {
                this.itemIterator = new LinkedList().iterator();
                this.deleteMarkerIterator = new LinkedList().iterator();
                this.prefixIterator = new LinkedList().iterator();
            }
        }

        @Override
        public boolean hasNext() {
            if (this.completed) {
                return false;
            }
            if (this.error == null && this.itemIterator == null && this.deleteMarkerIterator == null && this.prefixIterator == null) {
                this.populate();
            }
            if (this.error == null && !this.itemIterator.hasNext() && !this.deleteMarkerIterator.hasNext() && !this.prefixIterator.hasNext() && this.listObjectsResult.isTruncated()) {
                this.populate();
            }
            if (this.error != null) {
                return true;
            }
            if (this.itemIterator.hasNext()) {
                return true;
            }
            if (this.deleteMarkerIterator.hasNext()) {
                return true;
            }
            if (this.prefixIterator.hasNext()) {
                return true;
            }
            this.completed = true;
            return false;
        }

        @Override
        public Result<Item> next() {
            if (this.completed) {
                throw new NoSuchElementException();
            }
            if (this.error == null && this.itemIterator == null && this.deleteMarkerIterator == null && this.prefixIterator == null) {
                this.populate();
            }
            if (this.error == null && !this.itemIterator.hasNext() && !this.deleteMarkerIterator.hasNext() && !this.prefixIterator.hasNext() && this.listObjectsResult.isTruncated()) {
                this.populate();
            }
            if (this.error != null) {
                this.completed = true;
                return this.error;
            }
            Item item = null;
            if (this.itemIterator.hasNext()) {
                item = this.itemIterator.next();
                item.setEncodingType(this.listObjectsResult.encodingType());
                this.lastObjectName = item.objectName();
            } else if (this.deleteMarkerIterator.hasNext()) {
                item = (Item)this.deleteMarkerIterator.next();
            } else if (this.prefixIterator.hasNext()) {
                item = this.prefixIterator.next().toItem();
            }
            if (item != null) {
                item.setEncodingType(this.listObjectsResult.encodingType());
                return new Result((Object)item);
            }
            this.completed = true;
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

