/*
 * Decompiled with CFR 0.152.
 */
package org.macrocloud.kernel.oss;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.ServiceException;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.model.MatchMode;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PolicyConditions;
import com.aliyun.oss.model.PutObjectResult;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.macrocloud.kernel.oss.OssTemplate;
import org.macrocloud.kernel.oss.enums.OssEnum;
import org.macrocloud.kernel.oss.model.BamuPartETag;
import org.macrocloud.kernel.oss.model.BaseFile;
import org.macrocloud.kernel.oss.model.OssFile;
import org.macrocloud.kernel.oss.props.OssProperties;
import org.macrocloud.kernel.oss.rule.OssRule;
import org.macrocloud.kernel.tool.jackson.JsonUtil;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class AliossTemplate
implements OssTemplate {
    private final OSSClient ossClient;
    private final OssProperties ossProperties;
    private final OssRule ossRule;

    @Override
    public void makeBucket(String bucketName) {
        if (!this.bucketExists(bucketName)) {
            this.ossClient.createBucket(this.getBucketName(bucketName));
        }
    }

    @Override
    public void removeBucket(String bucketName) {
        this.ossClient.deleteBucket(this.getBucketName(bucketName));
    }

    @Override
    public boolean bucketExists(String bucketName) {
        return this.ossClient.doesBucketExist(this.getBucketName(bucketName));
    }

    @Override
    public void copyFile(String bucketName, String fileName, String destBucketName) {
        this.ossClient.copyObject(this.getBucketName(bucketName), fileName, this.getBucketName(destBucketName), fileName);
    }

    @Override
    public void copyFile(String bucketName, String fileName, String destBucketName, String destFileName) {
        this.ossClient.copyObject(this.getBucketName(bucketName), fileName, this.getBucketName(destBucketName), destFileName);
    }

    @Override
    public OssFile statFile(String fileName) {
        return this.statFile(this.ossProperties.getBucketName(), fileName);
    }

    @Override
    public OssFile statFile(String bucketName, String fileName) {
        ObjectMetadata stat = this.ossClient.getObjectMetadata(this.getBucketName(bucketName), fileName);
        OssFile ossFile = new OssFile();
        ossFile.setName(fileName);
        ossFile.setLink(this.fileLink(ossFile.getName()));
        ossFile.setHash(stat.getContentMD5());
        ossFile.setLength(stat.getContentLength());
        ossFile.setPutTime(stat.getLastModified());
        ossFile.setContentType(stat.getContentType());
        return ossFile;
    }

    @Override
    public String filePath(String fileName) {
        return this.getOssHost().concat("/").concat(fileName);
    }

    @Override
    public String filePath(String bucketName, String fileName) {
        return this.getOssHost(bucketName).concat("/").concat(fileName);
    }

    @Override
    public String fileLink(String fileName) {
        return this.getOssHost().concat("/").concat(fileName);
    }

    @Override
    public String fileLink(String bucketName, String fileName) {
        return this.getOssHost(bucketName).concat("/").concat(fileName);
    }

    @Override
    public BaseFile putFile(MultipartFile file) {
        return this.putFile(this.ossProperties.getBucketName(), file.getOriginalFilename(), file);
    }

    @Override
    public BaseFile putFile(String fileName, MultipartFile file) {
        return this.putFile(this.ossProperties.getBucketName(), fileName, file);
    }

    @Override
    public BaseFile putFile(String bucketName, String fileName, MultipartFile file) {
        return this.putFile(bucketName, fileName, file.getInputStream());
    }

    @Override
    public BaseFile putFile(String fileName, InputStream stream) {
        return this.putFile(this.ossProperties.getBucketName(), fileName, stream);
    }

    @Override
    public BaseFile putFile(String bucketName, String fileName, InputStream stream) {
        return this.put(bucketName, stream, fileName, false);
    }

    public BaseFile put(String bucketName, InputStream stream, String key, boolean cover) {
        this.makeBucket(bucketName);
        String originalName = key;
        key = this.getFileName(key);
        if (cover) {
            this.ossClient.putObject(this.getBucketName(bucketName), key, stream);
        } else {
            PutObjectResult response = this.ossClient.putObject(this.getBucketName(bucketName), key, stream);
            int retryCount = 5;
            for (int retry = 0; StringUtils.isEmpty((Object)response.getETag()) && retry < retryCount; ++retry) {
                response = this.ossClient.putObject(this.getBucketName(bucketName), key, stream);
            }
        }
        BaseFile file = new BaseFile();
        file.setOriginalName(originalName);
        file.setName(key);
        file.setDomain(this.getOssHost(bucketName));
        file.setLink(this.fileLink(bucketName, key));
        file.setSource(OssEnum.ALI.getName());
        file.setBucketName(this.getBucketName(bucketName));
        file.setOuterDomain(this.getOssOuterHost(bucketName));
        return file;
    }

    @Override
    public void removeFile(String fileName) {
        this.ossClient.deleteObject(this.getBucketName(), fileName);
    }

    @Override
    public void removeFile(String bucketName, String fileName) {
        this.ossClient.deleteObject(this.getBucketName(bucketName), fileName);
    }

    @Override
    public void removeFiles(List<String> fileNames) {
        fileNames.forEach(this::removeFile);
    }

    @Override
    public void removeFiles(String bucketName, List<String> fileNames) {
        fileNames.forEach(fileName -> this.removeFile(this.getBucketName(bucketName), (String)fileName));
    }

    private String getOssOuterHost(String bucketName) {
        String prefix = this.ossProperties.getEndpoint().contains("https://") ? "https://" : "http://";
        return prefix + this.getBucketName(bucketName) + "." + this.ossProperties.getEndpoint().replaceFirst(prefix, "");
    }

    private String getBucketName() {
        return this.getBucketName(this.ossProperties.getBucketName());
    }

    private String getBucketName(String bucketName) {
        return this.ossRule.bucketName(bucketName);
    }

    private String getFileName(String originalFilename) {
        return this.ossRule.fileName(originalFilename);
    }

    public String getUploadToken() {
        return this.getUploadToken(this.ossProperties.getBucketName());
    }

    public String getUploadToken(String bucketName) {
        return this.getUploadToken(bucketName, (Long)this.ossProperties.getArgs().get("expireTime", (Object)3600L));
    }

    public String getUploadToken(String bucketName, long expireTime) {
        String baseDir = "upload";
        long expireEndTime = System.currentTimeMillis() + expireTime * 1000L;
        Date expiration = new Date(expireEndTime);
        PolicyConditions policyConds = new PolicyConditions();
        policyConds.addConditionItem("content-length-range", 0L, (long)((Integer)this.ossProperties.getArgs().get("contentLengthRange", (Object)0xA00000)).intValue());
        policyConds.addConditionItem(MatchMode.StartWith, "key", baseDir);
        String postPolicy = this.ossClient.generatePostPolicy(expiration, policyConds);
        byte[] binaryData = postPolicy.getBytes(StandardCharsets.UTF_8);
        String encodedPolicy = BinaryUtil.toBase64String((byte[])binaryData);
        String postSignature = this.ossClient.calculatePostSignature(postPolicy);
        LinkedHashMap<String, String> respMap = new LinkedHashMap<String, String>(16);
        respMap.put("accessid", this.ossProperties.getAccessKey());
        respMap.put("policy", encodedPolicy);
        respMap.put("signature", postSignature);
        respMap.put("dir", baseDir);
        respMap.put("host", this.getOssHost(bucketName));
        respMap.put("expire", String.valueOf(expireEndTime / 1000L));
        return JsonUtil.toJson(respMap);
    }

    public String getOssHost(String bucketName) {
        String prefix = this.ossProperties.getEndpoint().contains("https://") ? "https://" : "http://";
        return prefix + this.getBucketName(bucketName) + "." + this.ossProperties.getEndpoint().replaceFirst(prefix, "");
    }

    public String getOssHost() {
        return this.getOssHost(this.ossProperties.getBucketName());
    }

    @Override
    public byte[] statFileByte(String bucketName, String fileName) {
        OSSObject object = null;
        try {
            object = this.ossClient.getObject(bucketName, fileName);
        }
        catch (ClientException | OSSException e) {
            throw new ServiceException("\u963f\u91cc\u4e91\u4e0a\u627e\u4e0d\u5230\u8be5\u6587\u4ef6\uff01\u6587\u4ef6\u540d\uff1a" + fileName);
        }
        InputStream objectContent = null;
        try {
            objectContent = object.getObjectContent();
            byte[] byArray = IoUtil.readBytes((InputStream)objectContent);
            return byArray;
        }
        catch (IORuntimeException e) {
            throw new ServiceException("\u6d41\u8bfb\u53d6\u9519\u8bef");
        }
        finally {
            IoUtil.close((Closeable)objectContent);
        }
    }

    @Override
    public String initMultipartUpload(String fileName) {
        return null;
    }

    @Override
    public String initMultipartUpload(String bucketName, String fileName) {
        return null;
    }

    @Override
    public BamuPartETag putFile(String fileName, InputStream stream, String uploadId, int partNumber, long partSize) {
        return null;
    }

    @Override
    public BamuPartETag putFile(String bucketName, String fileName, InputStream stream, String uploadId, int partNumber, long partSize) {
        return null;
    }

    @Override
    public BaseFile completeMultipart(String fileName, String uploadId, Object partETags) {
        return null;
    }

    @Override
    public BaseFile completeMultipart(String bucketName, String fileName, String uploadId, Object partETags) {
        return null;
    }

    public AliossTemplate(OSSClient ossClient, OssProperties ossProperties, OssRule ossRule) {
        this.ossClient = ossClient;
        this.ossProperties = ossProperties;
        this.ossRule = ossRule;
    }
}

