/*
 * Decompiled with CFR 0.152.
 */
package org.macrocloud.kernel.oss;

import com.obs.services.ObsClient;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.PutObjectResult;
import java.io.InputStream;
import java.util.List;
import org.macrocloud.kernel.oss.OssTemplate;
import org.macrocloud.kernel.oss.enums.OssEnum;
import org.macrocloud.kernel.oss.model.BamuPartETag;
import org.macrocloud.kernel.oss.model.BaseFile;
import org.macrocloud.kernel.oss.model.OssFile;
import org.macrocloud.kernel.oss.props.OssProperties;
import org.macrocloud.kernel.oss.rule.OssRule;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class HuaweiObsTemplate
implements OssTemplate {
    private final ObsClient obsClient;
    private final OssProperties ossProperties;
    private final OssRule ossRule;

    @Override
    public void makeBucket(String bucketName) {
        if (!this.bucketExists(bucketName)) {
            this.obsClient.createBucket(this.getBucketName(bucketName));
        }
    }

    @Override
    public void removeBucket(String bucketName) {
        this.obsClient.deleteBucket(this.getBucketName(bucketName));
    }

    @Override
    public boolean bucketExists(String bucketName) {
        return this.obsClient.headBucket(this.getBucketName(bucketName));
    }

    @Override
    public void copyFile(String bucketName, String fileName, String destBucketName) {
        this.obsClient.copyObject(this.getBucketName(bucketName), fileName, this.getBucketName(destBucketName), fileName);
    }

    @Override
    public void copyFile(String bucketName, String fileName, String destBucketName, String destFileName) {
        this.obsClient.copyObject(this.getBucketName(bucketName), fileName, this.getBucketName(destBucketName), destFileName);
    }

    @Override
    public OssFile statFile(String fileName) {
        return this.statFile(this.ossProperties.getBucketName(), fileName);
    }

    @Override
    public OssFile statFile(String bucketName, String fileName) {
        ObjectMetadata stat = this.obsClient.getObjectMetadata(this.getBucketName(bucketName), fileName);
        OssFile ossFile = new OssFile();
        ossFile.setName(fileName);
        ossFile.setLink(this.fileLink(ossFile.getName()));
        ossFile.setHash(stat.getContentMd5());
        ossFile.setLength(stat.getContentLength());
        ossFile.setPutTime(stat.getLastModified());
        ossFile.setContentType(stat.getContentType());
        return ossFile;
    }

    @Override
    public String filePath(String fileName) {
        return this.getOssHost(this.getBucketName()).concat("/").concat(fileName);
    }

    @Override
    public String filePath(String bucketName, String fileName) {
        return this.getOssHost(this.getBucketName(bucketName)).concat("/").concat(fileName);
    }

    @Override
    public String fileLink(String fileName) {
        return this.getOssHost().concat("/").concat(fileName);
    }

    @Override
    public String fileLink(String bucketName, String fileName) {
        return this.getOssHost(this.getBucketName(bucketName)).concat("/").concat(fileName);
    }

    @Override
    public BaseFile putFile(MultipartFile file) {
        return this.putFile(this.ossProperties.getBucketName(), file.getOriginalFilename(), file);
    }

    @Override
    public BaseFile putFile(String fileName, MultipartFile file) {
        return this.putFile(this.ossProperties.getBucketName(), fileName, file);
    }

    @Override
    public BaseFile putFile(String bucketName, String fileName, MultipartFile file) {
        return this.putFile(bucketName, fileName, file.getInputStream());
    }

    @Override
    public BaseFile putFile(String fileName, InputStream stream) {
        return this.putFile(this.ossProperties.getBucketName(), fileName, stream);
    }

    @Override
    public BaseFile putFile(String bucketName, String fileName, InputStream stream) {
        return this.put(bucketName, stream, fileName, false);
    }

    @Override
    public void removeFile(String fileName) {
        this.obsClient.deleteObject(this.getBucketName(), fileName);
    }

    @Override
    public void removeFile(String bucketName, String fileName) {
        this.obsClient.deleteObject(this.getBucketName(bucketName), fileName);
    }

    @Override
    public void removeFiles(List<String> fileNames) {
        fileNames.forEach(this::removeFile);
    }

    @Override
    public void removeFiles(String bucketName, List<String> fileNames) {
        fileNames.forEach(fileName -> this.removeFile(this.getBucketName(bucketName), (String)fileName));
    }

    public BaseFile put(String bucketName, InputStream stream, String key, boolean cover) {
        this.makeBucket(bucketName);
        String originalName = key;
        key = this.getFileName(key);
        if (cover) {
            this.obsClient.putObject(this.getBucketName(bucketName), key, stream);
        } else {
            PutObjectResult response = this.obsClient.putObject(this.getBucketName(bucketName), key, stream);
            int retryCount = 5;
            for (int retry = 0; StringUtils.isEmpty((Object)response.getEtag()) && retry < retryCount; ++retry) {
                response = this.obsClient.putObject(this.getBucketName(bucketName), key, stream);
            }
        }
        BaseFile file = new BaseFile();
        file.setOriginalName(originalName);
        file.setName(key);
        file.setDomain(this.getOssHost(bucketName));
        file.setOuterDomain(this.getOssOuterHost(bucketName));
        file.setLink(this.fileLink(bucketName, key));
        file.setSource(OssEnum.HUAWEI.getName());
        file.setBucketName(this.getBucketName(bucketName));
        return file;
    }

    private String getFileName(String originalFilename) {
        return this.ossRule.fileName(originalFilename);
    }

    private String getBucketName() {
        return this.getBucketName(this.ossProperties.getBucketName());
    }

    private String getBucketName(String bucketName) {
        return this.ossRule.bucketName(bucketName);
    }

    public String getOssHost(String bucketName) {
        String prefix = this.ossProperties.getEndpoint().contains("https://") ? "https://" : "http://";
        return prefix + this.getBucketName(bucketName) + "." + this.ossProperties.getEndpoint().replaceFirst(prefix, "");
    }

    public String getOssHost() {
        return this.getOssHost(this.ossProperties.getBucketName());
    }

    private String getOssOuterHost(String bucketName) {
        String prefix = this.ossProperties.getEndpoint().contains("https://") ? "https://" : "http://";
        return prefix + this.getBucketName(bucketName) + "." + this.ossProperties.getEndpoint().replaceFirst(prefix, "");
    }

    @Override
    public byte[] statFileByte(String bucketName, String fileName) {
        return new byte[0];
    }

    @Override
    public String initMultipartUpload(String fileName) {
        return null;
    }

    @Override
    public String initMultipartUpload(String bucketName, String fileName) {
        return null;
    }

    @Override
    public BamuPartETag putFile(String fileName, InputStream stream, String uploadId, int partNumber, long partSize) {
        return null;
    }

    @Override
    public BamuPartETag putFile(String bucketName, String fileName, InputStream stream, String uploadId, int partNumber, long partSize) {
        return null;
    }

    @Override
    public BaseFile completeMultipart(String fileName, String uploadId, Object partETags) {
        return null;
    }

    @Override
    public BaseFile completeMultipart(String bucketName, String fileName, String uploadId, Object partETags) {
        return null;
    }

    public HuaweiObsTemplate(ObsClient obsClient, OssProperties ossProperties, OssRule ossRule) {
        this.obsClient = obsClient;
        this.ossProperties = ossProperties;
        this.ossRule = ossRule;
    }
}

