/*
 * Decompiled with CFR 0.152.
 */
package org.macrocloud.kernel.oss;

import com.aliyun.oss.ServiceException;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.minio.BucketExistsArgs;
import io.minio.CopyObjectArgs;
import io.minio.CopySource;
import io.minio.CreateMultipartUploadResponse;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveBucketArgs;
import io.minio.RemoveObjectArgs;
import io.minio.RemoveObjectsArgs;
import io.minio.SetBucketPolicyArgs;
import io.minio.StatObjectArgs;
import io.minio.StatObjectResponse;
import io.minio.UploadPartResponse;
import io.minio.http.Method;
import io.minio.messages.Bucket;
import io.minio.messages.DeleteObject;
import io.minio.messages.Part;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.macrocloud.kernel.oss.OssTemplate;
import org.macrocloud.kernel.oss.enums.OssEnum;
import org.macrocloud.kernel.oss.enums.PolicyType;
import org.macrocloud.kernel.oss.model.BamuPartETag;
import org.macrocloud.kernel.oss.model.BaseFile;
import org.macrocloud.kernel.oss.model.OssFile;
import org.macrocloud.kernel.oss.props.OssProperties;
import org.macrocloud.kernel.oss.rule.OssRule;
import org.macrocloud.kernel.tool.utils.DateUtil;
import org.macrocloud.kernel.tool.utils.FileUtil;
import org.macrocloud.kernel.tool.utils.Func;
import org.macrocloud.kernel.tool.utils.StringUtil;
import org.springframework.web.multipart.MultipartFile;

public class MinioTemplate
implements OssTemplate {
    private final MinioClient client;
    private final OssRule ossRule;
    private final OssProperties ossProperties;

    @Override
    public void makeBucket(String bucketName) {
        if (!this.client.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(this.getBucketName(bucketName))).build())) {
            this.client.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(this.getBucketName(bucketName))).build());
            this.client.setBucketPolicy((SetBucketPolicyArgs)((SetBucketPolicyArgs.Builder)SetBucketPolicyArgs.builder().bucket(this.getBucketName(bucketName))).config(MinioTemplate.getPolicyType(this.getBucketName(bucketName), PolicyType.READ)).build());
        }
    }

    public Bucket getBucket() {
        return this.getBucket(this.getBucketName());
    }

    public Bucket getBucket(String bucketName) {
        Optional<Bucket> bucketOptional = this.client.listBuckets().stream().filter(bucket -> bucket.name().equals(this.getBucketName(bucketName))).findFirst();
        return bucketOptional.orElse(null);
    }

    public List<Bucket> listBuckets() {
        return this.client.listBuckets();
    }

    @Override
    public void removeBucket(String bucketName) {
        this.client.removeBucket((RemoveBucketArgs)((RemoveBucketArgs.Builder)RemoveBucketArgs.builder().bucket(this.getBucketName(bucketName))).build());
    }

    @Override
    public boolean bucketExists(String bucketName) {
        return this.client.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(this.getBucketName(bucketName))).build());
    }

    @Override
    public void copyFile(String bucketName, String fileName, String destBucketName) {
        this.copyFile(bucketName, fileName, destBucketName, fileName);
    }

    @Override
    public void copyFile(String bucketName, String fileName, String destBucketName, String destFileName) {
        this.client.copyObject((CopyObjectArgs)((CopyObjectArgs.Builder)((CopyObjectArgs.Builder)CopyObjectArgs.builder().source((CopySource)((CopySource.Builder)((CopySource.Builder)CopySource.builder().bucket(this.getBucketName(bucketName))).object(fileName)).build()).bucket(this.getBucketName(destBucketName))).object(destFileName)).build());
    }

    @Override
    public OssFile statFile(String fileName) {
        return this.statFile(this.ossProperties.getBucketName(), fileName);
    }

    @Override
    public OssFile statFile(String bucketName, String fileName) {
        StatObjectResponse stat = this.client.statObject((StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(this.getBucketName(bucketName))).object(fileName)).build());
        OssFile ossFile = new OssFile();
        ossFile.setName(Func.isEmpty((Object)stat.object()) ? fileName : stat.object());
        ossFile.setLink(this.fileLink(ossFile.getName()));
        ossFile.setHash(String.valueOf(stat.hashCode()));
        ossFile.setLength(stat.size());
        ossFile.setPutTime(DateUtil.toDate((LocalDateTime)stat.lastModified().toLocalDateTime()));
        ossFile.setContentType(stat.contentType());
        return ossFile;
    }

    @Override
    public String filePath(String fileName) {
        return this.getBucketName().concat("/").concat(fileName);
    }

    @Override
    public String filePath(String bucketName, String fileName) {
        return this.getBucketName(bucketName).concat("/").concat(fileName);
    }

    @Override
    public String fileLink(String fileName) {
        return this.ossProperties.getEndpoint().concat("/").concat(this.getBucketName()).concat("/").concat(fileName);
    }

    @Override
    public String fileLink(String bucketName, String fileName) {
        return this.ossProperties.getEndpoint().concat("/").concat(this.getBucketName(bucketName)).concat("/").concat(fileName);
    }

    @Override
    public BaseFile putFile(MultipartFile file) {
        return this.putFile(this.ossProperties.getBucketName(), file.getOriginalFilename(), file);
    }

    @Override
    public BaseFile putFile(String fileName, MultipartFile file) {
        return this.putFile(this.ossProperties.getBucketName(), fileName, file);
    }

    @Override
    public BaseFile putFile(String bucketName, String fileName, MultipartFile file) {
        return this.putFile(bucketName, file.getOriginalFilename(), file.getInputStream());
    }

    @Override
    public BaseFile putFile(String fileName, InputStream stream) {
        return this.putFile(this.ossProperties.getBucketName(), fileName, stream);
    }

    @Override
    public BaseFile putFile(String bucketName, String fileName, InputStream stream) {
        return this.putFile(bucketName, fileName, stream, "application/octet-stream");
    }

    public BaseFile putFile(String bucketName, String fileName, InputStream stream, String contentType) {
        this.makeBucket(bucketName);
        String originalName = fileName;
        fileName = this.getFileName(fileName);
        this.client.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.getBucketName(bucketName))).object(fileName)).stream(stream, (long)stream.available(), -1L).contentType(contentType).build());
        BaseFile file = new BaseFile();
        file.setOriginalName(originalName);
        file.setName(fileName);
        file.setDomain(this.getOssHost(bucketName));
        file.setLink(this.fileLink(bucketName, fileName));
        file.setSource(OssEnum.MINIO.getName());
        file.setBucketName(this.getBucketName(bucketName));
        file.setOuterDomain(this.getOssOuterHost(bucketName));
        return file;
    }

    @Override
    public void removeFile(String fileName) {
        this.removeFile(this.ossProperties.getBucketName(), fileName);
    }

    @Override
    public void removeFile(String bucketName, String fileName) {
        this.client.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(this.getBucketName(bucketName))).object(fileName)).build());
    }

    @Override
    public void removeFiles(List<String> fileNames) {
        this.removeFiles(this.ossProperties.getBucketName(), fileNames);
    }

    @Override
    public void removeFiles(String bucketName, List<String> fileNames) {
        Stream<DeleteObject> stream = fileNames.stream().map(DeleteObject::new);
        this.client.removeObjects((RemoveObjectsArgs)((RemoveObjectsArgs.Builder)RemoveObjectsArgs.builder().bucket(this.getBucketName(bucketName))).objects(stream::iterator).build());
    }

    private String getOssOuterHost(String bucketName) {
        return this.ossProperties.getOuterEndpoint() + "/" + this.getBucketName(bucketName);
    }

    private String getBucketName() {
        return this.getBucketName(this.ossProperties.getBucketName());
    }

    private String getBucketName(String bucketName) {
        return this.ossRule.bucketName(bucketName);
    }

    private String getFileName(String originalFilename) {
        return this.ossRule.fileName(originalFilename);
    }

    public String getPresignedObjectUrl(String bucketName, String fileName, Integer expires) {
        return this.client.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.GET).bucket(this.getBucketName(bucketName))).object(fileName)).expiry(expires.intValue()).build());
    }

    public String getPolicyType(PolicyType policyType) {
        return MinioTemplate.getPolicyType(this.getBucketName(), policyType);
    }

    public static String getPolicyType(String bucketName, PolicyType policyType) {
        StringBuilder builder = new StringBuilder();
        builder.append("{\n");
        builder.append("    \"Statement\": [\n");
        builder.append("        {\n");
        builder.append("            \"Action\": [\n");
        switch (policyType) {
            case WRITE: {
                builder.append("                \"s3:GetBucketLocation\",\n");
                builder.append("                \"s3:ListBucketMultipartUploads\"\n");
                break;
            }
            case READ_WRITE: {
                builder.append("                \"s3:GetBucketLocation\",\n");
                builder.append("                \"s3:ListBucket\",\n");
                builder.append("                \"s3:ListBucketMultipartUploads\"\n");
                break;
            }
            default: {
                builder.append("                \"s3:GetBucketLocation\"\n");
            }
        }
        builder.append("            ],\n");
        builder.append("            \"Effect\": \"Allow\",\n");
        builder.append("            \"Principal\": \"*\",\n");
        builder.append("            \"Resource\": \"arn:aws:s3:::");
        builder.append(bucketName);
        builder.append("\"\n");
        builder.append("        },\n");
        if (PolicyType.READ.equals((Object)policyType)) {
            builder.append("        {\n");
            builder.append("            \"Action\": [\n");
            builder.append("                \"s3:ListBucket\"\n");
            builder.append("            ],\n");
            builder.append("            \"Effect\": \"Deny\",\n");
            builder.append("            \"Principal\": \"*\",\n");
            builder.append("            \"Resource\": \"arn:aws:s3:::");
            builder.append(bucketName);
            builder.append("\"\n");
            builder.append("        },\n");
        }
        builder.append("        {\n");
        builder.append("            \"Action\": ");
        switch (policyType) {
            case WRITE: {
                builder.append("[\n");
                builder.append("                \"s3:AbortMultipartUpload\",\n");
                builder.append("                \"s3:DeleteObject\",\n");
                builder.append("                \"s3:ListMultipartUploadParts\",\n");
                builder.append("                \"s3:PutObject\"\n");
                builder.append("            ],\n");
                break;
            }
            case READ_WRITE: {
                builder.append("[\n");
                builder.append("                \"s3:AbortMultipartUpload\",\n");
                builder.append("                \"s3:DeleteObject\",\n");
                builder.append("                \"s3:GetObject\",\n");
                builder.append("                \"s3:ListMultipartUploadParts\",\n");
                builder.append("                \"s3:PutObject\"\n");
                builder.append("            ],\n");
                break;
            }
            default: {
                builder.append("\"s3:GetObject\",\n");
            }
        }
        builder.append("            \"Effect\": \"Allow\",\n");
        builder.append("            \"Principal\": \"*\",\n");
        builder.append("            \"Resource\": \"arn:aws:s3:::");
        builder.append(bucketName);
        builder.append("/*\"\n");
        builder.append("        }\n");
        builder.append("    ],\n");
        builder.append("    \"Version\": \"2012-10-17\"\n");
        builder.append("}\n");
        return builder.toString();
    }

    public String getOssHost(String bucketName) {
        return this.ossProperties.getEndpoint() + "/" + this.getBucketName(bucketName);
    }

    public String getOssHost() {
        return this.getOssHost(this.ossProperties.getBucketName());
    }

    @Override
    public byte[] statFileByte(String bucketName, String fileName) {
        try {
            this.client.statObject((StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(this.getBucketName(bucketName))).object(fileName)).build());
        }
        catch (Exception e) {
            throw new ServiceException("minio\u4e0a\u627e\u4e0d\u5230\u8be5\u6587\u4ef6\uff01\u6587\u4ef6\u540d\uff1a" + fileName);
        }
        try {
            int bytesRead;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GetObjectResponse stream = this.client.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.getBucketName(bucketName))).object(fileName)).build());
            byte[] buf = new byte[1024];
            while ((bytesRead = stream.read(buf, 0, buf.length)) >= 0) {
                baos.write(buf, 0, bytesRead);
            }
            byte[] bytes = baos.toByteArray();
            baos.flush();
            stream.close();
            baos.close();
            return bytes;
        }
        catch (Exception e) {
            throw new ServiceException("minio\u83b7\u53d6\u6587\u4ef6\u6d41\u9519\u8bef\uff01" + e);
        }
    }

    @Override
    public String initMultipartUpload(String fileName) {
        return this.initMultipartUpload(this.ossProperties.getBucketName(), fileName);
    }

    @Override
    public String initMultipartUpload(String bucketName, String fileName) {
        this.makeBucket(bucketName);
        HashMultimap headerMap = HashMultimap.create();
        String contentType = this.contentType("." + FileUtil.getFileExtension((String)fileName));
        if (StringUtil.isBlank((CharSequence)contentType)) {
            contentType = "application/octet-stream";
        }
        headerMap.put((Object)"Content-Type", (Object)contentType);
        CreateMultipartUploadResponse multipartUpload = this.client.createMultipartUpload(this.getBucketName(bucketName), null, fileName, (Multimap<String, String>)headerMap, null);
        return multipartUpload.result().uploadId();
    }

    @Override
    public BamuPartETag putFile(String fileName, InputStream stream, String uploadId, int partNumber, long partSize) {
        return this.putFile(this.ossProperties.getBucketName(), fileName, stream, uploadId, partNumber, partSize);
    }

    @Override
    public BamuPartETag putFile(String bucketName, String fileName, InputStream stream, String uploadId, int partNumber, long partSize) {
        this.makeBucket(bucketName);
        UploadPartResponse uploadPartResponse = this.client.uploadPart(this.getBucketName(bucketName), null, fileName, stream, (int)partSize, uploadId, partNumber, null, null);
        BamuPartETag bamuPartETag = new BamuPartETag();
        String etag = uploadPartResponse.etag();
        bamuPartETag.seteTag(etag);
        return bamuPartETag;
    }

    @Override
    public BaseFile completeMultipart(String fileName, String uploadId, Object partETags) {
        return this.completeMultipart(this.ossProperties.getBucketName(), fileName, uploadId, partETags);
    }

    @Override
    public BaseFile completeMultipart(String bucketName, String fileName, String uploadId, Object partETags) {
        this.client.completeMultipartUpload(this.getBucketName(bucketName), null, fileName, uploadId, (Part[])partETags, null, null);
        BaseFile file = new BaseFile();
        file.setDomain(this.getOssHost(bucketName));
        file.setOuterDomain(this.getOssOuterHost(bucketName));
        file.setLink(this.fileLink(bucketName, fileName));
        file.setSource(OssEnum.MINIO.getName());
        file.setBucketName(this.getBucketName(bucketName));
        return file;
    }

    private String contentType(String FilenameExtension) {
        if (FilenameExtension.equals(".BMP") || FilenameExtension.equals(".bmp") || FilenameExtension.toUpperCase().equals(".BMP")) {
            return "image/bmp";
        }
        if (FilenameExtension.equals(".GIF") || FilenameExtension.equals(".gif") || FilenameExtension.toUpperCase().equals(".GIF")) {
            return "image/gif";
        }
        if (FilenameExtension.equals(".JPEG") || FilenameExtension.equals(".jpeg") || FilenameExtension.equals(".JPG") || FilenameExtension.equals(".jpg") || FilenameExtension.equals(".PNG") || FilenameExtension.equals(".png") || FilenameExtension.toUpperCase().equals(".JPEG") || FilenameExtension.toUpperCase().equals(".JPG") || FilenameExtension.toUpperCase().equals(".PNG")) {
            return "image/jpeg";
        }
        if (FilenameExtension.equals(".HTML") || FilenameExtension.equals(".html")) {
            return "text/html";
        }
        if (FilenameExtension.equals(".TXT") || FilenameExtension.equals(".txt") || FilenameExtension.toUpperCase().equals(".TXT")) {
            return "text/plain";
        }
        if (FilenameExtension.equals(".VSD") || FilenameExtension.equals(".vsd") || FilenameExtension.toUpperCase().equals(".VSD")) {
            return "application/vnd.visio";
        }
        if (FilenameExtension.equals(".PPTX") || FilenameExtension.equals(".pptx") || FilenameExtension.equals(".PPT") || FilenameExtension.equals(".ppt") || FilenameExtension.toUpperCase().equals(".PPTX") || FilenameExtension.toUpperCase().equals(".PPT")) {
            return "application/vnd.ms-powerpoint";
        }
        if (FilenameExtension.equals(".DOCX") || FilenameExtension.equals(".docx") || FilenameExtension.equals(".DOC") || FilenameExtension.equals(".doc") || FilenameExtension.toUpperCase().equals(".DOCX") || FilenameExtension.toUpperCase().equals(".DOC")) {
            return "application/msword";
        }
        if (FilenameExtension.equals(".XML") || FilenameExtension.equals(".xml") || FilenameExtension.toUpperCase().equals(".XML")) {
            return "text/xml";
        }
        if (FilenameExtension.equals(".pdf") || FilenameExtension.equals(".PDF") || FilenameExtension.toUpperCase().equals(".PDF")) {
            return "application/pdf";
        }
        return null;
    }

    public MinioTemplate(MinioClient client, OssRule ossRule, OssProperties ossProperties) {
        this.client = client;
        this.ossRule = ossRule;
        this.ossProperties = ossProperties;
    }
}

