/*
 * Decompiled with CFR 0.152.
 */
package org.macrocloud.kernel.oss;

import com.qiniu.common.Zone;
import com.qiniu.http.Response;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.UploadManager;
import com.qiniu.storage.model.FileInfo;
import com.qiniu.util.Auth;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import org.macrocloud.kernel.oss.OssTemplate;
import org.macrocloud.kernel.oss.enums.OssEnum;
import org.macrocloud.kernel.oss.model.BamuPartETag;
import org.macrocloud.kernel.oss.model.BaseFile;
import org.macrocloud.kernel.oss.model.OssFile;
import org.macrocloud.kernel.oss.props.OssProperties;
import org.macrocloud.kernel.oss.rule.OssRule;
import org.macrocloud.kernel.tool.utils.CollectionUtil;
import org.macrocloud.kernel.tool.utils.Func;
import org.springframework.web.multipart.MultipartFile;

public class QiniuTemplate
implements OssTemplate {
    private final Auth auth;
    private final UploadManager uploadManager;
    private final BucketManager bucketManager;
    private final OssProperties ossProperties;
    private final OssRule ossRule;

    @Override
    public void makeBucket(String bucketName) {
        if (!CollectionUtil.contains((Object[])this.bucketManager.buckets(), (Object)this.getBucketName(bucketName))) {
            this.bucketManager.createBucket(this.getBucketName(bucketName), Zone.autoZone().getRegion());
        }
    }

    @Override
    public void removeBucket(String bucketName) {
    }

    @Override
    public boolean bucketExists(String bucketName) {
        return CollectionUtil.contains((Object[])this.bucketManager.buckets(), (Object)this.getBucketName(bucketName));
    }

    @Override
    public void copyFile(String bucketName, String fileName, String destBucketName) {
        this.bucketManager.copy(this.getBucketName(bucketName), fileName, this.getBucketName(destBucketName), fileName);
    }

    @Override
    public void copyFile(String bucketName, String fileName, String destBucketName, String destFileName) {
        this.bucketManager.copy(this.getBucketName(bucketName), fileName, this.getBucketName(destBucketName), destFileName);
    }

    @Override
    public OssFile statFile(String fileName) {
        return this.statFile(this.ossProperties.getBucketName(), fileName);
    }

    @Override
    public OssFile statFile(String bucketName, String fileName) {
        FileInfo stat = this.bucketManager.stat(this.getBucketName(bucketName), fileName);
        OssFile ossFile = new OssFile();
        ossFile.setName(Func.isEmpty((Object)stat.key) ? fileName : stat.key);
        ossFile.setLink(this.fileLink(ossFile.getName()));
        ossFile.setHash(stat.hash);
        ossFile.setLength(stat.fsize);
        ossFile.setPutTime(new Date(stat.putTime / 10000L));
        ossFile.setContentType(stat.mimeType);
        return ossFile;
    }

    @Override
    public String filePath(String fileName) {
        return this.getBucketName().concat("/").concat(fileName);
    }

    @Override
    public String filePath(String bucketName, String fileName) {
        return this.getBucketName(bucketName).concat("/").concat(fileName);
    }

    @Override
    public String fileLink(String fileName) {
        return this.ossProperties.getEndpoint().concat("/").concat(fileName);
    }

    @Override
    public String fileLink(String bucketName, String fileName) {
        return this.ossProperties.getEndpoint().concat("/").concat(fileName);
    }

    @Override
    public BaseFile putFile(MultipartFile file) {
        return this.putFile(this.ossProperties.getBucketName(), file.getOriginalFilename(), file);
    }

    @Override
    public BaseFile putFile(String fileName, MultipartFile file) {
        return this.putFile(this.ossProperties.getBucketName(), fileName, file);
    }

    @Override
    public BaseFile putFile(String bucketName, String fileName, MultipartFile file) {
        return this.putFile(bucketName, fileName, file.getInputStream());
    }

    @Override
    public BaseFile putFile(String fileName, InputStream stream) {
        return this.putFile(this.ossProperties.getBucketName(), fileName, stream);
    }

    @Override
    public BaseFile putFile(String bucketName, String fileName, InputStream stream) {
        return this.put(bucketName, stream, fileName, false);
    }

    public BaseFile put(String bucketName, InputStream stream, String key, boolean cover) {
        this.makeBucket(bucketName);
        String originalName = key;
        key = this.getFileName(key);
        if (cover) {
            this.uploadManager.put(stream, key, this.getUploadToken(bucketName, key), null, null);
        } else {
            Response response = this.uploadManager.put(stream, key, this.getUploadToken(bucketName), null, null);
            int retryCount = 5;
            for (int retry = 0; response.needRetry() && retry < retryCount; ++retry) {
                response = this.uploadManager.put(stream, key, this.getUploadToken(bucketName), null, null);
            }
        }
        BaseFile file = new BaseFile();
        file.setOriginalName(originalName);
        file.setName(key);
        file.setDomain(this.getOssHost());
        file.setLink(this.fileLink(bucketName, key));
        file.setSource(OssEnum.QINIU.getName());
        file.setBucketName(this.getBucketName(bucketName));
        file.setOuterDomain(this.getOssOuterHost());
        return file;
    }

    @Override
    public void removeFile(String fileName) {
        this.bucketManager.delete(this.getBucketName(), fileName);
    }

    @Override
    public void removeFile(String bucketName, String fileName) {
        this.bucketManager.delete(this.getBucketName(bucketName), fileName);
    }

    @Override
    public void removeFiles(List<String> fileNames) {
        fileNames.forEach(this::removeFile);
    }

    @Override
    public void removeFiles(String bucketName, List<String> fileNames) {
        fileNames.forEach(fileName -> this.removeFile(this.getBucketName(bucketName), (String)fileName));
    }

    private String getOssOuterHost() {
        return this.ossProperties.getOuterEndpoint();
    }

    private String getBucketName() {
        return this.getBucketName(this.ossProperties.getBucketName());
    }

    private String getBucketName(String bucketName) {
        return this.ossRule.bucketName(bucketName);
    }

    private String getFileName(String originalFilename) {
        return this.ossRule.fileName(originalFilename);
    }

    public String getUploadToken(String bucketName) {
        return this.auth.uploadToken(this.getBucketName(bucketName));
    }

    private String getUploadToken(String bucketName, String key) {
        return this.auth.uploadToken(this.getBucketName(bucketName), key);
    }

    public String getOssHost() {
        return this.ossProperties.getEndpoint();
    }

    @Override
    public byte[] statFileByte(String bucketName, String fileName) {
        return new byte[0];
    }

    @Override
    public String initMultipartUpload(String fileName) {
        return null;
    }

    @Override
    public String initMultipartUpload(String bucketName, String fileName) {
        return null;
    }

    @Override
    public BamuPartETag putFile(String fileName, InputStream stream, String uploadId, int partNumber, long partSize) {
        return null;
    }

    @Override
    public BamuPartETag putFile(String bucketName, String fileName, InputStream stream, String uploadId, int partNumber, long partSize) {
        return null;
    }

    @Override
    public BaseFile completeMultipart(String fileName, String uploadId, Object partETags) {
        return null;
    }

    @Override
    public BaseFile completeMultipart(String bucketName, String fileName, String uploadId, Object partETags) {
        return null;
    }

    public QiniuTemplate(Auth auth, UploadManager uploadManager, BucketManager bucketManager, OssProperties ossProperties, OssRule ossRule) {
        this.auth = auth;
        this.uploadManager = uploadManager;
        this.bucketManager = bucketManager;
        this.ossProperties = ossProperties;
        this.ossRule = ossRule;
    }
}

