/*
 * Decompiled with CFR 0.152.
 */
package org.macrocloud.kernel.oss.config;

import com.aliyun.oss.OSSClient;
import com.obs.services.ObsClient;
import com.obs.services.ObsConfiguration;
import org.macrocloud.kernel.oss.HuaweiObsTemplate;
import org.macrocloud.kernel.oss.config.OssConfiguration;
import org.macrocloud.kernel.oss.props.OssProperties;
import org.macrocloud.kernel.oss.rule.OssRule;
import org.macrocloud.kernel.oss.rule.impl.OssRuleImpl;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={OssConfiguration.class})
@EnableConfigurationProperties(value={OssProperties.class})
@ConditionalOnClass(value={OSSClient.class})
@ConditionalOnProperty(value={"oss.name"}, havingValue="huaweiobs")
public class HuaweiObsConfiguration {
    private final OssProperties ossProperties;

    @Bean
    @ConditionalOnMissingBean(value={OssRule.class})
    public OssRule ossRule() {
        return new OssRuleImpl(this.ossProperties.getTenantMode());
    }

    @Bean
    @ConditionalOnMissingBean(value={ObsClient.class})
    public ObsClient ossClient() {
        ObsConfiguration conf = new ObsConfiguration();
        conf.setEndPoint(this.ossProperties.getEndpoint());
        conf.setMaxConnections(1024);
        conf.setSocketTimeout(50000);
        conf.setConnectionTimeout(50000);
        conf.setConnectionRequestTimeout(1000);
        conf.setIdleConnectionTime(60000);
        conf.setMaxErrorRetry(5);
        return new ObsClient(this.ossProperties.getAccessKey(), this.ossProperties.getSecretKey(), conf);
    }

    @Bean
    @ConditionalOnMissingBean(value={HuaweiObsTemplate.class})
    @ConditionalOnBean(value={ObsClient.class, OssRule.class})
    public HuaweiObsTemplate huaweiobsTemplate(ObsClient ossClient, OssRule ossRule) {
        return new HuaweiObsTemplate(ossClient, this.ossProperties, ossRule);
    }

    public HuaweiObsConfiguration(OssProperties ossProperties) {
        this.ossProperties = ossProperties;
    }
}

