/*
 * Decompiled with CFR 0.152.
 */
package org.macrocloud.kernel.oss.config;

import com.qiniu.storage.BucketManager;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.Region;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import org.macrocloud.kernel.oss.QiniuTemplate;
import org.macrocloud.kernel.oss.config.OssConfiguration;
import org.macrocloud.kernel.oss.props.OssProperties;
import org.macrocloud.kernel.oss.rule.OssRule;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@org.springframework.context.annotation.Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={OssConfiguration.class})
@ConditionalOnClass(value={Auth.class, UploadManager.class, BucketManager.class})
@EnableConfigurationProperties(value={OssProperties.class})
@ConditionalOnProperty(value={"oss.name"}, havingValue="qiniu")
public class QiniuConfiguration {
    private final OssProperties ossProperties;
    private final OssRule ossRule;

    @Bean
    @ConditionalOnMissingBean(value={Configuration.class})
    public Configuration qnConfiguration() {
        return new Configuration(Region.autoRegion());
    }

    @Bean
    @ConditionalOnMissingBean(value={Auth.class})
    public Auth auth() {
        return Auth.create((String)this.ossProperties.getAccessKey(), (String)this.ossProperties.getSecretKey());
    }

    @Bean
    @ConditionalOnBean(value={Configuration.class})
    public UploadManager uploadManager(Configuration cfg) {
        return new UploadManager(cfg);
    }

    @Bean
    @ConditionalOnBean(value={Configuration.class})
    public BucketManager bucketManager(Configuration cfg) {
        return new BucketManager(Auth.create((String)this.ossProperties.getAccessKey(), (String)this.ossProperties.getSecretKey()), cfg);
    }

    @Bean
    @ConditionalOnBean(value={Auth.class, UploadManager.class, BucketManager.class})
    @ConditionalOnMissingBean(value={QiniuTemplate.class})
    public QiniuTemplate qiniuTemplate(Auth auth, UploadManager uploadManager, BucketManager bucketManager) {
        return new QiniuTemplate(auth, uploadManager, bucketManager, this.ossProperties, this.ossRule);
    }

    public QiniuConfiguration(OssProperties ossProperties, OssRule ossRule) {
        this.ossProperties = ossProperties;
        this.ossRule = ossRule;
    }
}

