/*
 * Decompiled with CFR 0.152.
 */
package org.macrocloud.kernel.redis.config;

import org.macrocloud.kernel.redis.config.RedisProperties;
import org.macrocloud.kernel.redis.config.RedisSerializerConfigAble;
import org.macrocloud.kernel.redis.config.RedisTemplateConfiguration;
import org.macrocloud.kernel.redis.serializer.ProtoStuffSerializer;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.serializer.RedisSerializer;

@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={RedisTemplateConfiguration.class})
@ConditionalOnClass(name={"io.protostuff.Schema"})
public class ProtoStuffSerializerConfiguration
implements RedisSerializerConfigAble {
    @Override
    @Bean
    @ConditionalOnMissingBean
    public RedisSerializer<Object> redisSerializer(RedisProperties properties) {
        if (RedisProperties.SerializerType.ProtoStuff == properties.getSerializerType()) {
            return new ProtoStuffSerializer();
        }
        return this.defaultRedisSerializer(properties);
    }
}

