/*
 * Decompiled with CFR 0.152.
 */
package org.macrocloud.kernel.redis.config;

import org.macrocloud.kernel.jwt.config.JwtRedisConfiguration;
import org.macrocloud.kernel.redis.cache.BaseRedis;
import org.macrocloud.kernel.redis.config.RedisProperties;
import org.macrocloud.kernel.redis.config.RedisSerializerConfigAble;
import org.macrocloud.kernel.redis.serializer.RedisKeySerializer;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.serializer.RedisSerializer;

@EnableCaching
@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={JwtRedisConfiguration.class, RedisAutoConfiguration.class})
@EnableConfigurationProperties(value={RedisProperties.class})
public class RedisTemplateConfiguration
implements RedisSerializerConfigAble {
    @Override
    @Bean
    @ConditionalOnMissingBean(value={RedisSerializer.class})
    public RedisSerializer<Object> redisSerializer(RedisProperties properties) {
        return this.defaultRedisSerializer(properties);
    }

    @Bean(name={"redisTemplate"})
    @ConditionalOnMissingBean(name={"redisTemplate"})
    public RedisTemplate<String, Object> redisTemplate(RedisConnectionFactory redisConnectionFactory, RedisSerializer<Object> redisSerializer) {
        RedisTemplate redisTemplate = new RedisTemplate();
        RedisKeySerializer keySerializer = new RedisKeySerializer();
        redisTemplate.setKeySerializer((RedisSerializer)keySerializer);
        redisTemplate.setHashKeySerializer((RedisSerializer)keySerializer);
        redisTemplate.setValueSerializer(redisSerializer);
        redisTemplate.setHashValueSerializer(redisSerializer);
        redisTemplate.setConnectionFactory(redisConnectionFactory);
        return redisTemplate;
    }

    @Bean
    @ConditionalOnMissingBean(value={ValueOperations.class})
    public ValueOperations valueOperations(RedisTemplate redisTemplate) {
        return redisTemplate.opsForValue();
    }

    @Bean
    public BaseRedis macroRedis(RedisTemplate<String, Object> redisTemplate) {
        return new BaseRedis(redisTemplate);
    }
}

