/*
 * Decompiled with CFR 0.152.
 */
package org.macrocloud.kernel.redis.lock;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.macrocloud.kernel.redis.lock.LockType;
import org.macrocloud.kernel.redis.lock.RedisLock;
import org.macrocloud.kernel.redis.lock.RedisLockClient;
import org.macrocloud.kernel.toolkit.spel.ExpressionEvaluator;
import org.macrocloud.kernel.toolkit.utils.StringUtil;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.AnnotatedElementKey;
import org.springframework.expression.EvaluationContext;
import org.springframework.util.Assert;

@Aspect
public class RedisLockAspect
implements ApplicationContextAware {
    private static final ExpressionEvaluator EVALUATOR = new ExpressionEvaluator();
    private final RedisLockClient redisLockClient;
    private ApplicationContext applicationContext;

    @Around(value="@annotation(redisLock)")
    public Object aroundRedisLock(ProceedingJoinPoint point, RedisLock redisLock) {
        String lockKey;
        String lockName = redisLock.value();
        Assert.hasText((String)lockName, (String)"@RedisLock value must have length; it must not be null or empty");
        String lockParam = redisLock.param();
        if (StringUtil.isNotBlank((CharSequence)lockParam)) {
            String evalAsText = this.evalLockParam(point, lockParam);
            lockKey = lockName + ':' + evalAsText;
        } else {
            lockKey = lockName;
        }
        LockType lockType = redisLock.type();
        long waitTime = redisLock.waitTime();
        long leaseTime = redisLock.leaseTime();
        TimeUnit timeUnit = redisLock.timeUnit();
        return this.redisLockClient.lock(lockKey, lockType, waitTime, leaseTime, timeUnit, () -> ((ProceedingJoinPoint)point).proceed());
    }

    private String evalLockParam(ProceedingJoinPoint point, String lockParam) {
        MethodSignature ms = (MethodSignature)point.getSignature();
        Method method = ms.getMethod();
        Object[] args = point.getArgs();
        Object target = point.getTarget();
        Class<?> targetClass = target.getClass();
        EvaluationContext context = EVALUATOR.createContext(method, args, target, targetClass, (BeanFactory)this.applicationContext);
        AnnotatedElementKey elementKey = new AnnotatedElementKey((AnnotatedElement)method, targetClass);
        return EVALUATOR.evalAsText(lockParam, elementKey, context);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public RedisLockAspect(RedisLockClient redisLockClient) {
        this.redisLockClient = redisLockClient;
    }
}

