/*
 * Decompiled with CFR 0.152.
 */
package org.maochen.nlp.parser;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.maochen.nlp.parser.DNode;
import org.maochen.nlp.parser.DTree;

public class LangTools {
    private static final Map<String, String> contractions = new HashMap<String, String>(){
        {
            this.put("'m", "am");
            this.put("'re", "are");
            this.put("'ve", "have");
            this.put("can't", "cannot");
            this.put("ma'am", "madam");
            this.put("'ll", "will");
        }
    };

    public static void generateLemma(DNode node) {
        if (node.getForm().equalsIgnoreCase("'d") && node.getPOS().equals("MD")) {
            node.setLemma(node.getLemma());
        } else if (contractions.containsKey(node.getForm())) {
            node.setLemma(contractions.get(node.getForm()));
        }
    }

    public static String getCPOSTag(String pos) {
        if (pos.equals("NNP") || pos.equals("NNPS")) {
            return "PROPN";
        }
        if (pos.equals("NN") || pos.equals("NNS")) {
            return "NOUN";
        }
        if (pos.startsWith("VB")) {
            return "VERB";
        }
        if (pos.startsWith("JJ")) {
            return "ADJ";
        }
        if (pos.equals("IN") || pos.equals("TO")) {
            return "ADP";
        }
        if (pos.startsWith("RB") || pos.equals("WRB")) {
            return "ADV";
        }
        if (pos.equals("MD")) {
            return "AUX";
        }
        if (pos.equals("CC")) {
            return "CONJ";
        }
        if (pos.equals("CD")) {
            return "NUM";
        }
        if (pos.equals("DT") || pos.equals("WDT") || pos.equals("PDT") || pos.equals("EX")) {
            return "DET";
        }
        if (pos.equals("POS") || pos.equals("RP")) {
            return "PART";
        }
        if (pos.startsWith("PRP") || pos.startsWith("WP")) {
            return "PRON";
        }
        if (pos.equals("UH")) {
            return "INTJ";
        }
        if (pos.equals("WRB")) {
            return "X";
        }
        if (pos.equals("SYM") || pos.equals("$") || pos.equals("#")) {
            return "SYM";
        }
        if (pos.equals(".") || pos.equals(",") || pos.equals(":") || pos.equals("``") || pos.equals("''") || pos.equals("HYPH") || pos.matches("-.*B-")) {
            return "PUNCT";
        }
        return "X";
    }

    public static DTree getDTreeFromCoNLLXString(String input) {
        if (input == null || input.trim().isEmpty()) {
            return null;
        }
        HashMap semanticHeadsMap = new HashMap();
        String[] dNodesString = input.split(System.lineSeparator());
        DTree tree = new DTree();
        ((Stream)Arrays.stream(dNodesString).parallel()).map(s -> s.split("\t")).forEachOrdered(fields -> {
            DNode node;
            String semanticHeadsString;
            int currentIndex = 0;
            int id = Integer.parseInt(fields[currentIndex++]);
            String form = fields[currentIndex++];
            String lemma = fields[currentIndex++];
            String cPOSTag = fields[currentIndex++];
            String pos = fields[currentIndex++];
            String feats = fields[currentIndex++];
            Map<Object, Object> featsMap = null;
            featsMap = !feats.equals("_") ? Arrays.stream(feats.split("\\|")).map(entry -> entry.split("=")).collect(Collectors.toMap(e -> e[0], e -> ((String[])e).length > 1 ? e[1] : "")) : new HashMap();
            String headIndex = fields[currentIndex++];
            String depLabel = fields[currentIndex++];
            String dump1 = fields[currentIndex++];
            String dump2 = fields[currentIndex++];
            String string = semanticHeadsString = currentIndex >= ((String[])fields).length ? "_" : fields[currentIndex];
            if (!semanticHeadsString.equals("_")) {
                Map<Integer, String> semanticHeads = Arrays.stream(semanticHeadsString.split("\\|")).map(entry -> entry.split(":")).collect(Collectors.toMap(e -> Integer.parseInt(e[0]), e -> ((String[])e).length > 1 ? e[1] : ""));
                semanticHeadsMap.put(id, semanticHeads);
            }
            DNode dNode = node = id == 0 ? tree.getPaddingNode() : new DNode(id, form, lemma, cPOSTag, pos, depLabel);
            if (id == 0) {
                featsMap.put("uuid", tree.getUUID().toString());
            }
            node.setFeats(featsMap);
            node.addFeature("head", headIndex);
            if (node.getId() == 0) {
                tree.getPaddingNode().setFeats(node.getFeats());
            } else {
                tree.add(node);
            }
        });
        tree.getPaddingNode().getFeats().remove("head");
        for (int i = 1; i < tree.size(); ++i) {
            DNode node = (DNode)tree.get(i);
            int headIndex = Integer.parseInt(node.getFeature("head"));
            DNode head = (DNode)tree.get(headIndex);
            head.addChild(node);
            node.getFeats().remove("head");
            node.setHead(head);
        }
        semanticHeadsMap.entrySet().parallelStream().map(e -> {
            DNode node = (DNode)tree.get((Integer)e.getKey());
            Map nodeSemanticInfo = (Map)e.getValue();
            for (Integer id : nodeSemanticInfo.keySet()) {
                node.addSemanticHead((DNode)tree.get(id), (String)nodeSemanticInfo.get(id));
                ((DNode)tree.get(id)).getSemanticChildren().add(node);
            }
            return null;
        }).collect(Collectors.toList());
        return tree;
    }
}

