/*
 * Decompiled with CFR 0.152.
 */
package org.maochen.nlp.ml;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.maochen.nlp.ml.vector.DenseVector;
import org.maochen.nlp.ml.vector.IVector;

public class Tuple {
    public int id;
    public String label;
    public IVector vector;
    private Map<String, Object> extra = null;

    public Tuple(IVector vector) {
        this.vector = vector;
        this.label = null;
    }

    public Tuple(int id, IVector vector, String label) {
        this.id = id;
        this.vector = vector;
        this.label = label;
    }

    public Tuple(double[] featureVector) {
        this.vector = new DenseVector(featureVector);
        this.label = null;
    }

    public Map<String, Object> getExtra() {
        return this.extra;
    }

    public void addExtra(String key, Object val) {
        if (this.extra == null) {
            this.extra = new HashMap<String, Object>();
        }
        this.extra.put(key, val);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.label).append(" ");
        stringBuilder.append(Arrays.toString(this.vector.getVector()));
        return stringBuilder.toString().trim();
    }
}

