/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.core.osm;

import java.util.List;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.impl.PackedCoordinateSequenceFactory;
import org.oscim.core.TagSet;
import org.oscim.core.osm.OsmElement;
import org.oscim.core.osm.OsmNode;

public class OsmWay
extends OsmElement {
    public final List<OsmNode> nodes;

    public OsmWay(TagSet tags, long id, List<OsmNode> nodes) {
        super(tags, id);
        this.nodes = nodes;
    }

    public boolean isClosed() {
        return this.nodes.size() > 0 && this.nodes.get(0).equals(this.nodes.get(this.nodes.size() - 1));
    }

    @Override
    public String toString() {
        return "w" + this.id;
    }

    @Override
    public Geometry toJts() {
        double[] coords = new double[this.nodes.size() * 2];
        int i = 0;
        for (OsmNode n : this.nodes) {
            coords[i++] = n.lon;
            coords[i++] = n.lat;
        }
        CoordinateSequence c = PackedCoordinateSequenceFactory.DOUBLE_FACTORY.create(coords, 2);
        return new LineString(c, null);
    }
}

