/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.overpass;

import org.oscim.core.BoundingBox;
import org.oscim.core.Tile;
import org.oscim.tiling.ITileDataSource;
import org.oscim.tiling.OverzoomTileDataSource;
import org.oscim.tiling.source.ITileDecoder;
import org.oscim.tiling.source.UrlTileDataSource;
import org.oscim.tiling.source.UrlTileSource;
import org.oscim.tiling.source.overpass.TileDecoder;
import org.oscim.utils.overpass.OverpassAPIReader;

public class OverpassTileSource
extends UrlTileSource {
    private static final String DEFAULT_URL = "https://www.overpass-api.de/api/interpreter?data=[out:json];";
    private static final String DEFAULT_PATH = "(node{{bbox}};way{{bbox}};>;);out%20body;";

    public static Builder<?> builder() {
        return new Builder();
    }

    public OverpassTileSource(Builder<?> builder) {
        super(builder);
        this.setUrlFormatter(new UrlTileSource.TileUrlFormatter(){

            public String formatTilePath(UrlTileSource tileSource, Tile tile) {
                BoundingBox bb = tile.getBoundingBox();
                String query = OverpassAPIReader.query(bb.getMinLongitude(), bb.getMaxLongitude(), bb.getMaxLatitude(), bb.getMinLatitude(), OverpassTileSource.DEFAULT_PATH);
                return query;
            }
        });
    }

    public ITileDataSource getDataSource() {
        return new OverzoomTileDataSource((ITileDataSource)new UrlTileDataSource((UrlTileSource)this, (ITileDecoder)new TileDecoder(), this.getHttpEngine()), this.mOverZoom);
    }

    public static class Builder<T extends Builder<T>>
    extends UrlTileSource.Builder<T> {
        public Builder() {
            super(OverpassTileSource.DEFAULT_URL, OverpassTileSource.DEFAULT_PATH);
            this.zoomMax(17);
        }

        public OverpassTileSource build() {
            return new OverpassTileSource(this);
        }
    }
}

