/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils.wkb;

abstract class ValueGetter {
    byte[] data;
    int position;
    final byte endian;

    ValueGetter(byte[] data, byte endian) {
        this.data = data;
        this.endian = endian;
    }

    byte getByte() {
        return this.data[this.position++];
    }

    int getInt() {
        int res = this.getInt(this.position);
        this.position += 4;
        return res;
    }

    long getLong() {
        long res = this.getLong(this.position);
        this.position += 8;
        return res;
    }

    protected abstract int getInt(int var1);

    protected abstract long getLong(int var1);

    double getDouble() {
        long bitrep = this.getLong();
        return Double.longBitsToDouble(bitrep);
    }

    static class NDR
    extends ValueGetter {
        static final byte NUMBER = 1;

        NDR(byte[] data) {
            super(data, (byte)1);
        }

        @Override
        protected int getInt(int index) {
            return ((this.data[index + 3] & 0xFF) << 24) + ((this.data[index + 2] & 0xFF) << 16) + ((this.data[index + 1] & 0xFF) << 8) + (this.data[index] & 0xFF);
        }

        @Override
        protected long getLong(int index) {
            return (long)(this.data[index + 7] & 0xFF) << 56 | (long)(this.data[index + 6] & 0xFF) << 48 | (long)(this.data[index + 5] & 0xFF) << 40 | (long)(this.data[index + 4] & 0xFF) << 32 | (long)(this.data[index + 3] & 0xFF) << 24 | (long)(this.data[index + 2] & 0xFF) << 16 | (long)(this.data[index + 1] & 0xFF) << 8 | (long)(this.data[index] & 0xFF) << 0;
        }
    }

    static class XDR
    extends ValueGetter {
        static final byte NUMBER = 0;

        XDR(byte[] data) {
            super(data, (byte)0);
        }

        @Override
        protected int getInt(int index) {
            return ((this.data[index] & 0xFF) << 24) + ((this.data[index + 1] & 0xFF) << 16) + ((this.data[index + 2] & 0xFF) << 8) + (this.data[index + 3] & 0xFF);
        }

        @Override
        protected long getLong(int index) {
            return (long)(this.data[index] & 0xFF) << 56 | (long)(this.data[index + 1] & 0xFF) << 48 | (long)(this.data[index + 2] & 0xFF) << 40 | (long)(this.data[index + 3] & 0xFF) << 32 | (long)(this.data[index + 4] & 0xFF) << 24 | (long)(this.data[index + 5] & 0xFF) << 16 | (long)(this.data[index + 6] & 0xFF) << 8 | (long)(this.data[index + 7] & 0xFF) << 0;
        }
    }
}

