/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils.wkb;

import org.oscim.core.GeometryBuffer;
import org.oscim.core.Tile;
import org.oscim.utils.wkb.ValueGetter;

public class WKBReader {
    private final GeometryBuffer mGeom;
    private final boolean mFlipY;
    private Callback mCallback;

    public WKBReader(GeometryBuffer geom, boolean flipY) {
        this.mGeom = geom;
        this.mFlipY = flipY;
    }

    public void setCallback(Callback cb) {
        this.mCallback = cb;
    }

    public void parse(byte[] value) {
        this.parseGeometry(WKBReader.valueGetterForEndian(value), 0);
    }

    public void parse(String value) {
        byte[] b = WKBReader.hexStringToByteArray(value);
        if (b == null) {
            return;
        }
        this.parse(b);
    }

    private void parseGeometry(ValueGetter data, int count) {
        boolean haveS;
        byte endian = data.getByte();
        if (endian != data.endian) {
            throw new IllegalArgumentException("Endian inconsistency!");
        }
        int typeword = data.getInt();
        int realtype = typeword & 0x1FFFFFFF;
        boolean haveZ = (typeword & Integer.MIN_VALUE) != 0;
        boolean haveM = (typeword & 0x40000000) != 0;
        boolean bl = haveS = (typeword & 0x20000000) != 0;
        if (haveS) {
            data.getInt();
        }
        switch (realtype) {
            case 1: {
                this.mGeom.startPoints();
                this.parsePoint(data, haveZ, haveM);
                break;
            }
            case 2: {
                this.mGeom.startLine();
                this.parseLineString(data, haveZ, haveM);
                break;
            }
            case 3: {
                this.mGeom.startPolygon();
                this.parsePolygon(data, haveZ, haveM);
                break;
            }
            case 4: {
                this.mGeom.startPoints();
                this.parseMultiPoint(data);
                break;
            }
            case 5: {
                this.mGeom.startLine();
                this.parseMultiLineString(data);
                break;
            }
            case 6: {
                this.mGeom.startPolygon();
                this.parseMultiPolygon(data);
                break;
            }
            case 7: {
                this.parseCollection(data);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Geometry Type: " + realtype);
            }
        }
        if (count == 0) {
            this.mCallback.process(this.mGeom);
            this.mGeom.clear();
        }
    }

    private void parsePoint(ValueGetter data, boolean haveZ, boolean haveM) {
        float x = (float)data.getDouble();
        float y = (float)data.getDouble();
        if (this.mFlipY) {
            y = (float)Tile.SIZE - y;
        }
        this.mGeom.addPoint(x, y);
        if (haveZ) {
            data.getDouble();
        }
        if (haveM) {
            data.getDouble();
        }
    }

    private void parseGeometryArray(ValueGetter data, int count, int type) {
        this.mGeom.clear();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                if (type == 2) {
                    this.mGeom.startLine();
                } else if (type == 3) {
                    this.mGeom.startPolygon();
                } else {
                    this.mCallback.process(this.mGeom);
                    this.mGeom.clear();
                }
            }
            this.parseGeometry(data, count);
        }
        this.mCallback.process(this.mGeom);
        this.mGeom.clear();
    }

    private void parseMultiPoint(ValueGetter data) {
        this.parseGeometryArray(data, data.getInt(), 1);
    }

    private void parseLineString(ValueGetter data, boolean haveZ, boolean haveM) {
        int count = data.getInt();
        for (int i = 0; i < count; ++i) {
            float x = (float)data.getDouble();
            float y = (float)data.getDouble();
            if (this.mFlipY) {
                y = (float)Tile.SIZE - y;
            }
            this.mGeom.addPoint(x, y);
            if (haveZ) {
                data.getDouble();
            }
            if (!haveM) continue;
            data.getDouble();
        }
    }

    private void parsePolygon(ValueGetter data, boolean haveZ, boolean haveM) {
        int count = data.getInt();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                this.mGeom.startHole();
            }
            int points = data.getInt();
            for (int j = 0; j < points; ++j) {
                float x = (float)data.getDouble();
                float y = (float)data.getDouble();
                if (this.mFlipY) {
                    y = (float)Tile.SIZE - y;
                }
                if (j < points - 1) {
                    this.mGeom.addPoint(x, y);
                }
                if (haveZ) {
                    data.getDouble();
                }
                if (!haveM) continue;
                data.getDouble();
            }
        }
    }

    private void parseMultiLineString(ValueGetter data) {
        int count = data.getInt();
        if (count <= 0) {
            return;
        }
        this.parseGeometryArray(data, count, 2);
    }

    private void parseMultiPolygon(ValueGetter data) {
        int count = data.getInt();
        if (count <= 0) {
            return;
        }
        this.parseGeometryArray(data, count, 3);
    }

    private void parseCollection(ValueGetter data) {
        int count = data.getInt();
        this.parseGeometryArray(data, count, 7);
        this.mCallback.process(this.mGeom);
        this.mGeom.clear();
    }

    private static ValueGetter valueGetterForEndian(byte[] bytes) {
        if (bytes[0] == 0) {
            return new ValueGetter.XDR(bytes);
        }
        if (bytes[0] == 1) {
            return new ValueGetter.NDR(bytes);
        }
        throw new IllegalArgumentException("Unknown Endian type:" + bytes[0]);
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        if (len < 2) {
            return null;
        }
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public static interface Callback {
        public void process(GeometryBuffer var1);
    }
}

