/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile;

import org.oscim.backend.canvas.Bitmap;
import org.oscim.core.MapElement;
import org.oscim.layers.tile.MapTile;
import org.oscim.layers.tile.TileManager;
import org.oscim.tiling.ITileDataSink;
import org.oscim.tiling.QueryResult;
import org.oscim.utils.PausableThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TileLoader
extends PausableThread
implements ITileDataSink {
    static final Logger log = LoggerFactory.getLogger(TileLoader.class);
    private static int id;
    private final String THREAD_NAME;
    private final TileManager mTileManager;
    protected MapTile mTile;

    public TileLoader(TileManager tileManager) {
        this.mTileManager = tileManager;
        this.THREAD_NAME = "TileLoader" + id++;
    }

    protected abstract boolean loadTile(MapTile var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void go() {
        TileLoader tileLoader = this;
        synchronized (tileLoader) {
            this.notify();
        }
    }

    @Override
    protected void doWork() {
        this.mTile = this.mTileManager.getTileJob();
        if (this.mTile == null) {
            return;
        }
        try {
            this.loadTile(this.mTile);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.completed(QueryResult.FAILED);
        }
    }

    @Override
    protected String getThreadName() {
        return this.THREAD_NAME;
    }

    @Override
    protected int getThreadPriority() {
        return 3;
    }

    @Override
    protected boolean hasWork() {
        return this.mTileManager.hasTileJobs();
    }

    public abstract void dispose();

    public abstract void cancel();

    @Override
    public void completed(QueryResult result) {
        boolean ok;
        boolean bl = ok = result == QueryResult.SUCCESS;
        if (ok && (this.isCanceled() || this.isInterrupted())) {
            result = QueryResult.FAILED;
        }
        this.mTileManager.jobCompleted(this.mTile, result);
        this.mTile = null;
    }

    @Override
    public void process(MapElement element) {
    }

    @Override
    public void setTileImage(Bitmap bitmap) {
    }
}

