/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile.example;

import org.oscim.backend.canvas.Paint;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.Tile;
import org.oscim.layers.tile.MapTile;
import org.oscim.layers.tile.TileLayer;
import org.oscim.layers.tile.TileLoader;
import org.oscim.layers.tile.TileManager;
import org.oscim.layers.tile.VectorTileRenderer;
import org.oscim.map.Map;
import org.oscim.renderer.bucket.LineBucket;
import org.oscim.renderer.bucket.RenderBuckets;
import org.oscim.theme.styles.LineStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTileLayer
extends TileLayer {
    static final Logger log = LoggerFactory.getLogger(TestTileLayer.class);

    public TestTileLayer(Map map) {
        super(map, new TileManager(map, 10), new VectorTileRenderer());
    }

    @Override
    protected TestTileLoader createLoader() {
        return new TestTileLoader(this);
    }

    static class TestTileLoader
    extends TileLoader {
        GeometryBuffer mGeom = new GeometryBuffer(128, 16);
        LineStyle mLineStyle = new LineStyle(-16776961, 2.0f, Paint.Cap.ROUND);

        public TestTileLoader(TileLayer tileLayer) {
            super(tileLayer.getManager());
        }

        @Override
        public boolean loadTile(MapTile tile) {
            log.debug("load tile " + tile);
            RenderBuckets buckets = new RenderBuckets();
            tile.data = buckets;
            LineBucket lb = buckets.getLineBucket(0);
            lb.line = this.mLineStyle;
            lb.scale = 2.0f;
            int m = 20;
            int s = Tile.SIZE - m * 2;
            GeometryBuffer g = this.mGeom;
            g.clear();
            g.startLine();
            g.addPoint(m, m);
            g.addPoint(m, s);
            g.addPoint(s, s);
            g.addPoint(s, m);
            g.addPoint(m, m);
            lb.addLine(g);
            return true;
        }

        @Override
        public void dispose() {
        }

        @Override
        public void cancel() {
        }
    }
}

