/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer;

import org.oscim.core.MapPosition;
import org.oscim.map.Map;
import org.oscim.map.Viewport;
import org.oscim.renderer.GLMatrix;

public class GLViewport
extends Viewport {
    public final GLMatrix viewproj;
    public final GLMatrix proj;
    public final GLMatrix view;
    public final float[] plane;
    public final GLMatrix mvp;
    public final MapPosition pos;
    protected boolean changed;

    public GLViewport() {
        this.viewproj = this.mViewProjMatrix;
        this.proj = this.mProjMatrix;
        this.view = this.mViewMatrix;
        this.plane = new float[8];
        this.mvp = new GLMatrix();
        this.pos = this.mPos;
    }

    public void useScreenCoordinates(boolean center, float scale) {
        float invScale = 1.0f / scale;
        if (center) {
            this.mvp.setScale(invScale, invScale, invScale);
        } else {
            this.mvp.setTransScale(-this.mWidth / 2.0f, -this.mHeight / 2.0f, invScale);
        }
        this.mvp.multiplyLhs(this.proj);
    }

    public void useScreenCoordinates(int width, int height, Position position, float xOffset, float yOffset, float scale) {
        float invScale = 1.0f / scale;
        float x = 0.0f;
        float y = 0.0f;
        switch (position) {
            case TOP_LEFT: {
                x = -this.mWidth * 0.5f + xOffset;
                y = -this.mHeight * 0.5f + yOffset;
                break;
            }
            case TOP_CENTER: {
                x = (float)(-width) * 0.5f + xOffset;
                y = -this.mHeight * 0.5f + yOffset;
                break;
            }
            case TOP_RIGHT: {
                x = this.mWidth * 0.5f - (float)width - xOffset;
                y = -this.mHeight * 0.5f + yOffset;
                break;
            }
            case CENTER_LEFT: {
                x = -this.mWidth * 0.5f + xOffset;
                y = (float)(-height) * 0.5f + yOffset;
                break;
            }
            case CENTER: {
                x = (float)(-width) * 0.5f + xOffset;
                y = (float)(-height) * 0.5f + yOffset;
                break;
            }
            case CENTER_RIGHT: {
                x = this.mWidth * 0.5f - (float)width - xOffset;
                y = (float)(-height) * 0.5f + yOffset;
                break;
            }
            case BOTTOM_LEFT: {
                x = -this.mWidth * 0.5f + xOffset;
                y = this.mHeight * 0.5f - (float)height - yOffset;
                break;
            }
            case BOTTOM_CENTER: {
                x = (float)(-width) * 0.5f + xOffset;
                y = this.mHeight * 0.5f - (float)height - yOffset;
                break;
            }
            case BOTTOM_RIGHT: {
                x = this.mWidth * 0.5f - (float)width - xOffset;
                y = this.mHeight * 0.5f - (float)height - yOffset;
            }
        }
        this.mvp.setTransScale(x, y, invScale);
        this.mvp.multiplyLhs(this.proj);
    }

    public boolean changed() {
        return this.changed;
    }

    void setFrom(Map map) {
        this.changed = map.viewport().getSyncViewport(this);
        this.getMapExtents(this.plane, 0.0f);
    }

    public float getWidth() {
        return this.mWidth;
    }

    public float getHeight() {
        return this.mHeight;
    }

    public static enum Position {
        TOP_LEFT,
        TOP_CENTER,
        TOP_RIGHT,
        CENTER_LEFT,
        CENTER,
        CENTER_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_CENTER,
        BOTTOM_RIGHT;

    }
}

