/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.oscim.utils.pool.Inlist;
import org.oscim.utils.pool.Pool;

public class NativeBufferPool
extends Pool<BufferItem> {
    private BufferItem mUsedBuffers;

    @Override
    protected BufferItem createItem() {
        return null;
    }

    public BufferItem get(int size) {
        BufferItem b = (BufferItem)this.mPool;
        if (b == null) {
            b = new BufferItem();
        } else {
            this.mPool = b.next;
            b.next = null;
        }
        if (b.size < size) {
            b.growBuffer(size);
        }
        this.mUsedBuffers = Inlist.push(this.mUsedBuffers, b);
        return b;
    }

    public void releaseBuffers() {
        this.mUsedBuffers = this.releaseAll(this.mUsedBuffers);
    }

    public ShortBuffer getShortBuffer(int size) {
        BufferItem b = this.get(size * 2);
        if (b.sBuffer == null) {
            b.byteBuffer.clear();
            b.sBuffer = b.byteBuffer.asShortBuffer();
        } else {
            b.sBuffer.clear();
        }
        return b.sBuffer;
    }

    public FloatBuffer getFloatBuffer(int size) {
        BufferItem b = this.get(size * 4);
        if (b.fBuffer == null) {
            b.byteBuffer.clear();
            b.fBuffer = b.byteBuffer.asFloatBuffer();
        } else {
            b.fBuffer.clear();
        }
        b.fBuffer.clear();
        return b.fBuffer;
    }

    public IntBuffer getIntBuffer(int size) {
        BufferItem b = this.get(size * 4);
        if (b.iBuffer == null) {
            b.byteBuffer.clear();
            b.iBuffer = b.byteBuffer.asIntBuffer();
        } else {
            b.iBuffer.clear();
        }
        return b.iBuffer;
    }

    static final class BufferItem
    extends Inlist<BufferItem> {
        ByteBuffer byteBuffer;
        ShortBuffer sBuffer;
        FloatBuffer fBuffer;
        IntBuffer iBuffer;
        int size;

        BufferItem() {
        }

        void growBuffer(int size) {
            if (size < 32768) {
                size = 32768;
            }
            this.byteBuffer = ByteBuffer.allocateDirect(size).order(ByteOrder.nativeOrder());
            this.size = size;
            this.sBuffer = null;
            this.iBuffer = null;
            this.fBuffer = null;
        }
    }
}

