/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme.rule;

import java.util.ArrayList;
import java.util.Collections;
import org.oscim.theme.IRenderTheme;
import org.oscim.theme.rule.Rule;
import org.oscim.theme.styles.RenderStyle;

public class RuleBuilder {
    private static final String[] EMPTY_KV = new String[0];
    public String cat;
    int zoom;
    int element;
    int selector;
    RuleType type;
    String[] keys;
    String[] values;
    ArrayList<RenderStyle> renderStyles = new ArrayList(4);
    ArrayList<RuleBuilder> subRules = new ArrayList(4);
    RenderStyle.StyleBuilder<?>[] styleBuilder;
    private static final String STRING_NEGATION = "~";
    private static final String STRING_EXCLUSIVE = "-";
    private static final String SEPARATOR = "\\|";

    public RuleBuilder(RuleType type, int element, int zoom, int selector, String[] keys, String[] values) {
        this.type = type;
        this.element = element;
        this.zoom = zoom;
        this.selector = selector;
        this.keys = keys;
        this.values = values;
    }

    public RuleBuilder(RuleType type, String[] keys, String[] values) {
        this.element = 7;
        this.zoom = -1;
        this.type = type;
        this.keys = keys;
        this.values = values;
    }

    public RuleBuilder() {
        this.type = RuleType.POSITIVE;
        this.element = 7;
        this.zoom = -1;
        this.keys = EMPTY_KV;
        this.values = EMPTY_KV;
    }

    public static RuleBuilder create(String keys, String values) {
        String[] keyList = EMPTY_KV;
        String[] valueList = EMPTY_KV;
        RuleType type = RuleType.POSITIVE;
        if (values != null) {
            if (values.startsWith(STRING_NEGATION)) {
                type = RuleType.NEGATIVE;
                if (values.length() > 2) {
                    valueList = values.substring(2).split(SEPARATOR);
                }
            } else if (values.startsWith(STRING_EXCLUSIVE)) {
                type = RuleType.EXCLUDE;
                if (values.length() > 2) {
                    valueList = values.substring(2).split(SEPARATOR);
                }
            } else {
                valueList = values.split(SEPARATOR);
            }
        }
        if (keys != null) {
            keyList = keys.split(SEPARATOR);
        }
        if (type != RuleType.POSITIVE && (keyList == null || keyList.length == 0)) {
            throw new IRenderTheme.ThemeException("negative rule requires key");
        }
        return new RuleBuilder(type, keyList, valueList);
    }

    public RuleBuilder zoom(byte zoomMin, byte zoomMax) {
        this.zoom = 0;
        for (int z = zoomMin; z <= zoomMax && z < 32; ++z) {
            this.zoom |= 1 << z;
        }
        return this;
    }

    public Rule onComplete(int[] level) {
        int i;
        RenderStyle[] styles = null;
        Rule[] rules = null;
        if (this.styleBuilder != null) {
            for (RenderStyle.StyleBuilder<?> style : this.styleBuilder) {
                this.renderStyles.add(((RenderStyle.StyleBuilder)style.level(level[0])).build());
                level[0] = level[0] + 2;
            }
        }
        if (this.renderStyles.size() > 0) {
            styles = new RenderStyle[this.renderStyles.size()];
            this.renderStyles.toArray(styles);
        }
        if (this.subRules.size() > 0) {
            rules = new Rule[this.subRules.size()];
            for (int i2 = 0; i2 < rules.length; ++i2) {
                rules[i2] = this.subRules.get(i2).onComplete(level);
            }
        }
        int numKeys = this.keys.length;
        int numVals = this.values.length;
        if (numKeys == 0 && numVals == 0) {
            return new Rule(this.element, this.zoom, this.selector, rules, styles).setCat(this.cat);
        }
        for (i = 0; i < numVals; ++i) {
            this.values[i] = this.values[i].intern();
        }
        for (i = 0; i < numKeys; ++i) {
            this.keys[i] = this.keys[i].intern();
        }
        if (this.type != RuleType.POSITIVE) {
            return new Rule.NegativeRule(this.type, this.element, this.zoom, this.selector, this.keys, this.values, rules, styles).setCat(this.cat);
        }
        if (numKeys == 1 && numVals == 0) {
            return new Rule.PositiveRuleK(this.element, this.zoom, this.selector, this.keys[0], rules, styles).setCat(this.cat);
        }
        if (numKeys == 0 && numVals == 1) {
            return new Rule.PositiveRuleV(this.element, this.zoom, this.selector, this.values[0], rules, styles).setCat(this.cat);
        }
        if (numKeys == 1 && numVals == 1) {
            return new Rule.PositiveRuleKV(this.element, this.zoom, this.selector, this.keys[0], this.values[0], rules, styles).setCat(this.cat);
        }
        return new Rule.PositiveRuleMultiKV(this.element, this.zoom, this.selector, this.keys, this.values, rules, styles).setCat(this.cat);
    }

    public RuleBuilder addStyle(RenderStyle style) {
        this.renderStyles.add(style);
        return this;
    }

    public RuleBuilder addSubRule(RuleBuilder rule) {
        this.subRules.add(rule);
        return this;
    }

    public RuleBuilder style(RenderStyle.StyleBuilder<?> ... styles) {
        this.styleBuilder = styles;
        return this;
    }

    public RuleBuilder rules(RuleBuilder ... rules) {
        Collections.addAll(this.subRules, rules);
        return this;
    }

    public RuleBuilder select(int selector) {
        this.selector = selector;
        return this;
    }

    public RuleBuilder zoom(int zoom) {
        this.zoom = zoom;
        return this;
    }

    public RuleBuilder element(int element) {
        this.element = element;
        return this;
    }

    public RuleBuilder cat(String cat) {
        this.cat = cat;
        return this;
    }

    public static enum RuleType {
        POSITIVE,
        NEGATIVE,
        EXCLUDE;

    }
}

