/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.oscim.core.Tile;
import org.oscim.tiling.source.HttpEngine;
import org.oscim.tiling.source.UrlTileSource;
import org.oscim.utils.ArrayUtils;
import org.oscim.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LwHttp
implements HttpEngine {
    static final Logger log = LoggerFactory.getLogger(LwHttp.class);
    static final boolean dbg = false;
    private static final byte[] HEADER_HTTP_OK = "200 OK".getBytes();
    private static final byte[] HEADER_CONTENT_LENGTH = "Content-Length".getBytes();
    private static final byte[] HEADER_CONNECTION_CLOSE = "Connection: close".getBytes();
    private static final byte[] HEADER_ENCODING_GZIP = "Content-Encoding: gzip".getBytes();
    private static final int RESPONSE_EXPECTED_LIVES = 100;
    private static final long RESPONSE_TIMEOUT = 10000000000L;
    private static final int CONNECT_TIMEOUT = 15000;
    private static final int SOCKET_TIMEOUT = 8000;
    private static final int BUFFER_SIZE = 8192;
    private final byte[] buffer = new byte[8192];
    private final String mHost;
    private final int mPort;
    private int mMaxRequests = 0;
    private Socket mSocket;
    private OutputStream mCommandStream;
    private Buffer mResponseStream;
    private long mLastRequest = 0L;
    private InetSocketAddress mSockAddr;
    private boolean mMustCloseConnection;
    private final byte[] REQUEST_GET_START;
    private final byte[] REQUEST_GET_END;
    private final byte[] mRequestBuffer;
    private final byte[][] mTilePath;
    private final UrlTileSource mTileSource;

    private LwHttp(UrlTileSource tileSource, byte[][] tilePath) {
        this.mTilePath = tilePath;
        this.mTileSource = tileSource;
        URL url = tileSource.getUrl();
        int port = url.getPort();
        if (port < 0) {
            port = 80;
        }
        this.mHost = url.getHost();
        this.mPort = port;
        String path = url.getPath();
        this.REQUEST_GET_START = ("GET " + path).getBytes();
        StringBuilder sb = new StringBuilder().append(" HTTP/1.1").append("\nUser-Agent: vtm/0.5.9").append("\nHost: ").append(this.mHost).append("\nConnection: Keep-Alive");
        for (Map.Entry<String, String> l : tileSource.getRequestHeader().entrySet()) {
            String key = l.getKey();
            String val = l.getValue();
            sb.append('\n').append(key).append(": ").append(val);
        }
        sb.append("\n\n");
        this.REQUEST_GET_END = sb.toString().getBytes();
        this.mRequestBuffer = new byte[1024];
        System.arraycopy(this.REQUEST_GET_START, 0, this.mRequestBuffer, 0, this.REQUEST_GET_START.length);
    }

    private void checkSocket() throws IOException {
        if (this.mSocket == null) {
            throw new IOException("No Socket");
        }
    }

    @Override
    public synchronized InputStream read() throws IOException {
        this.checkSocket();
        Buffer is = this.mResponseStream;
        is.mark(8192);
        is.start(8192);
        byte[] buf = this.buffer;
        boolean first = true;
        boolean gzip = false;
        int read = 0;
        int pos = 0;
        int end = 0;
        int len = 0;
        int contentLength = -1;
        while (pos < read || read < 8192 && (len = is.read(buf, read, 8192 - read)) >= 0) {
            read += len;
            while (end < read && buf[end] != 10) {
                ++end;
            }
            if (end == 8192) {
                throw new IOException("Header too large!");
            }
            if (buf[end] == 10) {
                if (end - pos == 1) {
                    ++end;
                    break;
                }
                if (first) {
                    first = false;
                    if (!LwHttp.check(HEADER_HTTP_OK, buf, pos + 9, end)) {
                        throw new IOException("HTTP Error: " + new String(buf, pos, end - pos - 1));
                    }
                } else if (LwHttp.check(HEADER_CONTENT_LENGTH, buf, pos, end)) {
                    contentLength = LwHttp.parseInt(buf, pos + HEADER_CONTENT_LENGTH.length + 2, end - 1);
                } else if (LwHttp.check(HEADER_ENCODING_GZIP, buf, pos, end)) {
                    gzip = true;
                } else if (LwHttp.check(HEADER_CONNECTION_CLOSE, buf, pos, end)) {
                    this.mMustCloseConnection = true;
                }
                pos += end - pos + 1;
                end = pos;
            }
            len = 0;
        }
        is.reset();
        is.mark(0);
        is.skip(end);
        is.start(contentLength);
        if (gzip) {
            return new GZIPInputStream(is);
        }
        return is;
    }

    @Override
    public synchronized void sendRequest(Tile tile) throws IOException {
        if (this.mSocket != null) {
            if (--this.mMaxRequests < 0) {
                this.close();
            } else if (System.nanoTime() - this.mLastRequest > 10000000000L) {
                this.close();
            } else {
                try {
                    int n = this.mResponseStream.available();
                    if (n > 0) {
                        log.debug("left over bytes {} ", (Object)n);
                        this.close();
                    }
                }
                catch (IOException e) {
                    log.debug(e.getMessage());
                    this.close();
                }
            }
        }
        if (this.mSocket == null) {
            this.lwHttpConnect();
            this.mMaxRequests = 100;
        }
        int pos = this.REQUEST_GET_START.length;
        int len = this.REQUEST_GET_END.length;
        pos = this.formatTilePath(tile, this.mRequestBuffer, pos);
        System.arraycopy(this.REQUEST_GET_END, 0, this.mRequestBuffer, pos, len);
        len += pos;
        try {
            this.writeRequest(len);
        }
        catch (IOException e) {
            log.debug("recreate connection");
            this.close();
            this.lwHttpConnect();
            this.writeRequest(len);
        }
    }

    private void writeRequest(int length) throws IOException {
        this.mCommandStream.write(this.mRequestBuffer, 0, length);
    }

    private synchronized void lwHttpConnect() throws IOException {
        if (this.mSockAddr == null || this.mSockAddr.isUnresolved()) {
            this.mSockAddr = new InetSocketAddress(this.mHost, this.mPort);
            if (this.mSockAddr.isUnresolved()) {
                throw new UnknownHostException(this.mHost);
            }
        }
        try {
            this.mSocket = new Socket();
            this.mSocket.setTcpNoDelay(true);
            this.mSocket.setSoTimeout(8000);
            this.mSocket.connect(this.mSockAddr, 15000);
            this.mCommandStream = this.mSocket.getOutputStream();
            this.mResponseStream = new Buffer(this.mSocket.getInputStream());
            this.mMustCloseConnection = false;
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        IOUtils.closeQuietly(this.mSocket);
        LwHttp lwHttp = this;
        synchronized (lwHttp) {
            this.mSocket = null;
            this.mCommandStream = null;
            this.mResponseStream = null;
        }
    }

    @Override
    public synchronized void setCache(OutputStream os) {
        if (this.mSocket == null) {
            return;
        }
        this.mResponseStream.setCache(os);
    }

    @Override
    public synchronized boolean requestCompleted(boolean ok) {
        if (this.mSocket == null) {
            return false;
        }
        this.mLastRequest = System.nanoTime();
        this.mResponseStream.setCache(null);
        if (!ok || this.mMustCloseConnection || !this.mResponseStream.finishedReading()) {
            this.close();
        }
        return ok;
    }

    private static int writeInt(int val, int pos, byte[] buf) {
        if (val == 0) {
            buf[pos] = 48;
            return pos + 1;
        }
        int i = 0;
        int n = val;
        while (n > 0) {
            buf[pos + i] = (byte)(48 + n % 10);
            n /= 10;
            ++i;
        }
        ArrayUtils.reverse(buf, pos, pos + i);
        return pos + i;
    }

    private static int parseInt(byte[] buf, int pos, int end) {
        int val = 0;
        while (pos < end) {
            val = val * 10 + buf[pos] - 48;
            ++pos;
        }
        return val;
    }

    private static boolean check(byte[] string, byte[] buffer, int position, int available) {
        int length = string.length;
        if (available - position < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (buffer[position + i] == string[i]) continue;
            return false;
        }
        return true;
    }

    private int formatTilePath(Tile tile, byte[] buf, int pos) {
        if (this.mTilePath == null) {
            String url = this.mTileSource.getUrlFormatter().formatTilePath(this.mTileSource, tile);
            byte[] b = url.getBytes();
            System.arraycopy(b, 0, buf, pos, b.length);
            return pos + b.length;
        }
        for (byte[] b : this.mTilePath) {
            if (b.length == 1) {
                if (b[0] == 47) {
                    buf[pos++] = 47;
                    continue;
                }
                if (b[0] == 88) {
                    pos = LwHttp.writeInt(tile.tileX, pos, buf);
                    continue;
                }
                if (b[0] == 89) {
                    pos = LwHttp.writeInt(tile.tileY, pos, buf);
                    continue;
                }
                if (b[0] == 90) {
                    pos = LwHttp.writeInt(tile.zoomLevel, pos, buf);
                    continue;
                }
            }
            System.arraycopy(b, 0, buf, pos, b.length);
            pos += b.length;
        }
        return pos;
    }

    public static class LwHttpFactory
    implements HttpEngine.Factory {
        private byte[][] mTilePath;

        @Override
        public HttpEngine create(UrlTileSource tileSource) {
            if (tileSource.getUrlFormatter() != UrlTileSource.URL_FORMATTER) {
                return new LwHttp(tileSource, null);
            }
            if (this.mTilePath == null) {
                String[] path = tileSource.getTilePath();
                this.mTilePath = new byte[path.length][];
                for (int i = 0; i < path.length; ++i) {
                    this.mTilePath[i] = path[i].getBytes();
                }
            }
            return new LwHttp(tileSource, this.mTilePath);
        }
    }

    static final class Buffer
    extends BufferedInputStream {
        OutputStream cache;
        int bytesRead = 0;
        int bytesWrote;
        int marked = -1;
        int contentLength;

        public Buffer(InputStream is) {
            super(is, 8192);
        }

        public void setCache(OutputStream cache) {
            this.cache = cache;
        }

        public void start(int length) {
            this.bytesRead = 0;
            this.bytesWrote = 0;
            this.contentLength = length;
        }

        public boolean finishedReading() {
            try {
                while (this.bytesRead < this.contentLength && this.read() >= 0) {
                }
            }
            catch (IOException e) {
                log.debug(e.getMessage());
            }
            return this.bytesRead == this.contentLength;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.marked = this.bytesRead;
            super.mark(readlimit);
        }

        @Override
        public synchronized long skip(long n) throws IOException {
            long sumSkipped = 0L;
            while (sumSkipped < n) {
                long skipped = super.skip(n - sumSkipped);
                if (skipped != 0L) {
                    sumSkipped += skipped;
                    continue;
                }
                if (this.read() < 0) break;
                ++sumSkipped;
                --this.bytesRead;
            }
            this.bytesRead = (int)((long)this.bytesRead + sumSkipped);
            return sumSkipped;
        }

        @Override
        public synchronized void reset() throws IOException {
            if (this.marked >= 0) {
                this.bytesRead = this.marked;
            }
            super.reset();
        }

        @Override
        public int read() throws IOException {
            if (this.bytesRead >= this.contentLength) {
                return -1;
            }
            int data = super.read();
            if (data >= 0) {
                ++this.bytesRead;
            }
            if (this.cache != null && this.bytesRead > this.bytesWrote) {
                this.bytesWrote = this.bytesRead;
                this.cache.write(data);
            }
            return data;
        }

        @Override
        public int read(byte[] buffer, int offset, int byteCount) throws IOException {
            if (this.bytesRead >= this.contentLength) {
                return -1;
            }
            int len = super.read(buffer, offset, byteCount);
            if (len <= 0) {
                return len;
            }
            this.bytesRead += len;
            if (this.cache != null && this.bytesRead > this.bytesWrote) {
                int add = this.bytesRead - this.bytesWrote;
                this.bytesWrote = this.bytesRead;
                this.cache.write(buffer, offset + (len - add), add);
            }
            return len;
        }
    }
}

