/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.mapfile;

import java.util.Locale;

public final class MapFileUtils {
    public static String extract(String s, String language) {
        if (s == null || s.trim().isEmpty()) {
            return null;
        }
        String[] langNames = s.split("\r");
        if (language == null || language.trim().isEmpty()) {
            return langNames[0];
        }
        String fallback = null;
        for (int i = 1; i < langNames.length; ++i) {
            String[] langName = langNames[i].split("\b");
            if (langName.length != 2) continue;
            if (langName[0].equalsIgnoreCase(language)) {
                return langName[1];
            }
            if (fallback != null || langName[0].contains("-") || !language.contains("-") && !language.contains("_") || !language.toLowerCase(Locale.ENGLISH).startsWith(langName[0].toLowerCase(Locale.ENGLISH))) continue;
            fallback = langName[1];
        }
        return fallback != null ? fallback : langNames[0];
    }

    private MapFileUtils() {
    }
}

