/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.mapfile;

import org.oscim.core.Tile;

public class Projection {
    public static double tileXToLongitude(long tileX, int zoomLevel) {
        return Projection.pixelXToLongitude(tileX * (long)Tile.SIZE, zoomLevel);
    }

    public static double tileYToLatitude(long tileY, int zoomLevel) {
        return Projection.pixelYToLatitude(tileY * (long)Tile.SIZE, zoomLevel);
    }

    public static long latitudeToTileY(double latitude, int zoomLevel) {
        return Projection.pixelYToTileY(Projection.latitudeToPixelY(latitude, zoomLevel), zoomLevel);
    }

    public static long longitudeToTileX(double longitude, int zoomLevel) {
        return Projection.pixelXToTileX(Projection.longitudeToPixelX(longitude, zoomLevel), zoomLevel);
    }

    public static int pixelXToTileX(double pixelX, int zoomLevel) {
        return (int)Math.min(Math.max(pixelX / (double)Tile.SIZE, 0.0), Math.pow(2.0, zoomLevel) - 1.0);
    }

    public static int pixelYToTileY(double pixelY, int zoomLevel) {
        return (int)Math.min(Math.max(pixelY / (double)Tile.SIZE, 0.0), Math.pow(2.0, zoomLevel) - 1.0);
    }

    public static double pixelXToLongitude(double pixelX, int zoomLevel) {
        return 360.0 * (pixelX / (double)((long)Tile.SIZE << zoomLevel) - 0.5);
    }

    public static double longitudeToPixelX(double longitude, int zoomLevel) {
        return (longitude + 180.0) / 360.0 * (double)((long)Tile.SIZE << zoomLevel);
    }

    public static double pixelYToLatitude(double pixelY, int zoomLevel) {
        double y = 0.5 - pixelY / (double)((long)Tile.SIZE << zoomLevel);
        return 90.0 - 360.0 * Math.atan(Math.exp(-y * (Math.PI * 2))) / Math.PI;
    }

    public static double latitudeToPixelY(double latitude, int zoomLevel) {
        double sinLatitude = Math.sin(latitude * (Math.PI / 180));
        return (0.5 - Math.log((1.0 + sinLatitude) / (1.0 - sinLatitude)) / (Math.PI * 4)) * (double)((long)Tile.SIZE << zoomLevel);
    }

    private Projection() {
    }
}

