/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.mapfile.header;

import org.oscim.tiling.source.mapfile.Projection;
import org.oscim.tiling.source.mapfile.header.SubFileParameterBuilder;

public class SubFileParameter {
    public static final byte BYTES_PER_INDEX_ENTRY = 5;
    private static final double COORDINATES_DIVISOR = 1000000.0;
    public final byte baseZoomLevel;
    public final int blockEntriesTableSize;
    public final long blocksHeight;
    public final long blocksWidth;
    public final long boundaryTileBottom;
    public final long boundaryTileLeft;
    public final long boundaryTileRight;
    public final long boundaryTileTop;
    public final long indexEndAddress;
    public final long indexStartAddress;
    public final long numberOfBlocks;
    public final long startAddress;
    public final long subFileSize;
    public final byte zoomLevelMax;
    public final byte zoomLevelMin;
    private final int hashCodeValue;

    SubFileParameter(SubFileParameterBuilder subFileParameterBuilder) {
        this.startAddress = subFileParameterBuilder.startAddress;
        this.indexStartAddress = subFileParameterBuilder.indexStartAddress;
        this.subFileSize = subFileParameterBuilder.subFileSize;
        this.baseZoomLevel = subFileParameterBuilder.baseZoomLevel;
        this.zoomLevelMin = subFileParameterBuilder.zoomLevelMin;
        this.zoomLevelMax = subFileParameterBuilder.zoomLevelMax;
        this.hashCodeValue = this.calculateHashCode();
        this.boundaryTileBottom = Projection.latitudeToTileY((double)subFileParameterBuilder.boundingBox.minLatitudeE6 / 1000000.0, this.baseZoomLevel);
        this.boundaryTileLeft = Projection.longitudeToTileX((double)subFileParameterBuilder.boundingBox.minLongitudeE6 / 1000000.0, this.baseZoomLevel);
        this.boundaryTileTop = Projection.latitudeToTileY((double)subFileParameterBuilder.boundingBox.maxLatitudeE6 / 1000000.0, this.baseZoomLevel);
        this.boundaryTileRight = Projection.longitudeToTileX((double)subFileParameterBuilder.boundingBox.maxLongitudeE6 / 1000000.0, this.baseZoomLevel);
        this.blocksWidth = this.boundaryTileRight - this.boundaryTileLeft + 1L;
        this.blocksHeight = this.boundaryTileBottom - this.boundaryTileTop + 1L;
        this.numberOfBlocks = this.blocksWidth * this.blocksHeight;
        this.indexEndAddress = this.indexStartAddress + this.numberOfBlocks * 5L;
        this.blockEntriesTableSize = 2 * (this.zoomLevelMax - this.zoomLevelMin + 1) * 2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SubFileParameter)) {
            return false;
        }
        SubFileParameter other = (SubFileParameter)obj;
        if (this.startAddress != other.startAddress) {
            return false;
        }
        if (this.subFileSize != other.subFileSize) {
            return false;
        }
        return this.baseZoomLevel == other.baseZoomLevel;
    }

    public int hashCode() {
        return this.hashCodeValue;
    }

    public String toString() {
        return "SubFileParameter [baseZoomLevel=" + this.baseZoomLevel + ", blockEntriesTableSize=" + this.blockEntriesTableSize + ", blocksHeight=" + this.blocksHeight + ", blocksWidth=" + this.blocksWidth + ", boundaryTileBottom=" + this.boundaryTileBottom + ", boundaryTileLeft=" + this.boundaryTileLeft + ", boundaryTileRight=" + this.boundaryTileRight + ", boundaryTileTop=" + this.boundaryTileTop + ", indexStartAddress=" + this.indexStartAddress + ", numberOfBlocks=" + this.numberOfBlocks + ", startAddress=" + this.startAddress + ", subFileSize=" + this.subFileSize + ", zoomLevelMax=" + this.zoomLevelMax + ", zoomLevelMin=" + this.zoomLevelMin + "]";
    }

    private int calculateHashCode() {
        int result = 7;
        result = 31 * result + (int)(this.startAddress ^ this.startAddress >>> 32);
        result = 31 * result + (int)(this.subFileSize ^ this.subFileSize >>> 32);
        result = 31 * result + this.baseZoomLevel;
        return result;
    }
}

